#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2018:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.toolbox.string_helper import split_and_strip_list


class Index(object):
    
    def __init__(self, property_name, getter, on_list):
        self.property_name = property_name
        if getter:
            self.getter = getter
        else:
            self.getter = self._get_value
        self.index = {}
        self.reverse_index = {}
        self.on_list = on_list
    
    
    def add_index(self, indexed_collection):
        for key_index, item in indexed_collection.items():
            self.index_item(item, key_index)
    
    
    def index_item(self, item, key_index):
        value_to_index = self.getter(item)
        
        if self.on_list:
            for v in value_to_index:
                self.index[v] = self.index.get(v, set())
                self.index[v].add(key_index)
                self.reverse_index[key_index] = self.reverse_index.get(key_index, set())
                self.reverse_index[key_index].add(v)
        else:
            self.index[value_to_index] = self.index.get(value_to_index, set())
            self.index[value_to_index].add(key_index)
            self.reverse_index[key_index] = self.reverse_index.get(key_index, set())
            self.reverse_index[key_index].add(value_to_index)
    
    
    def unindex_item(self, key_index):
        if key_index in self.reverse_index:
            all_values = self.reverse_index[key_index]
            for value in all_values:
                self.index[value].remove(key_index)
            del self.reverse_index[key_index]
    
    
    def find(self, value_search):
        return self.index.get(value_search, set())
    
    
    def _get_value(self, item, property_name=None):
        if not property_name:
            property_name = self.property_name
        
        ps = property_name.split('.', 1)
        p = ps[0]
        if len(ps) > 1:
            value = self._get_value(item.get(p, {}), ps[1])
        else:
            value = item.get(p, '')
        
        if self.on_list:
            value = split_and_strip_list(value)
        return value
