#!/usr/bin/python-shinken
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

"""
Register your migration hook function using the @weather_format_patch decorator

Each callback must take the weather dict to modify, and return None
Example:

@weather_format_patch
def add_grid_default(weather_data):  # The parameter name can be anything
    # type: (Dict[unicode, Any]) -> None
    # Do your stuff...
    return

N.B.: The functions will NOT always be called in the same order as the declaration
"""

from shinken.misc.type_hint import TYPE_CHECKING

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, Dict, Callable, TypeVar
    
    WeatherFormatPatchFunction = TypeVar('WeatherFormatPatchFunction', bound=Callable[[Dict[str, Any]], None])


def is_weather_format_patch(f):
    # type: (Any) -> bool
    return True if getattr(f, '__weather_format_patch__', False) else False


def weather_format_patch(f):
    # type: (WeatherFormatPatchFunction) -> WeatherFormatPatchFunction
    setattr(f, '__weather_format_patch__', True)
    return f
