#!/usr/bin/python-shinken
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

from shinken.misc.type_hint import TYPE_CHECKING
from ....utils.weather_tools import travel_dictionaries

if TYPE_CHECKING:
    from shinken.misc.type_hint import Any, Dict, List, Optional


# WEATHER CONSTANTS ARE FORBIDDEN HERE

def _parse_existing(grid, path, default_value='default'):
    # type: (Dict, unicode, Optional[Any]) -> Optional[Any]
    return travel_dictionaries(grid, path, default_value=default_value)


def generate_new_weather_external_links(external_links):
    # type: (Dict) -> Dict
    return {
        'links__default_link_protocol'        : _parse_link_protocol(external_links, is_layout=True) or _parse_existing(external_links, 'links__default_link_protocol', default_value='protocol_from_webui'),
        'links__default_base_url'             : _parse_link_base_url(external_links, is_layout=True) or _parse_existing(external_links, 'links__default_base_url'),
        'links__default_external_part_url'    : _parse_link_external_part_url(external_links) or _parse_existing(external_links, 'links__default_external_part_url'),
        'links__default_authentication_needed': _parse_link_authentication_needed(external_links) or _parse_existing(external_links, 'links__default_authentication_needed'),
        'links__default_info_bar'             : _parse_link_info_bar(external_links) or _parse_existing(external_links, 'links__default_info_bar', {}),
        'links'                               : _parse_links(external_links) or _parse_existing(external_links, 'links', []),
    }


def _parse_link_protocol(external_link, is_layout=False):
    # type: (Dict, bool) -> unicode
    base_url = _parse_existing(external_link, 'links__default_base_url' if is_layout else 'link_base_url', '')
    if base_url.startswith('http://'):
        to_return = 'http'
    elif base_url.startswith('https://'):
        to_return = 'https'
    else:
        to_return = 'protocol_from_webui'
    
    return to_return


def _parse_link_base_url(external_link, is_layout=False):
    # type: (Dict, bool) -> unicode
    to_return = ''
    base_url = _parse_existing(external_link, 'links__default_base_url' if is_layout else 'link_base_url', '')
    
    if base_url.startswith('http://'):
        to_return = base_url.replace('http://', '')
    elif base_url.startswith('https://'):
        to_return = base_url.replace('https://', '')
    return to_return


def _parse_link_external_part_url(external_link, is_layout=False):
    # type: (Dict, bool) -> unicode
    to_return = ''
    
    return to_return


def _parse_link_authentication_needed(external_link, is_layout=False):
    # type: (Dict, bool) -> bool
    to_return = False
    
    return to_return


def _parse_link_info_bar(external_link, is_layout=False):
    # type: (Dict, bool) -> Dict
    to_return = {}
    
    if not is_layout:
        to_return = {
            'position'        : _parse_existing(external_link, 'info_bar.position'),
            'background_color': _parse_existing(external_link, 'info_bar.background_color'),
            'logo_displayed'  : _parse_existing(external_link, 'info_bar.logo_displayed'),
            'refresh'         : {
                'chrono_displayed'         : _parse_existing(external_link, 'info_bar.refresh.chrono_displayed'),
                'generation_time_displayed': _parse_existing(external_link, 'info_bar.refresh.generation_time_displayed', default_value=_parse_existing(external_link, 'info_bar.refresh.text_displayed'))
            }
        }
    
    return to_return


def _parse_links(external_links):
    # type: (Dict) -> List
    to_return = []
    for link in _parse_existing(external_links, 'links', []):
        to_return.append({
            'link_name'             : _parse_existing(link, 'link_name'),
            'link_uuid'             : _parse_existing(link, 'link_uuid'),
            'link_protocol'         : _parse_link_protocol(link),
            'link_base_url'         : _parse_link_base_url(link) or _parse_existing(link, 'link_base_url'),
            'link_external_part_url': _parse_existing(link, 'link_external_part_url'),
            'authentication_needed' : _parse_existing(link, 'authentication_needed'),
            'info_bar'              : _parse_link_info_bar(link) or _parse_existing(link, 'info_bar')
        })
    
    return to_return
