#!/usr/bin/python-shinken
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2022:
# This file is part of Shinken Enterprise, all rights reserved.

"""
This module contains the patches to apply to a weather JSON in order to upgrade to the version : 3

Register your migration hook function using the @weather_format_patch decorator

Each callback must take the weather dict to modify, and return None
Example:

from ..patch_decorator import weather_format_patch

@weather_format_patch
def add_grid_default(weather_data):  # The parameter name can be anything
    # type: (Dict[unicode, Any]) -> None
    # Do your stuff...
    return

N.B.: The functions will NOT always be called in the same order as the declaration
"""

from shinken.misc.type_hint import TYPE_CHECKING

from ..patch_decorator import weather_format_patch

if TYPE_CHECKING:
    from shinken.misc.type_hint import Dict, Optional


######################################################
#  _   _
# | | | |
# | | | |___  ___ _ __ ___
# | | | / __|/ _ \ '__/ __|
# | |_| \__ \  __/ |  \__ \
#  \___/|___/\___|_|  |___/
######################################################


@weather_format_patch
def add_user_rights(weather_data):
    # type: (Dict) -> None
    weather_rights = weather_data.setdefault('users', {})
    if 'owner_user' in weather_rights:
        owner_user = weather_rights['owner_user']  # type: Dict[unicode, Optional[unicode]]
        _fill_user_dict_with_default_values(owner_user)
        _fill_user_dict_with_default_values(weather_rights.setdefault('creator_user', owner_user))
    else:
        _fill_user_dict_with_default_values(weather_rights.setdefault('owner_user', {}))
        _fill_user_dict_with_default_values(weather_rights.setdefault('creator_user', {}))
    _fill_user_dict_with_default_values(weather_rights.setdefault('previous_owner_user', {}))


def _fill_user_dict_with_default_values(user_dict):
    # type: (Dict[unicode, Optional[unicode]]) -> None
    user_dict.setdefault('user_uuid', None)
    user_dict.setdefault('user_name', None)


######################################################
#  _____    _            _   _ _
# |_   _|  | |          | | (_) |
#   | |  __| | ___ _ __ | |_ _| |_ _   _
#   | | / _` |/ _ \ '_ \| __| | __| | | |
#  _| || (_| |  __/ | | | |_| | |_| |_| |
#  \___/\__,_|\___|_| |_|\__|_|\__|\__, |
#                                   __/ |
#                                  |___/
######################################################


@weather_format_patch
def modify_weather_type(weather_data):
    # type: (Dict) -> None
    weather_identity = weather_data.setdefault('identification', {})
    weather_identity['type'] = 'service_weather'
