#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2013-2024
# This file is part of Shinken Enterprise, all rights reserved.

from shinkensolutions.api.synchronizer import ITEM_TYPE
from shinkensolutions.api.synchronizer.source.item.source_item import SourceItem


class SourceEscalation(SourceItem):
    __slots__ = SourceItem.__slots__ + [
        'last_notification',
        'uuid',
        'definition_order',
        'contacts',
        'last_notification_time',
        'escalation_options',
        'contact_groups',
        'escalation_name',
        'escalation_period',
        'first_notification_time',
        'first_notification',
        'notification_interval',
        'imported_from'
    ]
    
    
    def __init__(self):
        super(SourceEscalation, self).__init__()
        self.item_type = ITEM_TYPE.ESCALATIONS
