//noinspection JSUnusedGlobalSymbols
"use strict";
SHINKEN.DOCUMENTATION_DATA = {
    SHARE          : "share",
    WEATHER        : "weather",
    LIST           : "list",
    USER           : "user",
    JSON           : "json",
    WEATHER_HISTORY: "weather_history"
};

SHINKEN.DOCUMENTATION_DATA.__is_documentation = null;

SHINKEN.DOCUMENTATION_DATA.getDocumentationData           = function ( type_documentation ) {
    let to_return = null;
    if ( SHINKEN.DOCUMENTATION_DATA.__parsed_documentation[ type_documentation ] ) {
        try {
            to_return = SHINKEN.DOCUMENTATION_DATA[ type_documentation + "-" + SHINKEN.DOCUMENTATION_DATA.__parsed_documentation[ type_documentation ] ];
        }
        catch ( e ) {
        }
        if ( !to_return ) {
            let string = `Valeur ${SHINKEN.DOCUMENTATION_DATA.__parsed_documentation[ type_documentation ]} pour la clé ${type_documentation} inexistante`;
            SHINKEN.TOOLS.NOTIFICATION.addNotification( string, SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.WARNING );
        }
    }
    return to_return;
};
SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated = function ( type_documentation ) {
    return !!SHINKEN.DOCUMENTATION_DATA[ type_documentation + "-" + SHINKEN.DOCUMENTATION_DATA.__parsed_documentation[ type_documentation ] ];
};
SHINKEN.DOCUMENTATION_DATA.isDocumentationModeOn          = function () {
    let to_return = window.parent.parent.SHINKEN.HIGHWAY.getParams( "shinken_documentation" );
    if ( to_return ) {
        SHINKEN.DOCUMENTATION_DATA.__parsed_documentation = SHINKEN.DOCUMENTATION_DATA.parseDocumentationValues( to_return.split( ',' ) );
    }
    return !!to_return;
};
SHINKEN.DOCUMENTATION_DATA.isDocumentationModeOn          = function () {
    let to_return = window.parent.parent.SHINKEN.HIGHWAY.getParams( "shinken_documentation" );
    if ( to_return ) {
        SHINKEN.DOCUMENTATION_DATA.__parsed_documentation = SHINKEN.DOCUMENTATION_DATA.parseDocumentationValues( to_return.split( ',' ) );
    }
    return !!to_return;
};


SHINKEN.DOCUMENTATION_DATA.parseDocumentationValues = function ( to_parse_to_array ) {
    let _to_return   = {};
    let split_object;
    let key;
    let string_error = "";
    to_parse_to_array.forEach( function ( item ) {
        split_object = item.split( '-' );
        key          = split_object[ 0 ];
        if ( SHINKEN.TOOLS.ARRAY.contains( SHINKEN.DOCUMENTATION_DATA.AUTHORIZED_KEYS, key ) ) {
            _to_return[ key ] = split_object[ 1 ];
        }
        else {
            if ( string_error ) {
                string_error += ",";
            }
            string_error += key;
        }
    } );
    if ( string_error ) {
        string_error = string_error + " is not a valid documentation key<br>Valid keys =>" + SHINKEN.DOCUMENTATION_DATA.AUTHORIZED_KEYS + "<br>exemple => ?shinken_documentation=share-2,weather-1";
        console.error( "[DOCUMENTATION_DATA - parseDocumentationValues]", string_error );
        SHINKEN.TOOLS.NOTIFICATION.addNotification( string_error, SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.ERROR );
    }
    return _to_return;
};

SHINKEN.HIGHWAY.isDocumentationOn = function () {
    if ( SHINKEN.DOCUMENTATION_DATA.__is_documentation === null ) {
        SHINKEN.DOCUMENTATION_DATA.__is_documentation = SHINKEN.DOCUMENTATION_DATA.isDocumentationModeOn();
    }
    return SHINKEN.DOCUMENTATION_DATA.__is_documentation;
};

document.addEventListener( "DOMContentLoaded", function ( e ) {
    //******************************************** FUNCTION OVERRIDE FOR DOCUMENTATION **************************//
    if ( CONTROLLER.Weather && WEATHER && WEATHER.PageContent && SHINKEN.HIGHWAY.isDocumentationOn() && SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.WEATHER ) ) {
        WEATHER.PageContent.prototype.computeData = function ( data ) {
            console.log( "[Weather - computeData]", "[OVERRIDE BY DOCUMENTATION]", "[WEATHER]" );
            data = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.WEATHER ) || data;
            this.grids.updateContentData( data );
        };
    }
    if ( CONTROLLER.Share && SHINKEN.HIGHWAY.isDocumentationOn() && SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.SHARE ) ) {
        CONTROLLER.Share.loadSharesFromAngular = function ( param ) {
            console.log( "[Share - loadSharesFromAngular]", "[OVERRIDE BY DOCUMENTATION]", "[SHARE]" );
            param                = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.SHARE ) || param;
            self.share_data      = param;
            self.share_data_used = false;
            return param;
        };
    }
    if ( CONTROLLER.UiVisualisation && SHINKEN.HIGHWAY.isDocumentationOn() ) {
        if ( SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.LIST ) ) {
            CONTROLLER.UiVisualisation.loadGridDataFromAngular = function ( param ) { //WARNING OVERRIDE IN DOCUMENTATION
                console.log( "List", "[UiVisualisation - loadGridDataFromAngular]", "[LIST]" );
                var to_return = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.LIST );
                return to_return || param;
            };
        }
        else if ( SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.USER ) ) {
            CONTROLLER.UiVisualisation.setUserData = function ( data_user ) {
                console.log( "[UiVisualisation - setUserData]", "[OVERRIDE BY DOCUMENTATION]", "[USER]" );
                data_user = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.USER ) || data_user;
                CONTROLLER.UiVisualisation.current_user.updateData( data_user );
                return data_user;
            };
        }
    }
    
    if ( CONTROLLER.Weather && WEATHER && (WEATHER.PageContent || SHINKEN_LIST) && SHINKEN_LIST.LineUIView && SHINKEN.HIGHWAY.isDocumentationOn() && SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.WEATHER_HISTORY ) ) {
        WEATHER.ViewHistory.prototype.getHistoryDataFromBackend = function ( url ) {
            console.log( "[ViewHistory - getHistoryDataFromBackend]", "[OVERRIDE BY DOCUMENTATION]", "[WEATHER HISTORY]" );
            let history_data = SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.WEATHER_HISTORY );
            this.formatAndApplyData( history_data );
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_TO_STRING );
        };
    }
    if ( CONTROLLER.Weather && WEATHER && WEATHER.PageEdit && SHINKEN.HIGHWAY.isDocumentationOn() && SHINKEN.DOCUMENTATION_DATA.isThisDocumentationModeNeedToBeActivated( SHINKEN.DOCUMENTATION_DATA.JSON ) ) {
        WEATHER.PageEdit.prototype.actionsAfterGetData = function ( _status, data ) {
            console.log( "[ViewHistory - getHistoryDataFromBackend]", "[OVERRIDE BY DOCUMENTATION]", "[ WEATHER JSON ]" );
            this.updateUserPrefsFromBackendData();
            this.updateObject( SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.JSON ), true );
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
        };
        WEATHER.PageEdit.prototype.updateDataForEdit   = function ( data ) {
            this.updateObject( SHINKEN.DOCUMENTATION_DATA.getDocumentationData( SHINKEN.DOCUMENTATION_DATA.JSON ) );
            //this.edition_panel.setLoading( _( "edit_mode.loading_message.get_json" ) );
            this.setPhaseWithTimeOut( SHINKEN.OBJECT.CONST.PHASE.ASKING_SHOW_FORM, 600 );
        };
    }
} );