'use strict';
var SHINKEN         = SHINKEN || {};
SHINKEN.OBJECT      = SHINKEN.OBJECT || {};
SHINKEN.OBJECT.FORM = {};
"use strict";
var PROPERTY = PROPERTY || {};
PROPERTY.CONST = PROPERTY.CONST || {};
PROPERTY.CONST.COMMON = {
    TYPES           : {
        BOOLEAN                   : "boolean",
        DATA                      : "data",
        MULTI_SELECT              : "select-multi",
        MULTI_SELECT_BASIC        : "select-multi-basic",
        RANGE                     : "range",
        RANGE_BUSINESS_IMPACT     : "range_business_impact",
        RANGE_WITH_INPUT          : "range_with_input",
        SINGLE_SELECT             : "select-single",
        SINGLE_SELECT_WITH_INPUT  : "select-single-with-input",
        STRING_INPUT              : "input_string",
        STRING_INPUT_WITH_DROPDOWN: "input-string-with-dropdown",
        CHECKBOX_SINGLE           : "checkbox-single",
        CHECKBOX_MULTI            : "checkbox-multi",
        RADIO_LIST                : "radio-list",
        RADIO_LIST_CUMULATIVE     : "radio-list-cumulative",
        MULTI_LINE_OBJECT         : "multi-line-object",
        PROPERTY_INFORMATION      : "property-information"
    },
    VALUE           : {
        DEFAULT: "default"
    }
};
PROPERTY.AbstractCommon = function () {
};
PROPERTY.AbstractCommon.prototype = {
    ___updateView: function () {
    },
    ___unset    : function () {
    },
    getSelector : function () {
    },
    getValue    : function () {
        console.error( "[Abstract - getValue]", "[NOT IMPLEMENTED]", this.type );
    },
    getFlatValue: function () {
        console.error( "[Abstract - getFlatValue]", "[NOT IMPLEMENTED]", this.type );
    },
    ___clickOnItemSelector : function ( _target_component, key_name ) {
    },
    ___clickOnCheckboxInput: function ( name ) {
    },
    ___clickOnRadioBtn     : function ( value ) {
    },
    ___onFocusOut          : function ( dom_element ) {
    },
    ___hidePopup           : function () {
    }
};
PROPERTY.InterfaceCommon = function () {
};
PROPERTY.InterfaceCommon.prototype = {
    onFocus                : function () {
    },
    onFocusOut             : function ( dom_element ) {
        this.___onFocusOut( dom_element );
    },
    clickOnItemSelector_end: function ( target_component, key_name, dom_element ) {
        this.___clickOnItemSelector( target_component, key_name, dom_element );
    },
    clickOnInput           : function () {
        this.hidePopup();
    },
    clickOnCheckboxInput   : function ( name ) {
        this.___clickOnCheckboxInput( name );
    },
    clickOnRadioBtn        : function ( value ) {
        if ( this.is_disabled ) {
            return;
        }
        this.___clickOnRadioBtn( value );
    },
    keydown                : function ( event, key_code ) {
    },
    getName            : function () {
        return this.name;
    },
    getUUID            : function () {
        return this.getName();
    },
    getLabelViaDom     : function () {
        return this.dom_element.querySelector( '.shinken-property-label .shinken-label' ).innerText;
    },
    getNameOrUUID      : function () {
        return this.getName();
    },
    getParentName      : function () {
        return this.name;
    },
    getState           : function () {
        return this.state;
    },
    setState           : function ( _to_set ) {
        this.state = _to_set;
        DOM.Service.setDataSet( this.dom_element, 'state', this.state );
    },
    setLastItemSelected: function ( _to_set ) {
        this.last_list_element_selected = _to_set;
    },
    getValue           : function () {
        return this.value;
    },
    setValue           : function ( _to_set ) {
        this.value = _to_set;
    },
    isSet              : function () {
        var _to_return = this.getValue();
        return !!_to_return;
    },
    setIsDisable       : function ( to_set ) {
        if ( to_set && !this.is_disabled ) {
            this.dom_element.classList.add( 'shinken-disabled' );
        }
        else if ( !to_set && this.is_disabled ) {
            this.dom_element.classList.remove( 'shinken-disabled' );
        }
        this.is_disabled = to_set;
    },
    setIsRequired      : function ( to_set ) {
        this.is_required = to_set;
    },
    unset              : function () {
        this.___unset();
    },
    setValueFromUser   : function () {
        console.warn( "setValueFromUser", "[TYPE NOT MANAGED]", this.type );
    },
    isDifferentValue   : function ( value1, value2 ) {
        return value1 !== value2 && SHINKEN.TOOLS.STRING.unescape_xss( value1 ) !== SHINKEN.TOOLS.STRING.unescape_xss( value2 );
    },
    _computeState: function () {
    },
    computeHtml_common: function () {
    
    },
    hidePopup        : function ( exception ) {
        this.___hidePopup( exception );
    },
    updateView       : function () {
        this.___updateView();
    },
    getFlatValueLabel: function () {
    },
    getDataToSave: function () {
        return this.getDataToSaveFinal();
    },
    onClick      : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommon, PROPERTY.AbstractCommon );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommon, SHINKEN.OBJECT.CounterInterface );
PROPERTY.InterfaceCommonFromHtml = function () {
};
PROPERTY.InterfaceCommonFromHtml.prototype = {
    initWithDomElement: function ( element ) {
        this.name             = element.dataset.name;
        this.type             = element.dataset.type;
        this.dom_element      = element;
        this.default_value    = element.dataset.defaultValue;
        this.parent_container = null;
        this.is_disabled      = element.classList.contains( 'shinken-disabled' );
        this.initCounters( null, true );
        this.setIsRequired( element.dataset.isRequired );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromHtml, PROPERTY.InterfaceCommon );
PROPERTY.InterfaceCommonFromData = function () {
};
PROPERTY.InterfaceCommonFromData.prototype = {
    computeHtml_getClassContainer       : function () {
        return "shinken-element-property-line shinken-parent-event-listener";
    },
    computeHtml_getType                 : function () {
        return "";
    },
    computeHtml_getAttribute            : function () {
        var _to_return                        = this.computeHtml_getAttributeSpecific();
        _to_return[ "class" ]                 = this.computeHtml_getClassContainer();
        _to_return[ "onmouseenter" ]          = "MANAGER.EventManager.mouseEnter(event)";
        _to_return[ "onmouseleave" ]          = "MANAGER.EventManager.mouseLeave(event)";
        _to_return[ "onclick" ]               = "MANAGER.EventManager.onClick(event)";
        _to_return[ "data-controller" ]       = this.controller_name || CONTROLLER.CONST.FORM_CONTROLLER.NAME;
        _to_return[ "data-type" ]             = this.computeHtml_getType();
        _to_return[ "data-name" ]             = this.getName();
        _to_return[ "data-visibility-state" ] = this.getVisibilityState();
        return _to_return;
    },
    computeHtml_getAttributeSpecific    : function () {
        return {};
    },
    computeHtml_getCellPropAction       : function () {
        this.dom_cell_action = DOM.Service.createElement( "td", { class: "shinken-prop-cell-action" } );
        this.computeHtml_getCellPropActionContent();
        this.addDomElement( this.dom_cell_action );
    },
    computeHtml_getCellPropActionContent: function () {
    },
    computeHtml_container               : function () {
        this.label_common = new PROPERTY.LabelCommonFromData( this.getName(), this.getLabel() || this.getName() );
        this.label_common.computeHtml();
        this.setDomElement( DOM.Service.createElement( "tr", this.computeHtml_getAttribute() ) );
        this.addDomElement( this.label_common.getDomElement() );
        this.computeHtml_getCellPropAction();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromData, PROPERTY.InterfaceCommon );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceCommonFromData, SHINKEN.OBJECT.ShinkenObjectHtml );
PROPERTY.LabelCommonFromData           = function ( name, label ) {
    this.name  = name;
    this.label = label;
};
PROPERTY.LabelCommonFromData.prototype = {
    computeHtml: function () {
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-prop-cell-label" } ) );
        var _table        = DOM.Service.addElementTo( DOM.Service.createElement( "table", { class: "shinken-width-100" } ), this.getDomElement() );
        var _tr           = DOM.Service.addElementTo( DOM.Service.createElement( "tr", { class: "shinken-width-100" } ), _table );
        var _td_1         = DOM.Service.addElementTo( DOM.Service.createElement( "td", {} ), _tr );
        var _div_1        = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-prop-cell-label-container" } ), _td_1 );
        var _table_1      = DOM.Service.addElementTo( DOM.Service.createElement( "table" ), _div_1 );
        var _tr_1_1       = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table_1 );
        var _td_1_1       = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-property-label" } ), _tr_1_1 );
        var _span_1_1_1   = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter shinken-error-counter", "data-number": "" } ), _td_1_1 );
        var _span_1_1_1_1 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter-label" } ), _span_1_1_1 );
        var _span_1_1_2   = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter shinken-warning-counter", "data-number": "" } ), _td_1_1 );
        var _span_1_1_2_1 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-counter-label" } ), _span_1_1_2 );
        var _span_1_1_3   = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-label" }, this.label ), _td_1_1 );
        
        var _tr_1_2       = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table_1 );
        var _td_1_2       = DOM.Service.addElementTo( DOM.Service.createElement( "td" ), _tr_1_2 );
        var _span_1_2_1   = DOM.Service.addElementTo( DOM.Service.createElement( "span", {
            class         : "shinken-information-tag",
            onmouseenter  : "SHINKEN_TOOLTIP.showTooltip(this)",
            onMouseLeave  : "SHINKEN_TOOLTIP.hideTooltip()",
            "shi-tip-html": ""
        } ), _td_1_2 );
        var _span_1_2_1_1 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-label-information" } ), _span_1_2_1 );
        var _span_1_2_1_2 = DOM.Service.addElementTo( DOM.Service.createElement( "span", { class: "shinken-tag-mark" }, "?" ), _span_1_2_1 );
        
        var _td_2  = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-tag-help-cell" } ), _tr );
        var _div_2 = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-tag-help shinken-user-select-none", onclick: "MANAGER.EventManager.clickOnForcedHelpButton(event,this)" }, "?" ), _td_2 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.LabelCommonFromData, SHINKEN.OBJECT.ShinkenObjectHtml );
PROPERTY.InterfaceSelectAbstract           = function () {
};
PROPERTY.InterfaceSelectAbstract.prototype = {
    ___unset   : function () {
        this.setValueFromUser( '', '' );
    },
    getSelector: function ( selector_name ) {
        if ( !selector_name || selector_name === COMPONENT.CONST.SELECT.NAME_MAIN_SELECTOR ) {
            return this.component_selector;
        }
        console.log("[InterfaceSelectAbstract - getSelector]", "[TO BE DEV]" );
    },
    ___hidePopup          : function ( exception ) {
        if ( exception !== this.getSelector() ) {
            this.getSelector().hidePopup();
        }
    },
    ___clickOnItemSelector: function ( _target_component, key_name ) {
        this.setLastItemSelected( key_name );
        this.getSelector().clickOnItemSelector( this.name, key_name );
        this.updateView();
        return true;
    },
    ___updateView      : function () {
        this._computeState();
    },
    _computeLabelSelect: function () {
    },
    
    doFilter: function ( dom_element, filter ) {
        var _target_component = this.getSelectViaDomElement( dom_element );
        _target_component.doFilter( filter );
    },
    keydown: function ( event, key_code ) {
        switch ( key_code ) {
            case SHINKEN.CONST.KEY_CODE.DOWN:
                this.getSelectViaDomElement( event.target ).moveAutoSelectCursor( true );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.UP:
                this.getSelectViaDomElement( event.target ).moveAutoSelectCursor( false );
                event.preventDefault();
                break;
            case SHINKEN.CONST.KEY_CODE.ENTER:
                this.getSelectViaDomElement( event.target ).validAutoSelect();
                event.preventDefault();
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectAbstract, PROPERTY.InterfaceCommon );
PROPERTY.InterfaceSelectFromHtml           = function ( dom_element ) {
};
PROPERTY.InterfaceSelectFromHtml.prototype = {
    initMainSelector: function () {
        this.component_selector = new COMPONENT.Select( this.dom_element.querySelector( '.shinken-select-container[data-name="' + PROPERTY.CONST.SELECTOR.MAIN + '"]' ), this.type, false, this );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectFromHtml, PROPERTY.InterfaceSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectFromHtml, PROPERTY.InterfaceSelectFromHtml );
PROPERTY.InterfaceSelectFromData           = function () {
};
PROPERTY.InterfaceSelectFromData.prototype = {};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectFromData, PROPERTY.InterfaceSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.InterfaceSelectFromData, PROPERTY.InterfaceCommonFromData );
"use strict";
SHINKEN.OBJECT.FormSet           = function ( name ) {
    this.init( name );
};
SHINKEN.OBJECT.FormSet.prototype = {
    init: function ( name ) {
        this.name = name;
        this.initContents();
    },
    doActionAfter : function ( event_name, param ) {
        this._doActionAfter( event_name, param );
    },
    _doActionAfter: function ( event_name, param ) {
    },
    hidePopup     : function ( property_name_exception ) {
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( _current.getName() !== property_name_exception ) {
                _current.hidePopup();
            }
        }
    },
    
    getName             : function () {
        return this.name;
    },
    isValid             : function () {
        return this.status !== COMPONENT.CONST.STATUS.ERROR;
    },
    computeFooterContent: function () {
        this.footer_content = null;
    },
    getFooterContent    : function () {
        return this.footer_content;
    },
    getDataToSave: function ( type ) {
        var _to_return = {};
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( _current.getVisibilityState() === SHINKEN.CONST.VISIBILITY_STATE.TOTALLY_FORM_EXCLUDE ) {
                continue;
            }
            _to_return[ _current.getName() ] = _current.getDataToSave();
        }
        return _to_return;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.FormSet, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
COMPONENT.RadioListGeneric           = function ( dom_element, parent ) {
    this.init( dom_element, parent );
};
COMPONENT.RadioListGeneric.prototype = {
    init: function ( dom_element, parent ) {
        this.dom_element = dom_element;
        this.initContents();
        this.initCounters( parent );
        this.initListContent( dom_element );
    },
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "value_changed":
                this.clickOnRadioBtn( param );
                break;
        }
    },
    setValueFromUser: function ( to_set ) {
        this.clickOnRadioBtn( to_set );
    },
    
    initListContent: function ( dom_element ) {
        var _list_dom = dom_element.querySelectorAll( '.shinken-radio-element' );
        var _current;
        
        for ( var i = 0, _size = _list_dom.length; i < _size; i++ ) {
            _current = new COMPONENT.Generic( _list_dom[ i ] );
            _current.initCounters( this );
            _current.computeCounters();
            this.add( _current );
            if ( _current.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.active_button = _current;
            }
        }
        
    },
    clickOnRadioBtn: function ( value ) {
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this.active_button = this.getContentByUUID( value );
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    getValue       : function () {
        return this.active_button.getValue();
    },
    isDefaultOn    : function () {
        var _element = this.getContentByUUID( COMPONENT.CONST.BTN_NAME.DEFAULT );
        if ( _element ) {
            return _element.isOn();
        }
        return false;
    },
    setDefault     : function ( to_set ) {
        var _element = this.getContentByUUID( COMPONENT.CONST.BTN_NAME.DEFAULT );
        if ( _element ) {
            _element.setState( to_set );
        }
    },
    setDefaultValue: function ( to_set ) {
        this.dom_element.setAttribute( "data-default-value", to_set );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGeneric, COMPONENT.Interface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGeneric, SHINKEN.OBJECT.ShinkenObjectContainer );
COMPONENT.RadioListGenericV2           = function () {
    this.init();
};
COMPONENT.RadioListGenericV2.prototype = {
    init           : function () {
        this.initContents();
        this.initListContent();
    },
    initListContent: function () {
    },
    setValueFromUser: function ( to_set ) {
        this.clickOnRadioBtn( to_set );
    },
    clickOnRadioBtn : function ( value ) {
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.OFF );
        }
        this.active_button = this.getContentByUUID( value );
        if ( this.active_button ) {
            this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    },
    getValue        : function () {
        return this.active_button.getValue();
    },
    setButtonVisibilityState: function ( button_name, to_set ) {
        this.getContentByUUID( button_name ).setVisibilityState( to_set );
    },
    setButtonTooltip: function ( button_name, to_set, tooltip_type ) {
        this.getContentByUUID( button_name ).setTooltipHtml( to_set, tooltip_type );
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGenericV2, COMPONENT.Interface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListGenericV2, SHINKEN.OBJECT.ShinkenObjectContainer );
COMPONENT.RadioListButtons           = function ( dom_element, parent ) {
    this.initSpecific( dom_element, parent );
};
COMPONENT.RadioListButtons.prototype = {
    initSpecific: function ( dom_element, parent ) {
        this.init();
    },
    initListContent: function ( dom_element ) {
        var _list_dom = dom_element.querySelectorAll( '.shinken-radio-btn' );
        var _current;
        
        for ( var i = 0, _size = _list_dom.length; i < _size; i++ ) {
            _current = new COMPONENT.Button( _list_dom[ i ] );
            _current.initCounters( this );
            _current.computeCounters();
            this.radio_buttons.push( _current );
            this.mapping_radio_button[ _current.getValue() ] = i;
            if ( _current.state === COMPONENT.CONST.BTN_STATE.ON ) {
                this.active_button = _current;
            }
        }
        
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListButtons, COMPONENT.RadioListGeneric );
COMPONENT.RadioListFromData           = function ( data_buttons, property_name ) {
    this.initSpecific( data_buttons, property_name );
};
COMPONENT.RadioListFromData.prototype = {
    initSpecific   : function ( data_buttons, property_name ) {
        this.property_name = property_name;
        this.data_buttons  = data_buttons;
        this.init();
    },
    initListContent: function () {
        var _current;
        for ( var i = 0, _size_i = this.data_buttons.length; i < _size_i; i++ ) {
            _current = this.add( new COMPONENT.RadioButtonFromData( this.data_buttons[ i ].name, this.data_buttons[ i ].label, this.property_name ) );
            if ( this.event_name ) {
                _current.computeHtml_setEventName( this.event_name );
            }
            if ( this.data_buttons[ i ].is_active ) {
                this.active_button = _current;
                this.active_button.setState( COMPONENT.CONST.BTN_STATE.ON );
            }
        }
    },
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "div", { class: "shinken-btn-radio-container" } );
        var _table       = DOM.Service.addElementTo( DOM.Service.createElement( "table", { class: "shinken-btn-group-table" } ), this.getDomElement() );
        var tr           = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table );
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            _current.computeHtml();
            DOM.Service.addElementTo( _current.getDomElement(), tr );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListFromData, COMPONENT.RadioListGenericV2 );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioListFromData, SHINKEN.OBJECT.ShinkenObjectHtml );
CONTROLLER.Form = (function ( self ) {
    self.controller_name     = CONTROLLER.CONST.FORM_CONTROLLER.NAME;
    self.onClick             = function ( event, event_name ) {
        event.stopPropagation();
        var _dom_target_property = DOM.Service.findParentElementWithClass( event.target, "shinken-element-property-line", 50 );
        if ( _dom_target_property ){
            self.current_form.hidePopup(_dom_target_property.dataset.name);
        } else {
            self.current_form.hidePopup();
        }
    };
    self.doActionAfter        = function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "onchange_in_input":
                self.current_form.getContentByUUID( param_1 ).askComputeAfterChange();
                break;
            case "onclick_in_input":
                break;
            case "click_on_radio_button":
                self.current_form.getContentByUUID( param_1 ).clickOnRadioBtn( param_2 );
                break;
            case "click_on_button":
                self.current_form.getContentByUUID( param_1 ).doActionAfter( event_name, param_2 );
                break;
            case "click_on_selector":
                self.current_form.getContentByUUID( param_1 ).clickOnSelector( param_2 );
                break;
            case "click_on_item_selector":
                self.current_form.getContentByUUID( param_1 ).clickOnItemSelector( param_2, param_3 );
                break;
            default:
                console.warn("[FORM - doActionAfter]", "[UNKNOWN]", event_name );
                break;
        }
        self.current_form.hidePopup(param_1);
        self.current_form.doActionAfter(event_name, param_1, param_2, param_3);
    };
    self.mouseLeave          = function ( event ) {
    };
    self.mouseEnter          = function ( event ) {
    };
    self.init                = function () {
    };
    self.setCurrentForm      = function ( to_set ) {
        self.current_form = to_set;
    };
    self.isValid      = function ( to_set ) {
        this.current_form.computeValidation();
        return this.current_form.isValid();
    };
    self.getDataToSave      = function ( to_set ) {
        return this.current_form.getDataToSave();
    };
    return self;
})( CONTROLLER.Form || {} );
"use strict";
SHINKEN.OBJECT.FormSetFromData           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.FormSetFromData.prototype = {
    initSpecific: function ( name ) {
        this.init( name );
    },
    setActionControllerName: function ( to_set ) {
        this.action_controller_name = to_set;
    },
    computeHtml            : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
    },
    computeCommonHtml      : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-form-container" } ) );
        
        var _table = DOM.Service.createElement( "table", { class: "shinken-width-100" } );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            DOM.Service.addElementTo( this.getContent( i ).getDomElement(), _table );
        }
        
        var _div = DOM.Service.createElement( "div", { class: "shinken-form-content" } );
        DOM.Service.addElementTo( _table, _div );
        this.addDomElement( _div );
        
        this.computeHtmlFooter();
        this.computeHtmlActions();
        this.computeHtmlExtra();
    },
    computeHtmlActions     : function () {
        var _div_action         = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-form-action shinken-parent-event-listener", "data-controller": this.action_controller_name } ) );
        var _div_action_content = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-table-form-container" } ), _div_action );
        var _table              = DOM.Service.addElementTo( DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-table-form-content" } ), _div_action_content );
        var _tr                 = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table );
        
        var _td_1            = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-form-action-cell" } ), _tr );
        var _button_validate = new COMPONENT.ButtonFromData( "validated_form", "shinken-validate-form", _( "form.action_button.submit", [DICTIONARY_COMMON_UI] ) );
        _button_validate.setExtraParam( this.getName() );
        _button_validate.computeHtml();
        DOM.Service.addElementTo( _button_validate.getDomElement(), _td_1 );
        
        var _td_2          = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-form-action-cell" } ), _tr );
        var _button_cancel = new COMPONENT.ButtonFromData( "cancel_form", "shinken-cancel-form", _( "form.action_button.cancel", [DICTIONARY_COMMON_UI] ) );
        _button_cancel.setExtraParam( this.getName() );
        _button_cancel.computeHtml();
        DOM.Service.addElementTo( _button_cancel.getDomElement(), _td_2 );
    },
    computeHtmlFooter      : function () {
        this.computeFooterContent();
        var _to_add = this.getFooterContent();
        if ( _to_add ) {
            _to_add.addClass("shinken-footer-form");
            _to_add.computeHtml();
            this.addDomElement( _to_add.getDomElement() );
        }
    },
    computeSpecificHtml    : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.FormSetFromData, SHINKEN.OBJECT.FormSet );
MANAGER.EventManagerV2 = {
    onChangeInput: function ( event, property_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "onchange_in_input", property_name);
    },
    onClickInput: function ( event, property_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "onclick_in_input", property_name);
    },
    clickRadioButton: function ( event, property_name, button_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "click_on_radio_button", property_name, button_name);
    },
    clickSelector: function ( event, property_name, selector_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "click_on_selector", property_name, selector_name);
    },
    clickItemSelector: function ( event, property_name, selector_name, item_name ) {
        MANAGER.EventManagerV2.dispatch(event, "do", "click_on_item_selector", property_name, selector_name, item_name);
    },
    clickButton : function ( event, param_1, param_2, param_3){
        MANAGER.EventManagerV2.dispatch(event, "do", "click_on_button", param_1, param_2, param_3);
    },
    dispatch: function ( event, type_dispatch, event_name, param_1, param_2, param_3 ) {
        var _controller = CONTROLLER.DistributorControllerManager.findControllerByEvent( event );
        switch ( type_dispatch ) {
            case "do":
                switch (event_name ) {
                    case "onchange_in_input":
                    case "onclick_in_input":
                    case "click_on_selector":
                    case "click_on_item_selector":
                    case "click_on_radio_button":
                    case "click_on_button":
                        event.stopPropagation();
                        _controller.doActionAfter(event_name, param_1, param_2, param_3);
                        break;
                }
                break;
        }
    },
};
PROPERTY.RadioListAbstract           = function () {
};
PROPERTY.RadioListAbstract.prototype = {
    init: function () {
        this.state = null;
    },
    ___clickOnRadioBtn: function ( value ) {
        this.component_radio_list.clickOnRadioBtn( value );
        this.updateView();
    },
    doActionAfter     : function ( event_name, param ) {
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                this.setValueFromUser( param );
                break;
            case "value_changed":
                this.component_radio_list.doActionAfter( event_name, param );
                break;
        }
    },
    ___unset                : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser        : function ( value ) {
        if ( !value ) {
            value = PROPERTY.CONST.COMMON.VALUE.DEFAULT;
        }
        this.clickOnRadioBtn( value );
    },
    setDefaultValue         : function ( to_set ) {
        this.component_radio_list.setDefaultValue( to_set );
    },
    setButtonVisibilityState: function ( button_name, to_set ) {
        this.component_radio_list.setButtonVisibilityState( button_name, to_set );
    },
    setButtonTooltip: function ( button_name, to_set, tooltip_type ) {
        this.component_radio_list.setButtonTooltip( button_name, to_set, tooltip_type );
    },
    getNbButtonVisible                  : function () {
        var _to_return = 0;
        for ( var i = 0, _size_i = this.component_radio_list.getSize(); i < _size_i; i++ ) {
            if ( this.component_radio_list.getContent(i).isVisible() ) {
                _to_return++;
            }
        }
        return _to_return;
    },
    getValue          : function () {
        return this.component_radio_list.getValue();
    },
    getDataToSaveFinal: function () {
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListAbstract, PROPERTY.InterfaceCommon );
PROPERTY.RadioListFromHtml           = function ( dom_element ) {
    this.initSpecific( dom_element );
};
PROPERTY.RadioListFromHtml.prototype = {
    initSpecific: function ( dom_element ) {
        this.init();
        this.initWithDomElement( dom_element );
        this.component_radio_list = new COMPONENT.RadioListGeneric( dom_element, this );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromHtml, PROPERTY.RadioListAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromHtml, PROPERTY.InterfaceCommonFromHtml );
PROPERTY.RadioListFromData           = function ( property_name, data_buttons ) {
    this.initSpecific( property_name, data_buttons );
};
PROPERTY.RadioListFromData.prototype = {
    initSpecific: function ( property_name, data_buttons ) {
        this.name                 = property_name;
        this.component_radio_list = new COMPONENT.RadioListFromData( data_buttons, this.name );
    },
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY.CONST.COMMON.TYPES.RADIO_LIST;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_radio_list.computeHtml();
        DOM.Service.addElementTo( this.component_radio_list.getDomElement(), this.dom_cell_action );
    },
    computeHtml_setEventName            : function ( to_set ) {
        return this.component_radio_list.computeHtml_setEventName( to_set );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromData, PROPERTY.RadioListAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromData, PROPERTY.InterfaceCommonFromData );
PROPERTY.RangeAbstract           = function () {
};
PROPERTY.RangeAbstract.prototype = {
    init: function () {
        this.number_digit_after_comma      = 0;
    },
    doActionAfter            : function ( event_name, param ) {
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                this.setValueFromUser( param );
                this.component_label_default_input.updateLabel( this.component_btn_default.getValue() + this.component_input_range.getUnit() );
                break;
            case "value_changed":
                this.component_input_range.doActionAfter( event_name, param );
                this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case "use_default_value":
                this.changeDefaultButtonStatus( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    onMoveRangeCursor        : function ( value_to_set, is_default ) {
        if ( this.is_disabled ) {
            return;
        }
        value_to_set = SHINKEN.TOOLS.NUMBER.roundTo( value_to_set, this.number_digit_after_comma );
        this.component_input_range.setValueFromUser( value_to_set );
        this.changeDefaultButtonStatus( is_default ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.OFF );
    },
    ___clickOnRadioBtn       : function ( value ) {
        var _value_to_set = this.default_value;
        this.component_input_range.setValue( _value_to_set );
    },
    changeDefaultButtonStatus: function ( value ) {
        this.component_btn_default.setState( value );
        DOM.Service.setDataSet( this.dom_element, 'defaultBtnStatus', value );
        if ( this.component_btn_default.isOn() ) {
            this.component_input_range.setValueFromUser( this.component_btn_default.getValue() );
        }
    },
    setDefaultValue          : function ( to_set ) {
        this.component_input_range.setDefaultValue( to_set );
        this.component_btn_default.setValue( to_set );
    },
    ___unset                 : function () {
        this.setValueFromUser( "" );
    },
    setValueFromUser         : function ( value ) {
        var is_default = false;
        if ( value === PROPERTY.CONST.COMMON.VALUE.DEFAULT || value === undefined ) {
            value      = this.component_btn_default.getValue();
            is_default = true;
        }
        this.onMoveRangeCursor( parseFloat( value ), is_default );
    },
    getValue: function () {
        return this.component_input_range.getValue();
    },
    getDataToSaveFinal: function () {
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RangeAbstract, PROPERTY.InterfaceCommon );
PROPERTY.RangeFomHtml           = function ( dom_element ) {
    this.init( dom_element );
};
PROPERTY.RangeFomHtml.prototype = {
    init: function ( dom_element ) {
        this.initWithDomElement( dom_element );
        this.component_input_range         = new COMPONENT.InputRange( dom_element, this );
        this.component_btn_default         = new COMPONENT.Generic( dom_element.querySelector( ".shinken-input-range-radio-element" ) );
        this.component_label_default_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-notification-sound-default-value" ) );
        this.number_digit_after_comma      = 0;
    },
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RangeFomHtml, PROPERTY.RangeAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RangeFomHtml, PROPERTY.InterfaceCommonFromHtml );
PROPERTY.SingleSelectAbstract           = function () {
};
PROPERTY.SingleSelectAbstract.prototype = {
    init: function () {
    },
    clickOnSelector    : function ( selector_name ) {
        if ( this.is_disabled ) {
            return false;
        }
        this.getSelector( selector_name ).clickOnSelector();
    },
    clickOnItemSelector: function ( selector_name, item_name ) {
        if ( this.is_disabled ) {
            return false;
        }
        this.getSelector( selector_name ).clickOnItemSelector( item_name, this );
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_item_selector_done":
                DOM.Service.setDataSet( this.getDomElement(), "currentValue", param_1.getValue() );
                break;
        }
    },
    _computeState: function () {
        this._computeLabelSelect();
    },
    setValueFromUser          : function ( value ) {
        this.clickOnItemSelector( null, value );
    },
    getValue                  : function ( value ) {
        return this.getSelector().getValue();
    },
    setStatus                 : function ( _to_set ) {
        this.status = _to_set;
        this.component_selector.setStatus( _to_set );
    },
    setDefaultLabelForSelector: function ( selector_name, to_set ) {
        this.getSelector( selector_name ).setDefaultLabelForSelector( to_set );
    },
    getDataToSave: function () {
        return this.getSelector().getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectAbstract, PROPERTY.InterfaceSelectAbstract );
PROPERTY.SingleSelectFromData           = function ( property_name, options ) {
    this.initSpecific( property_name, options );
};
PROPERTY.SingleSelectFromData.prototype = {
    initSpecific    : function ( property_name, data_option_array ) {
        this.name = property_name;
        this.init();
        this.initMainSelector( data_option_array );
    },
    initMainSelector: function ( data_option_array ) {
        this.component_selector = new COMPONENT.SingleSelectFromData( this.getName() );
        this.component_selector.setOptionsFromArray( data_option_array );
    },
    changeOptionsFromArray: function ( data_option_array ) {
        this.component_selector.changeOptionsFromArray( data_option_array );
    },
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY.CONST.COMMON.TYPES.SINGLE_SELECT;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_selector.computeHtml();
        DOM.Service.addElementTo( this.component_selector.getDomElement(), this.dom_cell_action );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData, PROPERTY.SingleSelectAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.SingleSelectFromData, PROPERTY.InterfaceSelectFromData );
PROPERTY.StringInputAbstract           = function () {
};
PROPERTY.StringInputAbstract.prototype = {
    init: function () {
    },
    askComputeAfterChange: function () {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( null, this );
    },
    doActionAfterChange  : function ( args ) {
    },
    onFocus              : function () {
    },
    ___onFocusOut        : function () {
    },
    doActionAfter        : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_button":
                switch ( param_1 ) {
                    case "clean_input_value":
                        this.component_input.setValueFromJs( "" );
                        break;
                }
                break;
        }
    },
    setValueFromUser: function ( value ) {
        this.component_input.setValueFromJs( value );
    },
    setStatus       : function ( _to_set ) {
        this.status = _to_set;
        this.component_input.setStatus( _to_set );
    },
    getValue        : function () {
        return this.component_input.getValue();
    },
    setPlaceholder  : function ( _to_set ) {
        return this.component_input.setPlaceholder( _to_set );
    },
    getDataToSave: function () {
        return SHINKEN.TOOLS.STRING.trimExtented( this.getValue() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputAbstract, PROPERTY.InterfaceCommon );
PROPERTY.StringInputFromData           = function ( property_name, value ) {
    this.__class_name__ = 'PROPERTY.StringInputFromData';
    this.initSpecific( property_name, value );
};
PROPERTY.StringInputFromData.prototype = {
    initSpecific: function ( property_name, value ) {
        this.name = property_name;
        this.init();
        this.component_input = new COMPONENT.InputFromDataV2( value, this.name );
    },
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY.CONST.COMMON.TYPES.STRING_INPUT;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_input.computeHtml();
        DOM.Service.addElementTo( this.component_input.getDomElement(), this.dom_cell_action );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputFromData, PROPERTY.StringInputAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputFromData, PROPERTY.InterfaceCommonFromData );
