SHINKEN.TOOLS.TEST_AUTO_PROPERTY_INFORMATION = (function ( self ) {
    self.DOM                         = {};
    self.DOM.ADDRESS                 = {};
    self.DOM.ADDRESS.CONST           = {
        STATE: {
            NEW      : "new",
            CHANGE   : "changes",
            WORK_AREA: "working_area",
            STAGING  : "stagging"
        }
    };
    self.TEST                        = {};
    self.TEST.ADDRESS                = {};
    self.TEST.ADDRESS.CONST          = {
        STATE: {
            WARNING: "WARNING",
            OK     : "OK"
        }
    };
    self.ACTION                      = {};
    //********************************************  GET DOM ELEMENT   ****************************************//
    self.DOM.getButtonCell           = function ( property_name ) {
        var _to_return = SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name );
        return _to_return.querySelector( ".shinken-cell-button-information" );
    };
    self.DOM.getButton               = function ( property_name ) {
        var _to_return = self.DOM.getButtonCell( property_name );
        return _to_return.querySelector( ".shinken-button" );
    };
    self.DOM.getPropertyContent      = function ( property_name ) {
        var _to_return = SHINKEN.TOOLS.TEST_AUTO_PROPERTY.DOM.line( property_name );
        return _to_return.querySelector( ".shinken-cell-content-information" );
    };
    self.DOM.ADDRESS.getLinesContent = function () {
        var _to_return = self.DOM.getPropertyContent( PROPERTY.getPropertyInformationName( PROPERTY.CONST.NAME.ADDRESS ) );
        return _to_return.querySelectorAll( '.shinken-list-line' );
    };
    self.DOM.ADDRESS.getLineContent  = function ( uuid ) {
        var _to_return = self.DOM.getPropertyContent( PROPERTY.getPropertyInformationName( PROPERTY.CONST.NAME.ADDRESS ) );
        return _to_return.querySelector( '.shinken-list-line[data-id="' + uuid + '"]' );
    };
    self.DOM.ADDRESS.getCellContent  = function ( uuid, state ) {
        var _to_return = self.DOM.ADDRESS.getLineContent( uuid );
        if ( _to_return ) {
            _to_return = _to_return.querySelector( '.shinken-list-cell[data-item-state="' + state + '"]' );
        }
        return _to_return;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.display_               = function ( timeout, property_name, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY_INFORMATION.TEST.display_', property_name + " --> " + state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_button  = self.DOM.getButtonCell( property_name );
            var _dom_content = self.DOM.getPropertyContent( property_name );
            
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.COLLAPSED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_button, property_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom_content, property_name );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_PROPERTY_CONST.STATE.UN_COLLAPSED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_button, property_name );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom_content, property_name );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.ADDRESS.NBLine         = function ( timeout, nb_expected ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.ADDRESS.LineContent', nb_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _doms = self.DOM.ADDRESS.getLinesContent();
            SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( _doms, nb_expected, "nb line address" );
        }, timeout );
        return _to_return;
    };
    self.TEST.ADDRESS.LineContent    = function ( timeout, uuid, value_new, value_change, value_working_area, value_staging ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.ADDRESS.NBLine', uuid );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            self.TEST.ADDRESS.CellContent( 0, uuid, self.DOM.ADDRESS.CONST.STATE.NEW, value_new, false );
            self.TEST.ADDRESS.CellContent( 0, uuid, self.DOM.ADDRESS.CONST.STATE.CHANGE, value_change, false );
            self.TEST.ADDRESS.CellContent( 0, uuid, self.DOM.ADDRESS.CONST.STATE.WORK_AREA, value_working_area, false );
            self.TEST.ADDRESS.CellContent( 0, uuid, self.DOM.ADDRESS.CONST.STATE.STAGING, value_staging, false );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.ADDRESS.CellContent    = function ( timeout, uuid, state, value, show_log ) {
        var _to_return = 200;
        var _uuid      = show_log ? SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.ADDRESS.CellContent', uuid ) : '';
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.ADDRESS.getCellContent( uuid, state );
            switch ( value ) {
                case self.TEST.ADDRESS.CONST.STATE.WARNING:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasClass( 0, _dom, "shinken-duplicate-address-warning", false, uuid + " " + self.TEST.ADDRESS.CONST.STATE.WARNING + " ==> " + state );
                    break;
                case self.TEST.ADDRESS.CONST.STATE.OK:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasClass( 0, _dom, "shinken-duplicate-address-ok", false, uuid + " " + self.TEST.ADDRESS.CONST.STATE.OK + " ==> " + state );
                    break;
                case self.TEST.ADDRESS.CONST.STATE.ERROR:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.hasClass( 0, _dom, "shinken-duplicate-address-error", false, uuid + " " + self.TEST.ADDRESS.CONST.STATE.ERROR + " ==> " + state );
                    break;
                default:
                    SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _dom, null, "TEST.ADDRESS.CellContent => state=" + state + " value=" + value );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST   **************************************************//
    self.ACTION.toggleDisplay        = function ( timeout, property_name ) {
        var _to_return = 300;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY_INFORMATION.ACTION.toggleDisplay', property_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom_button = self.DOM.getButton( property_name );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom_button );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST USER   **************************************************//
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_PROPERTY_INFORMATION || {} );