"use strict";
SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER = (function ( self ) {
    self.DOM                               = {};
    self.DOM.CHANGE_USER                   = {};
    self.TEST                              = {};
    self.TEST.IN_TAB_ADMINISTRATION        = {};
    self.TEST.IN_TAB_RUNNING               = {};
    self.TEST.IN_TAB_DELETING              = {};
    self.ACTION                            = {};
    self.ACTION.IN_TAB_ADMINISTRATION      = {};
    self.ACTION.IN_TAB_RUNNING             = {};
    self.ACTION.IN_TAB_DELETING            = {};
    self.CONST                             = {};
    var _INTERNAL                          = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    _INTERNAL.getTabName                   = function ( view_tab ) {
        return view_tab || SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY;
    };
    self.DOM.getIframe                     = function () {
        return SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANELS.DOM.getIframe();
    };
    self.DOM.tabsNavigation                = function () {
        return self.DOM.getIframe().querySelectorAll( "#id-shinken-container-panels-view .shinken-view-manager-navigation" );
    };
    self.DOM.tabNavigation                 = function ( tab_name ) {
        tab_name             = _INTERNAL.getTabName( tab_name );
        var _tab_navigations = self.DOM.tabsNavigation();
        for ( var i = 0, _size_i = _tab_navigations.length; i < _size_i; i++ ) {
            var _to_return = _tab_navigations[ i ].querySelector( '.shinken-window-element[data-name="' + tab_name + '"]' );
            if ( _to_return ) {
                return _to_return;
            }
        }
    };
    self.DOM.tabNavigationTotal            = function ( tab_name ) {
        return self.DOM.tabNavigation( tab_name ).querySelector( ".shinken-counter.shinken-total-counter" );
    };
    self.DOM.getButtonRemove               = function ( line_dom ) {
        return line_dom.querySelector( ".shinken-bin-icon" );
    };
    self.DOM.getClosePopup                 = function () {
        return self.DOM.getIframe().querySelector( "#id-shinken-confirmation-popup-container" );
    };
    self.DOM.getClosePopupButtonOK         = function () {
        return self.DOM.getClosePopup().querySelector( ".shinken-action-button-confirmation-popup.shinken-validate-button" );
    };
    self.DOM.getClosePopupButtonNOK        = function () {
        return self.DOM.getClosePopup().querySelector( ".shinken-action-button-confirmation-popup.shinken-cancel-button" );
    };
    self.DOM.viewTab                       = function ( view_tab ) {
        return self.DOM.getIframe().querySelector( '.shinken-parent-tab-id-parent[data-name="' + _INTERNAL.getTabName( view_tab ) + '"]' );
    };
    self.DOM.headers                       = function ( view_tab ) {
        return self.DOM.viewTab( view_tab ).querySelectorAll( ".shinken-list-container-fix-header-filter .shinken-list-header" );
    };
    self.DOM.header                        = function ( header_name, view_tab ) {
        return self.DOM.viewTab( view_tab ).querySelector( '.shinken-list-container-fix-header-filter .shinken-list-header[data-name="' + header_name + '"]' );
    };
    self.DOM.headerLabel                   = function ( header_name, view_tab ) {
        return self.DOM.header( header_name, view_tab ).querySelector( ".shinken-list-header-name" );
    };
    self.DOM.headerButton                  = function ( header_name ) {
        return self.DOM.header( header_name ).querySelector( ".shinken-sort-popup-button" );
    };
    self.DOM.headerButtonMenuOption        = function ( header_name, data_name ) {
        return self.DOM.header( header_name ).querySelector( '.shinken-list-header-sort-popup-option[data-name="' + data_name + '"]' );
    };
    self.DOM.headerSortingIndex            = function ( header_name, view_tab ) {
        return self.DOM.header( header_name, view_tab ).querySelector( ".shinken-list-header-sort-priority-number" );
    };
    self.DOM.headerSortingIcon             = function ( header_name, view_tab ) {
        return self.DOM.header( header_name, view_tab ).querySelector( ".shinken-list-header-sort-priority-icon-cell" );
    };
    self.DOM.filters                       = function ( view_tab ) {
        return self.DOM.viewTab( view_tab ).querySelectorAll( ".shinken-list-container-fix-header-filter .shinken-list-filter" );
    };
    self.DOM.lines                         = function ( view_tab ) {
        return self.DOM.viewTab( view_tab ).querySelectorAll( ".shinken-list-container-with-scroll .shinken-list-line:not(.shinken-bind-tr)" );
    };
    self.DOM.lineWithName                  = function ( line_name, view_tab ) {
        var _doms = self.DOM.lines( view_tab );
        for ( var i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
            if ( _INTERNAL.isLine( _doms[ i ], line_name ) ) {
                return _doms[ i ];
            }
        }
        return null;
    };
    self.DOM.linesNotFiltered              = function ( view_tab ) {
        return self.DOM.viewTab( view_tab ).querySelectorAll( '.shinken-list-container-with-scroll .shinken-list-line:not(.shinken-bind-tr):not(.shinken-is-filtered)' );
    };
    self.DOM.CHANGE_USER.buttonOpen        = function ( dom_element_line ) {
        return dom_element_line.querySelector( ".shinken-button-change-view-owner" );
    };
    self.DOM.CHANGE_USER.input             = function ( dom_element_line ) {
        return dom_element_line.querySelector( '.shinken-list-select-input[data-name="input_change_user"] .shinken-input' );
    };
    self.DOM.CHANGE_USER.buttonValidChange = function ( dom_element_line ) {
        return dom_element_line.querySelector( ".shinken-change-owner-popup-button.shinken-change-owner-apply-button" );
    };
    self.DOM.cell                          = function ( dom_element_line, cell_name ) {
        return dom_element_line.querySelector( '.shinken-list-cell[data-name="' + cell_name + '"]' );
    };
    self.DOM.cellText                      = function ( dom_element_line, cell_name ) {
        switch ( cell_name ) {
            case "deleting_time":
                return self.DOM.cell( dom_element_line, cell_name ).querySelector( ".shinken-list-cell-content" );
            case "current_owner":
                return self.DOM.cell( dom_element_line, cell_name ).querySelector( ".shinken-label" ).textContent;
            default:
                return self.DOM.cell( dom_element_line, cell_name ).textContent;
        }
    };
    self.DOM.cellInput                     = function ( dom_element_line, cell_name ) {
        return dom_element_line.querySelector( `.shinken-list-cell[data-name="${cell_name}"] .shinken-input` );
    };
    self.DOM.filter                        = function ( filter_name, view_tab ) {
        return self.DOM.viewTab( view_tab ).querySelector( '.shinken-list-container-fix-header-filter .shinken-list-filter[data-name="' + filter_name + '"]' );
    };
    self.DOM.filterOption                  = function ( filter_name, to_set, view_tab ) {
        return self.DOM.filter( filter_name, view_tab ).querySelector( `.shinken-option[data-key-name="${to_set}"]` );
    };
    self.DOM.filterInput                   = function ( filter_name, view_tab ) {
        return self.DOM.filter( filter_name, view_tab ).querySelector( '.shinken-input' );
    };
    self.DOM.previousOwnerWithLineName     = function ( line_name ) {
        return self.lineWithName( line_name ).querySelector( "previous_owner" );
    };
    self.DOM.buttonDuplicateWeather        = function ( dom_element_line ) {
        return dom_element_line.querySelector( ".shinicon-copy" );
    };
    self.DOM.buttonCancelLine              = function ( dom_element_line ) {
        return dom_element_line.querySelector( ".shinken-view-cancel-button.shinken-2023-back" );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.cellValue                                   = function ( timeout, expected_value, cell_name, line_name, view_tab ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.cellValue', expected_value + " -> " + cell_name + " -> " + line_name + " -> " + view_tab );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let dom_element_line = self.DOM.lineWithName( line_name, view_tab );
            let value            = self.DOM.cellText( dom_element_line, cell_name );
            SHINKEN.TOOLS.TEST_AUTO.__isTextEqualTo( value, expected_value, cell_name );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.sorting                                     = function ( timeout, header_name, index_sort, type_sort, view_tab ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.headerNumber', header_name + " -> " + index_sort + " -> " + type_sort );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.headerSortingIndex( header_name, view_tab ), index_sort ? index_sort : "", 'index_sort' );
            var _dom = self.DOM.headerSortingIcon( header_name, view_tab );
            switch ( type_sort ) {
                case SHINKEN.OBJECT.Sorting.CONST.STATUS.INCREASING :
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".shinicon-sort-decrease" ), "shinicon-sort-decrease" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".shinicon-sort-increase" ), "shinicon-sort-increase" );
                    break;
                case SHINKEN.OBJECT.Sorting.CONST.STATUS.DECREASING :
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom.querySelector( ".shinicon-sort-decrease" ), "shinicon-sort-decrease" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".shinicon-sort-increase" ), "shinicon-sort-increase" );
                    break;
                case SHINKEN.OBJECT.Sorting.CONST.STATUS.NONE :
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".shinicon-sort-decrease" ), "shinicon-sort-decrease" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom.querySelector( ".shinicon-sort-increase" ), "shinicon-sort-increase" );
                    break;
            }
            //_INTERNAL.testNumber( self.DOM.lines(), value_expected_total );
            //_INTERNAL.testNumber( self.DOM.linesNotFiltered(), value_expected_displayed, value_expected_displayed );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.viewsNumber                                 = function ( timeout, total_lines, displayed_lines, view_tab ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.headerNumber', total_lines + " -> " + displayed_lines );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.tabNavigationTotal( view_tab ), total_lines, 'total_lines' );
            _INTERNAL.testNumber( self.DOM.lines( view_tab ), total_lines );
            _INTERNAL.testNumber( self.DOM.linesNotFiltered( view_tab ), displayed_lines, displayed_lines );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.headersNumber                               = function ( timeout, value_expected, view_tab ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.headerNumber', value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _INTERNAL.testNumber( self.DOM.headers( view_tab ), value_expected, value_expected );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.filtersNumber                               = function ( timeout, value_expected, view_tab ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.filtersNumber', value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _INTERNAL.testNumber( self.DOM.filters( view_tab ), value_expected, value_expected );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.displayAtLine                               = function ( timeout, line_name, number_line, view_tab ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayAtLine', line_name + " => " + number_line );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _doms = self.DOM.lines( view_tab );
            if ( !_INTERNAL.isLine( _doms[ number_line ], line_name ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "displayAtLine not at the good line", line_name + " => " + number_line );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.IN_TAB_RUNNING.sorting                      = function ( timeout, header_name, index_sort, type_sort ) {
        return self.TEST.sorting( timeout, header_name, index_sort, type_sort, SHINKEN.UI.VIEW.WEATHER.TABS.RUNNING._KEY );
    };
    self.TEST.IN_TAB_RUNNING.viewsNumber                  = function ( timeout, value_expected_total, value_expected_displayed ) {
        return self.TEST.viewsNumber( timeout, value_expected_total, value_expected_displayed, SHINKEN.UI.VIEW.WEATHER.TABS.RUNNING._KEY );
    };
    self.TEST.IN_TAB_RUNNING.headersNumber                = function ( timeout, value_expected ) {
        return self.TEST.headersNumber( timeout, value_expected, SHINKEN.UI.VIEW.WEATHER.TABS.RUNNING._KEY );
    };
    self.TEST.IN_TAB_RUNNING.filtersNumber                = function ( timeout, value_expected ) {
        return self.TEST.filtersNumber( timeout, value_expected, SHINKEN.UI.VIEW.WEATHER.TABS.RUNNING._KEY );
    };
    self.TEST.IN_TAB_RUNNING.displayAtLine                = function ( timeout, line_name, number_line ) {
        return self.TEST.displayAtLine( timeout, line_name, number_line, SHINKEN.UI.VIEW.WEATHER.TABS.RUNNING._KEY );
    };
    self.TEST.IN_TAB_ADMINISTRATION.viewsNumber           = function ( timeout, value_expected_total, value_expected_displayed ) {
        return self.TEST.viewsNumber( timeout, value_expected_total, value_expected_displayed, SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY );
    };
    self.TEST.IN_TAB_DELETING.sorting                     = function ( timeout, header_name, index_sort, type_sort ) {
        return self.TEST.sorting( timeout, header_name, index_sort, type_sort, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
    };
    self.TEST.IN_TAB_DELETING.viewsNumber                 = function ( timeout, value_expected_total, value_expected_displayed ) {
        return self.TEST.viewsNumber( timeout, value_expected_total, value_expected_displayed, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
    };
    self.TEST.IN_TAB_DELETING.headersNumber               = function ( timeout, value_expected ) {
        return self.TEST.headersNumber( timeout, value_expected, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
    };
    self.TEST.IN_TAB_DELETING.filtersNumber               = function ( timeout, value_expected ) {
        return self.TEST.filtersNumber( timeout, value_expected, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
    };
    self.TEST.IN_TAB_DELETING.displayAtLine               = function ( timeout, line_name, number_line ) {
        return self.TEST.displayAtLine( timeout, line_name, number_line, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
    };
    self.TEST.deleteDate                                  = function ( timeout, weather_name, expected_date ) {
        const _to_return = 50;
        let _uuid        = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.checkDeleteDate', " => " + expected_date );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom_date = self.DOM.cellText( self.DOM.lineWithName( weather_name, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY ), "deleting_time" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextContains( _dom_date, DATE_TIME.FORMAT.get_date( expected_date, DATE_TIME.FORMAT.DATE.DEFAULT ), "The expected date is not the same as displayed" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.notificationState                           = function ( timeout, line_name, to_test_blink, to_test_sound ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'notificationState', line_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _cell = self.DOM.cell( self.DOM.lineWithName( line_name ), "notifications" );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( to_test_blink, !!_cell.querySelector( ".notifications_visual" ), 'test_blink_is_activate' );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( to_test_sound, !!_cell.querySelector( ".notifications_sound" ), 'test_sound_is_activate' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.weatherUsers                                = function ( timeout, line_name, expected_creator, expected_owner, expected_previous_owner ) {
        const _to_return = 200;
        let _uuid        = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.weatherUsers', " => " + expected_creator, expected_owner, expected_previous_owner );
        setTimeout( function () {
            let _line = self.DOM.lineWithName( line_name, SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isTextEqualTo( self.DOM.cellText( _line, "creator" ), expected_creator, "Le créateur" );
            SHINKEN.TOOLS.TEST_AUTO.__isTextEqualTo( self.DOM.cellText( _line, "current_owner" ), expected_owner, "Le propriétaire" );
            SHINKEN.TOOLS.TEST_AUTO.__isTextEqualTo( self.DOM.cellText( _line, "previous_owner" ), expected_previous_owner, "Précédent propriétaire" );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.isViewExisting                              = function ( timeout, view_name, is_existing ) {
        const _to_return = 200;
        let _uuid        = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.isLineCleaned', " => " + view_name );
        setTimeout( function () {
            let _line = self.DOM.lineWithName( view_name, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
            if ( _line && !is_existing ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Line " + view_name + " shouldn't exist => " + _line );
            }
            else if ( !_line && is_existing ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Line " + view_name + " does not exist => " + _line );
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.buttonAddWeatherDoesntExist                 = function ( timeout ) {
        setTimeout( function () {
            let _button = self.DOM.viewTab( SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY ).querySelector( ".shinken-new-weather-button" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.doesntExist( 0, _button );
        }, timeout );
        return 100;
    };
    _INTERNAL.testNumber                                  = function ( doms, value_expected, value_visible ) {
        SHINKEN.TOOLS.TEST_AUTO.___isArrayLengthEqualsTo( doms, value_expected, '' );
        if ( value_visible ) {
            for ( var i = 0, _size_i = doms.length; i < _size_i; i++ ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, doms[ i ], "isVisible" );
            }
        }
    };
    _INTERNAL.isLine                                      = function ( dom_element_line, line_name ) {
        if ( !dom_element_line ) {
            return null;
        }
        var _to_return = self.DOM.cell( dom_element_line, "name" );
        if ( !_to_return ) {
            return null;
        }
        if ( _to_return.querySelector( ".shinken-view-name" ) ) {
            return _to_return.querySelector( ".shinken-view-name" ).innerText === line_name;
        }
        else {
            return _to_return.querySelector( ".shinken-input" ).value === line_name;
        }
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.navigateInTab                             = function ( timeout, tab_name ) {
        return ____execute( timeout, 200, "ACTION.navigateInTab", function ( tab_name ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.tabNavigation( tab_name ) );
        }, [...arguments] );
    };
    self.ACTION.askForRemoveByIndex                       = function ( timeout, index ) {
        return ____execute( timeout, 500, "ACTION.askForRemoveByIndex", function ( index ) {
            var _doms = self.DOM.lines();
            if ( !_INTERNAL.removeLine( _doms[ index ] ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "FORBIDDEN TO REMOVE WEATHER WITH UUID " + SHINKEN.TOOLS.TEST_AUTO.WEATHER_DEFAULT_UUID );
            }
        }, [...arguments] );
    };
    self.ACTION.validClosePopup                           = function ( timeout ) {
        return ____execute( timeout, 3000, "ACTION.validClosePopup", function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getClosePopupButtonOK() );
        }, [...arguments] );
    };
    self.ACTION.cancelClosePopup                          = function ( timeout ) {
        return ____execute( timeout, 500, "ACTION.cancelClosePopup", function () {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getClosePopupButtonNOK() );
        }, [...arguments] );
    };
    self.ACTION.resetPanelContent                         = function ( timeout, view_tab ) {
        return ____execute( timeout, 3700, "ACTION.resetPanelContent", function () {
            var _doms = self.DOM.lines( view_tab );
            for ( var i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
                _INTERNAL.removeLine( _doms[ i ] );
            }
        }, [...arguments] );
    };
    self.ACTION.resetAdministrationPanelContent           = function ( timeout ) {
        timeout += self.ACTION.navigateInTab( timeout, SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY );
        return SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER.ACTION.resetPanelContent( timeout, SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY );
    };
    self.ACTION.resetDeletionPanelContent                 = function ( timeout ) {
        timeout += self.ACTION.navigateInTab( timeout, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
        return SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER.ACTION.resetPanelContent( timeout, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
    };
    self.ACTION.resetAllPanelsContents                    = function ( timeout ) {
        var _to_return = 0;
        _to_return += SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER.ACTION.resetAdministrationPanelContent( timeout + _to_return );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANELS.ACTION.applyAllUserActionAsk( timeout + _to_return );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER.ACTION.validClosePopup( timeout + _to_return );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER.ACTION.resetDeletionPanelContent( timeout + _to_return );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANELS.ACTION.applyAllUserActionAsk( timeout + _to_return );
        _to_return += SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER.ACTION.validClosePopup( timeout + _to_return );
        return _to_return;
    };
    self.ACTION.filter                                    = function ( timeout, filter_name, filter_value, view_tab ) {
        return ____execute( timeout, 250, "ACTION.filter", function ( filter_name, filter_value, view_tab ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.filterInput( filter_name, view_tab ), filter_value );
        }, [...arguments] );
    };
    self.ACTION.clickOnFilterOption                       = function ( timeout, filter_name, to_set, view_tab ) {
        return ____execute( timeout, 500, "ACTION.clickOnFilterOption", function ( filter_name, to_set, view_tab ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 0, self.DOM.filterOption( filter_name, to_set, view_tab ), true );
        }, [...arguments] );
    };
    self.ACTION.clickOnHeaderLabel                        = function ( timeout, header_name, do_shift, view_tab ) {
        return ____execute( timeout, 750, "ACTION.clickOnHeaderLabel", function ( header_name, do_shift, view_tab ) {
            if ( do_shift ) {
                SHINKEN.TOOLS.TEST_AUTO_DOM.shiftClick( 0, self.DOM.headerLabel( header_name, view_tab ) );
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.headerLabel( header_name, view_tab ) );
            }
        }, [...arguments] );
    };
    self.ACTION.IN_TAB_RUNNING.filter                     = function ( timeout, filter_name, filter_value ) {
        return self.ACTION.filter( timeout, filter_name, filter_value, SHINKEN.UI.VIEW.WEATHER.TABS.RUNNING._KEY );
    };
    self.ACTION.IN_TAB_RUNNING.clickOnHeaderLabel         = function ( timeout, header_name, do_shift ) {
        return self.ACTION.clickOnHeaderLabel( timeout, header_name, do_shift, SHINKEN.UI.VIEW.WEATHER.TABS.RUNNING._KEY );
    };
    self.ACTION.IN_TAB_DELETING.filter                    = function ( timeout, filter_name, filter_value ) {
        return self.ACTION.filter( timeout, filter_name, filter_value, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
    };
    self.ACTION.IN_TAB_DELETING.clickOnHeaderLabel        = function ( timeout, header_name, do_shift ) {
        return self.ACTION.clickOnHeaderLabel( timeout, header_name, do_shift, SHINKEN.UI.VIEW.WEATHER.TABS.DELETING._KEY );
    };
    self.ACTION.IN_TAB_ADMINISTRATION.clickOnFilterOption = function ( timeout, filter_name, to_set ) {
        return self.ACTION.clickOnFilterOption( timeout, filter_name, to_set, SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY );
    };
    self.ACTION.clickOnHeaderMenu                         = function ( timeout, header_name ) {
        return ____execute( timeout, 250, "ACTION.clickOnHeaderMenu", function ( header_name ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.headerButton( header_name ) );
        }, [...arguments] );
    };
    self.ACTION.clickOnHeaderMenuOption                   = function ( timeout, header_name, option_name ) {
        return ____execute( timeout, 250, "ACTION.clickOnHeaderMenuOption", function ( header_name, option_name ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.headerButtonMenuOption( header_name, option_name ), false, 10 );
        }, [...arguments] );
    };
    self.ACTION.clickOnChangeUser                         = function ( timeout, line_name ) {
        return ____execute( timeout, 2500, "ACTION.clickOnChangeUser", function ( line_name ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.CHANGE_USER.buttonOpen( self.DOM.lineWithName( line_name ) ) );
        }, [...arguments] );
    };
    self.ACTION.deleteWeatherByName                       = function ( timeout, weather_name ) {
        return ____execute( timeout, 2500, "ACTION.deleteWeatherByName", function ( weather_name ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getButtonRemove( self.DOM.lineWithName( weather_name ) ) );
        }, [...arguments] );
    };
    self.ACTION.filterUserInChangeUser                    = function ( timeout, line_name, new_owner_name ) {
        return ____execute( timeout, 2500, "ACTION.filterUserInChangeUser", function ( line_name, new_owner_name ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.CHANGE_USER.input( self.DOM.lineWithName( line_name ) ), new_owner_name );
        }, [...arguments] );
    };
    self.ACTION.validChangeUserInInput                    = function ( timeout, line_name ) {
        return ____execute( timeout, 2500, "ACTION.validChangeUserInInput", function ( line_name ) {
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.CHANGE_USER.buttonValidChange( self.DOM.lineWithName( line_name ) ) );
        }, [...arguments] );
    };
    self.ACTION.cloneWeather                              = function ( timeout, weather_name_to_clone ) {
        return ____execute( timeout, 2500, "ACTION.cloneWeather", function ( weather_name_to_clone ) {
            let weather_to_clone = self.DOM.lineWithName( weather_name_to_clone, SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonDuplicateWeather( weather_to_clone ), false, 10 );
        }, [...arguments] );
    };
    self.ACTION.cancelLine                                = function ( timeout, weather_name_to_cancel ) {
        return ____execute( timeout, 2500, "ACTION.cancelLine", function ( weather_name_to_cancel ) {
            let line_to_cancel = self.DOM.lineWithName( weather_name_to_cancel, SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.buttonCancelLine( line_to_cancel ), false, 10 );
        }, [...arguments] );
    };
    self.ACTION.changeWeatherName                         = function ( timeout, line_name, new_name ) {
        return ____execute( timeout, 2500, "ACTION.changeWeatherName", function ( line_name, new_name ) {
            let new_line = self.DOM.lineWithName( line_name, SHINKEN.UI.VIEW.WEATHER.TABS.ADMINISTRATION._KEY );
            SHINKEN.TOOLS.TEST_AUTO_DOM.ACTION.setInputValue( 0, self.DOM.cellInput( new_line, "name" ), new_name );
        }, [...arguments] );
    };
    _INTERNAL.removeLine                                  = function ( dom ) {
        if ( dom.dataset.uuid === SHINKEN.TOOLS.TEST_AUTO.WEATHER_DEFAULT_UUID ) {
            return false;
        }
        SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getButtonRemove( dom ) );
        return true;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANEL_WEATHER || {} );
