//__lib__ lib_common
'use strict';


COMPONENT.Generic           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.Generic.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.initDomElement();
        }
        else {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
        }
        this._computeState();
    },
    initDomElement: function () {
        this.value = this.dom_element.dataset.value;
    },
    _computeState : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        this.setState( this.dom_element.classList.contains( "shinken-active" ) ? COMPONENT.CONST.BTN_STATE.ON : COMPONENT.CONST.BTN_STATE.OFF );
    },
    getUUID       : function () {
        return this.getValue();
    },
    //********************************************  GETTER AND SETTER  ***********************************************//
    setState         : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.setClassWithState();
    },
    toggleState      : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    setClassWithState: function () {
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element.classList.remove( "shinken-active" );
        this.dom_element.classList.remove( "shinken-disabled" );
        this.dom_element.classList.remove( "shinken-enabled-with-errors" );
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
    },
    getValue         : function () {
        return this.value;
    },
    setValue         : function ( to_set ) {
        this.value = to_set;
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    //********************************************  COMPUTE  ***********************************************//
    computeCounters: function () {
        switch ( this.status ) {
            case COMPONENT.CONST.BTN_STATUS.ERROR:
                this.getCounterError().update( this.uuid, 1 );
                break;
            case COMPONENT.CONST.BTN_STATUS.WARNING:
                this.getCounterWarning().update( this.uuid, 1 );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Generic, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Generic, COMPONENT.Interface );

