//__lib__ lib_common
'use strict';

COMPONENT.RenderInterface           = function () {
};
COMPONENT.RenderInterface.prototype = {
    init: function () {
        this.initPhase( this.getDomElement() );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    //********************************************  UPDATE  *****************************************************//
    updateLabel     : function ( _to_set ) {
        if ( _to_set !== "___SHINKEN_DONT_CHANGE___" ) {
            this.component_label.updateLabel( _to_set );
        }
        this.computeClassHtml();
    },
    computeClassHtml: function () {
        DOM.Service.addOrRemoveClasses( this.getDomElement(), !this.component_label.hasLabel(), "shinken-empty" );
    }
    //********************************************  SETTER GETTER   **************************************************//
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RenderInterface, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RenderInterface, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RenderInterface, SHINKEN.OBJECT.ShinkenObjectHtml );

COMPONENT.RenderFromHtml           = function ( dom_element ) {
    this.initSpecific( dom_element );
};
COMPONENT.RenderFromHtml.prototype = {
    initSpecific: function ( dom_element ) {
        this.setDomElement( dom_element );
        this.init();
        this.component_label = new COMPONENT.Label( this.dom_element.querySelector( ".shinken-render-value" ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RenderFromHtml, COMPONENT.RenderInterface );


COMPONENT.RenderWithInheritanceFromHtml           = function ( dom_element ) {
    this.initSpecific( dom_element );
};
COMPONENT.RenderWithInheritanceFromHtml.prototype = {
    initSpecific: function ( dom_element ) {
        this.setDomElement( dom_element );
        this.init();
        try {
            this.component_label = new COMPONENT.Label( this.dom_element.querySelector( ".shinken-render-value" ) );
            this.component_label_inheritance = new COMPONENT.Label( this.dom_element.querySelector( ".shinken-render-value-from-template" ) );
        }
        catch ( e ) {
            this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
        }
    },
    updateLabel : function ( to_set_value, _to_set_value_inheritance ) {
        if ( this.component_label && to_set_value !== "___SHINKEN_DONT_CHANGE___" ) {
            this.component_label.updateLabel( to_set_value );
        }
        if ( this.component_label_inheritance && _to_set_value_inheritance !== "___SHINKEN_DONT_CHANGE___" ) {
            this.component_label_inheritance.updateLabel( _to_set_value_inheritance );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RenderWithInheritanceFromHtml, COMPONENT.RenderFromHtml );

COMPONENT.RenderFromData           = function ( value ) {
    this.initSpecific( value );
};
COMPONENT.RenderFromData.prototype = {
    initSpecific: function ( value ) {
        this.init();
        this.component_label = new COMPONENT.LabelFromData( value );
    },
    //********************************************  HTML   **************************************************//
    computeHtml: function () {
        this.component_label.computeHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-render-value-container" } ) );
        var _div_1 = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-container-of-render-value" } ) );
        var _div_2 = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-render-value-content shinken-render-value" } ), _div_1 );
        DOM.Service.addElementTo( this.component_label.getDomElement(), _div_2 );
        this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-title-of-render-value-container" }, _( "components.thresholds_display.render_label" ) ) );
        this.updateLabel( this.component_label.getLabel() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RenderFromData, COMPONENT.RenderInterface );
