//__lib__ lib_common
'use strict';

COMPONENT.InterfaceSingleSelect           = function () {
};
COMPONENT.InterfaceSingleSelect.prototype = {
    init     : function () {
        this.last_selected_key_name   = "";
        this.default_label_for_select = '--';
        this.uuid                     = SHINKEN.TOOLS.STRING.buildUUID();
    },
    hidePopup: function () {
        DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, COMPONENT.CONST.BTN_STATE.OFF );
        this.list_element.setState( COMPONENT.CONST.BTN_STATE.OFF );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnSelector    : function () {
        DOM.Service.setDataSet( this.getDomElement(), COMPONENT.CONST.SELECT.DATA_STATE_SELECTOR, this.list_element.toggleState() );
    },
    clickOnItemSelector: function ( key_name, parent ) {
        this.resetStatus();
        this.setLastSelectedElementName( key_name );
        this.hidePopup();
        if ( parent ) {
            parent.doActionAfter( "click_on_item_selector_done", this );
        }
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_selector":
                this.clickOnSelector();
                break;
            case "click_on_item_selector":
                this.clickOnItemSelector( param_1, param_2 );
                break;
        }
    },
    //********************************************  GETTER AND SETTER  **************************************************//
    getLastSelectedElement    : function () {
        return this.list_element.getContentByUUID( this.last_selected_key_name );
        
    },
    setTitle                  : function ( _to_set ) {
        if ( !this.is_editable ) {
            return;
        }
        if ( !this.dom_select ) {
            return;
        }
        var _dom_text       = this.dom_select.querySelector( '.' + COMPONENT.CONST.SELECT.SELECTOR_TEXT );
        this.title          = _to_set;
        _dom_text.innerHTML = this.title;
    },
    getValue                  : function () {
        return this.getLastSelectedElementName();
    },
    getLabel                  : function () {
        return this.getLastSelectedElement().getLabel();
    },
    computeTitle              : function () {
        this.setTitle( this.last_selected_key_name !== "" ? this.getLabel() : this.default_label_for_select );
    },
    getLastSelectedElementName: function () {
        return this.last_selected_key_name;
    },
    setLastSelectedElementName: function ( to_set ) {
        this.previous_selected_key_name = this.last_selected_key_name;
        this.last_selected_key_name     = to_set;
        this.computeTitle();
    },
    setStatus                 : function ( to_set ) {
        this.status = to_set;
        DOM.Service.setDataSet( this.getDomElement(), 'status', to_set );
    },
    resetStatus               : function () {
        this.setStatus( "" );
    },
    getListElement            : function () {
        return this.list_element;
    },
    setDefaultLabelForSelector: function ( to_set ) {
        this.default_label_for_select = to_set;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSingleSelect, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceSingleSelect, SHINKEN.OBJECT.ShinkenObjectHtml );


COMPONENT.SingleSelectFromData           = function ( property_name, selector_name ) {
    this.__class_name__          = 'COMPONENT.SingleSelectFromData';
    this.is_editable             = true;
    this.property_name           = property_name;
    this.selector_name           = selector_name || COMPONENT.CONST.SELECT.NAME_MAIN_SELECTOR;
    this.initSpecific();
};
COMPONENT.SingleSelectFromData.prototype = {
    initSpecific: function () {
        this.init();
        this.list_element = new COMPONENT.ListSelectFromData_V2( this.property_name, this.selector_name );
        this._onclick     = "MANAGER.EventManagerV2.clickSelector(event,'" + this.property_name + "')";
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setOptionsFromArray: function ( to_set ) {
        if ( to_set ) {
            for ( var i = 0, _size_i = to_set.length; i < _size_i; i++ ) {
                this.addOption( to_set[ i ] );
            }
        }
    },
    addOption          : function ( to_add ) {
        this.list_element.addFromString( to_add.name, to_add.label );
        if ( to_add.is_selected ) {
            this.setLastSelectedElementName( to_add.name );
        }
    },
    setClickEventName  : function ( to_set ) {
        this.specific_event_name = to_set;
        this._onclick            = "MANAGER.EventManagerV2.clickSelector(event,'" + this.property_name + "','" + this.specific_event_name + "')";
    },
    setParentName      : function ( to_set ) {
        this.property_name = to_set;
        
    },
    //********************************************  OTHER  *****************************************************//
    changeOptionsFromArray: function ( new_options_data ) {
        this.resetOptions();
        this.setOptionsFromArray( new_options_data );
        this.list_element.computeHtml();
        this.addDomElement( this.list_element.getDomElement() );
    },
    resetOptions          : function () {
        this.list_element.reset();
    },
    //********************************************  HTML  *****************************************************//
    computeHtml         : function () {
        this.list_element.computeHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-select-container", "data-state-selector": 0 } ) );
        
        this.dom_select = DOM.Service.createElement( "div",
            {
                class  : "shinken-select-selector shinken-user-select-none",
                onclick: this._onclick
            }, '<span class="shinken-selector-label shinken-space">' + this.default_label_for_select + '</span><span class="shinkon header-chevron shinken-2023-arrow-down"></span>' );
        this.computeTitle();
        this.addDomElement( this.dom_select );
        this.addDomElement( this.list_element.getDomElement() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.SingleSelectFromData, COMPONENT.InterfaceSingleSelect );
