//__lib__ lib_shinken_V02_01

"use strict";

SHINKEN.OBJECT.FormSetFromData           = function ( name ) {
    this.initSpecific( name );
};
SHINKEN.OBJECT.FormSetFromData.prototype = {
    initSpecific: function ( name ) {
        this.init( name );
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setActionControllerName: function ( to_set ) {
        this.action_controller_name = to_set;
    },
    //********************************************  HTML  *****************************************************//
    computeHtml            : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
    },
    computeCommonHtml      : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-form-container" } ) );
        
        var _table = DOM.Service.createElement( "table", { class: "shinken-width-100" } );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            DOM.Service.addElementTo( this.getContent( i ).getDomElement(), _table );
        }
        
        var _div = DOM.Service.createElement( "div", { class: "shinken-form-content" } );
        DOM.Service.addElementTo( _table, _div );
        this.addDomElement( _div );
        
        this.computeHtmlFooter();
        this.computeHtmlActions();
        this.computeHtmlExtra();
    },
    computeHtmlActions     : function () {
        var _div_action         = this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-form-action shinken-parent-event-listener", "data-controller": this.action_controller_name } ) );
        var _div_action_content = DOM.Service.addElementTo( DOM.Service.createElement( "div", { class: "shinken-table-form-container" } ), _div_action );
        var _table              = DOM.Service.addElementTo( DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-table-form-content" } ), _div_action_content );
        var _tr                 = DOM.Service.addElementTo( DOM.Service.createElement( "tr" ), _table );
        
        var _td_1            = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-form-action-cell" } ), _tr );
        var _button_validate = new COMPONENT.ButtonFromData( "validated_form", "shinken-validate-form", _( "form.action_button.submit", [DICTIONARY_COMMON_UI] ) );
        _button_validate.setExtraParam( this.getName() );
        _button_validate.computeHtml();
        DOM.Service.addElementTo( _button_validate.getDomElement(), _td_1 );
        
        var _td_2          = DOM.Service.addElementTo( DOM.Service.createElement( "td", { class: "shinken-form-action-cell" } ), _tr );
        var _button_cancel = new COMPONENT.ButtonFromData( "cancel_form", "shinken-cancel-form", _( "form.action_button.cancel", [DICTIONARY_COMMON_UI] ) );
        _button_cancel.setExtraParam( this.getName() );
        _button_cancel.computeHtml();
        DOM.Service.addElementTo( _button_cancel.getDomElement(), _td_2 );
    },
    computeHtmlFooter      : function () {
        this.computeFooterContent();
        var _to_add = this.getFooterContent();
        if ( _to_add ) {
            _to_add.addClass("shinken-footer-form");
            _to_add.computeHtml();
            this.addDomElement( _to_add.getDomElement() );
        }
    },
    computeSpecificHtml    : function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.FormSetFromData, SHINKEN.OBJECT.FormSet );