//__lib__ lib_common
'use strict';

SHINKEN_LIST.LineFromData           = function ( data, headers ) {
    this.init( data, headers );
};
SHINKEN_LIST.LineFromData.prototype = {
    init          : function ( data, headers ) {
        this.initContents();
        this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        this.initCellsValue( data, headers );
    },
    initCellsValue: function ( data, headers ) {
        var _current_name;
        for ( var i = 0, _size_i = headers.contents.length; i < _size_i; i++ ) {
            _current_name = headers.contents[ i ].name;
            this.add( new SHINKEN_LIST.LineCellFromData( _current_name, data[ _current_name ] ) );
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  COLLAPSE  *****************************************************//
    
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.dom_element = DOM.Service.createElement( "tr", { class: "shinken-list-line" } );
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            this.getContent( i ).computeHtml();
            this.addDomElement( this.getContent( i ).getDomElement() );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineFromData, SHINKEN_LIST.Line );
