//__lib__ lib_common
'use strict';

SHINKEN_LIST.SetFromDataWithPagination           = function () {
    this.init();
};
SHINKEN_LIST.SetFromDataWithPagination.prototype = {
    init            : function () {
        this.initPhase();
        this.initCounters();
    },
    setPagination   : function ( to_set ) {
        this.pagination = to_set;
    },
    setPageSize     : function ( to_set ) {
        this.pagination.setPageSize( to_set );
    },
    initLinesObjects: function () {
        return new SHINKEN_LIST.LinesFromDataWithPagination();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionBefore     : function ( event_name, param ) {
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_item_selector_done":
                if ( param_1.specific_event_name === "pagination_click_on_selector" ) {
                    this.pagination.doActionAfter( event_name, param_1, param_2, param_3 );
                    this.computeLinesHtml();
                }
                break;
            case "click_on_pagination_btn":
                this.pagination.doActionAfter( event_name, param_1, param_2, param_3 );
                this.computeLinesHtml();
                break;
            case "click_on_selector":
            case "click_on_item_selector":
                switch ( param_2 ) {
                    case "pagination_click_on_selector":
                    case "main_selector":
                        this.pagination.doActionAfter( event_name, param_3, this );
                        break;
                }
                break;
            default:
                this._doActionAfter( event_name, param_1, param_2, param_3 );
                break;
        }
    },
    applyFilter        : function () {
        var _filters_active = this.filters.getActiveFilters();
        this.doActionBefore( "apply_filter", _filters_active );
        this.lines.applyFilter( _filters_active );
        this.pagination.setTotalElement( this.lines.getSizeNotFiltered() );
        this.computeLinesHtml();
        this.setSelectAllStatus();
    },
    clickOnSelector    : function ( event, param ) {
        switch ( param ) {
            case "pagination_click_on_selector":
                this.pagination.clickOnSelector( event, param );
                break;
            default:
                this._clickOnSelector( event, param );
                break;
        }
    },
    clickOnItemSelector: function ( event, parent_name, element ) {
        if ( element ) {
            this.pagination.clickOnItemSelector( element.dataset.keyName, this );
        }
        this._clickOnItemSelector( event, parent_name, element );
    },
    onClick            : function ( event ) {
        this.pagination.onClick( event );
        this._onClick( event );
    },
    //********************************************  HTML  *****************************************************//
    computeSpecificHtml      : function () {
        this.pagination.setTotalElement( this.lines.getSize() );
        this.pagination.computeHtml();
        this.addDomElement( this.pagination.getDomElement() );
        this.computeSpecificHtml_lvl_1();
        this.getDomElement().classList.add( "shinken-list-has-pagination" );
    },
    computeSpecificHtml_lvl_1: function () {
    },
    computeLinesHtml         : function () {
        this.lines.computeHtml( this.pagination );
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromDataWithPagination, SHINKEN_LIST.SetFromDataWithFixHeaderFilter );
