//__lib__ lib_common
'use strict';

SHINKEN_LIST.HeadersFromHtml           = function ( dom_element, type ) {
    this.dom_element = dom_element;
    this.type        = type;
    this.init();
};
SHINKEN_LIST.HeadersFromHtml.prototype = {
    init       : function () {
        this.initContents();
        this.initHeaders();
    },
    initHeaders: function () {
        var dom_elements = DOM.Service.querySelectorAllWithOutChild( this.dom_element, "shinken-list-header", "shinken-list-table" );
        for ( var i = 0, _size_i = dom_elements.length; i < _size_i; i++ ) {
            this.add( new SHINKEN_LIST.HeaderFromHtml( dom_elements[ i ], this.type ) );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.HeadersFromHtml, SHINKEN_LIST.Headers );