//__lib__ lib_common
'use strict';

SHINKEN_LIST.LineFromHtml           = function ( dom_element, type ) {
    this.type = type;
    this.init( dom_element );
};
SHINKEN_LIST.LineFromHtml.prototype = {
    init          : function ( dom_element ) {
        this.initContents();
        this.dom_element = dom_element;
        this.is_filtered = this.dom_element.classList.contains( "shinken-is-filtered" ) ? SHINKEN_LIST.CONST.FILTER.STATUS.ON : SHINKEN_LIST.CONST.FILTER.STATUS.OFF;
        this.is_collapse = false;
        this.uuid        = this.dom_element.dataset.uuid || SHINKEN.TOOLS.STRING.buildUUID();
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.host    = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidItem ) );
                this.parent  = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeItem, this.dom_element.dataset.uuidParent ) );
                this.check   = MANAGER.__instance_element_distributor.getElement( OBJECT.ShinkenElement.generateSEUUID( this.dom_element.dataset.typeCheck, this.dom_element.dataset.uuidCheck ) );
                this.dfe_key = this.dom_element.dataset.dfeKey;
                break;
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                this.parent_uuid           = this.dom_element.dataset.uuidParent;
                this.parent_select_element = DOM.Service.findParentElementWithClass( this.dom_element, this.dom_element.dataset.parentSelectClass, 20 );
                break;
            case SHINKEN_LIST.CONST.TYPE.DATA_PROP:
                this.uuid = this.dom_element.dataset.name;
                break;
        }
        this.initIsSelected();
        this.initCellsValue();
    },
    initIsSelected: function () {
        if ( this.dom_element.classList.contains( "shinken-selected-disabled" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.DISABLED;
        }
        else if ( this.dom_element.classList.contains( "shinken-selected" ) ) {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.ON;
        }
        else {
            this.is_selected = SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_selected_counter = new SHINKEN.OBJECT.Counter();
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.MASS_CHANGE_SUM_FULL:
                if ( !this.parent_uuid ) {
                    this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_element_selected );
                }
                this.updateSelectionCounter();
                if ( this.is_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
                    this.initCounters( CONTROLLER.MassChange.steps.get().button_next, true );
                }
                break;
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                this.is_selected_counter.setParent( CONTROLLER.MassChange.mass_change_checks_selected );
                break;
        }
        var _check_box = DOM.Service.askFindChildElementWithClass( this.dom_element, "shinken-list-line-checkbox", "shinken-list-table" );
        if ( _check_box ) {
            this.checkbox = new OBJECT.ElementCheckbox( _check_box.querySelector( ".shinken-checkbox" ) );
        }
    },
    initCellsValue: function () {
        var _cells = DOM.Service.querySelectorAllWithOutChild( this.dom_element, "shinken-list-cell", "shinken-list-table" );
        var _current;
        for ( var i = 0, _size_i = _cells.length; i < _size_i; i++ ) {
            this.add( new SHINKEN_LIST.LineCellFromHtml( _cells[ i ], this.type ) );
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    
    //********************************************  COLLAPSE  *****************************************************//
    
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function ( type ) {
        var _to_return;
        switch ( this.type ) {
            case SHINKEN_LIST.CONST.TYPE.CHECK_IN_HOST:
                switch ( type ) {
                    case CONTROLLER.CONST.MASS_CHANGE.TYPE.CHECKS_EXCLUDE:
                        _to_return       = {};
                        _to_return.value = this.isSelected() ? true : false;
                        if ( this.dom_element.dataset.originalSelected === "1" ) {
                            _to_return.value = !_to_return.value;
                        }
                        _to_return.check_link = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        break;
                    default:
                        _to_return      = [];
                        _to_return[ 0 ] = this.host.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 1 ] = this.parent.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 2 ] = this.check.getDataToSave( OBJECT.CONST.ELEMENT.SAVE.TYPE.LINK );
                        _to_return[ 3 ] = this.dfe_key;
                        break;
                }
            
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.LineFromHtml, SHINKEN_LIST.Line );
