//__lib__ lib_common
"use strict";

SHINKEN_LIST.PaginationNavigation = function ( type ) {
    this.__class_name__ = "SHINKEN_LIST.PaginationNavigation";
    this.type           = type;
    this.is_disabled    = false;
    this.init();
};

SHINKEN_LIST.PaginationNavigation.prototype = {
    init: function () {
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getType    : function () {
        return this.type;
    },
    getUUID    : function () {
        return this.getType();
    },
    setDisabled: function ( to_set ) {
        this.is_disabled = to_set;
        if ( this.getDomElement() ) {
            DOM.Service.addOrRemoveClasses( this.getDomElement(), this.is_disabled, "shinken-disabled" );
        }
    },
    
    //********************************************  COMPUTE  *****************************************************//
    computeLabel: function () {
        var dom_class;
        switch ( this.type ) {
            case COMPONENT.CONST.PAGINATION_NAVIGATION.FIRST :
                dom_class = "shinken-double-arrows shinkon-double-chevron-left";
                break;
            case COMPONENT.CONST.PAGINATION_NAVIGATION.PREVIOUS :
                dom_class = "shinken-simple-arrow shinken-2023-left";
                break;
            case COMPONENT.CONST.PAGINATION_NAVIGATION.NEXT :
                dom_class = "shinken-simple-arrow shinken-2023-right";
                break;
            case COMPONENT.CONST.PAGINATION_NAVIGATION.LAST :
                dom_class = "shinken-double-arrows shinkon-double-chevron-right";
                break;
        }
        this.label = "<span class='" + dom_class + "'></span>";
    },
    computeClass: function () {
        this.class = "shinken-pagination-navigation";
        switch ( this.type ) {
            case COMPONENT.CONST.PAGINATION_NAVIGATION.FIRST :
            case COMPONENT.CONST.PAGINATION_NAVIGATION.PREVIOUS :
                this.class += " shinken-type-first-pagination";
                break;
            case COMPONENT.CONST.PAGINATION_NAVIGATION.NEXT :
            case COMPONENT.CONST.PAGINATION_NAVIGATION.LAST :
                this.class += " shinken-type-last-pagination";
                break;
        }
        
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function ( shinken_grid ) {
        if ( this.getDomElement() ) {
            return;
        }
        this.computeLabel();
        this.computeClass();
        this.setDomElement( DOM.Service.createElement( "td", { class: this.class } ) );
        this.addDomElement( DOM.Service.createElement( "div", { class: "shinken-pagination-arrow-content", onclick: "MANAGER.EventManager.clickOnButton(event, 'click_on_pagination_btn', '" + this.type + "')" }, this.label ) );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.PaginationNavigation, SHINKEN.OBJECT.ShinkenObjectHtml );