//__lib__ lib_common
"use strict";

SHINKEN_LIST.PaginationSelector = function ( total_page, current_page, parent_name ) {
    this.__class_name__ = "SHINKEN_LIST.PaginationSelector";
    this.init( total_page, current_page, parent_name );
};

SHINKEN_LIST.PaginationSelector.prototype = {
    init                : function ( total_page, current_page, parent_name ) {
        this.selector = new COMPONENT.SingleSelectFromData( parent_name );
        this.selector.setParentName( parent_name );
        this.selector.setClickEventName( "pagination_click_on_selector" );
        
        this.setTotalPage( total_page );
        this.setCurrentPage( current_page );
    },
    computeFilterOptions: function () {
        var _to_return = [];
        var _to_add;
        for ( var i = 0, _size = this.total_page; i < _size; i++ ) {
            _to_add                  = { "name": i };
            _to_add[ 'label' ]       = i + 1 + "";
            _to_add[ 'is_selected' ] = i === this.current_page;
            _to_return.push( _to_add );
        }
        return _to_return;
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnSelector    : function ( event, param ) {
        this.selector.clickOnSelector( event );
    },
    clickOnItemSelector: function ( key_name, parent ) {
        this.selector.clickOnItemSelector( key_name, parent );
        this.selector.computeTitle();
    },
    onClick            : function ( event ) {
        this.selector.hidePopup();
    },
    doActionAfter      : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_selector":
            case "click_on_item_selector":
                this.selector.doActionAfter( event_name, param_1, param_2, param_3 );
                break;
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setTotalPage  : function ( to_set ) {
        this.total_page = Math.max( 1, to_set );
        this.selector.setOptionsFromArray( this.computeFilterOptions() );
        if ( this.getDomElement() ) {
            this.computeHtml();
        }
    },
    setCurrentPage: function ( to_set ) {
        this.current_page = to_set;
        if ( this.total_page ) {
            this.selector.setLastSelectedElementName( this.current_page );
        }
    },
    getUUID       : function () {
        return "pagination_selector";
    },
    setParentName : function ( to_set ) {
        this.parent_name = to_set;
        this.selector.setParentName( this.parent_name );
    },
    //********************************************  COMPUTE  *****************************************************//
    computeClass: function () {
        this.class = "shinken-pagination-selector";
    },
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        if ( this.getDomElement() ) {
            DOM.Service.empty( this.getDomElement() );
        }
        else {
            this.computeClass();
            this.setDomElement( DOM.Service.createElement( "td", { class: this.class } ) );
        }
        this.selector.computeHtml();
        this.computeClass();
        var _to_add                 = DOM.Service.createElement( "div", { class: "shinken-pagination-cell-content", "data-name": "shinken-list-pagination" } );
        DOM.Service.addElementTo( this.selector.getDomElement(), _to_add );
        DOM.Service.addElementTo(  DOM.Service.createElement( "span", { class : "shinken-total-pagination"}, " / <span class='shinken-value'>" + this.total_page + "</span>"), _to_add );
        this.addDomElement( _to_add );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.PaginationSelector, SHINKEN.OBJECT.ShinkenObjectHtml );