//__lib__ lib_common
'use strict';

MANAGER.WindowModalManager           = function () {
    this.dom_element         = document.getElementById( 'id-shinken-window-modal' );
    this.dom_element_content = this.dom_element.querySelector( '.shinken-window-modal-content' );
    this.dom_element_loading = this.dom_element.querySelector( '.shinken-loading-text' );
    this.dom_element_close   = this.dom_element.querySelector( '#id-shinken-window-modal-close' );
    this.class_added         = "";
    this.is_open             = false;
};
MANAGER.WindowModalManager.prototype = {
    setContent        : function ( to_set ) {
        this.dom_element_content.innerHTML = to_set;
        this.dom_element.classList.remove( "shinken-hidden" );
        this.is_open = true;
    },
    showCloseContainer: function () {
        this.dom_element_close.classList.remove( "shinken-hidden" );
    },
    addClass          : function ( to_set ) {
        this.class_added = to_set;
        this.dom_element.classList.add( to_set );
    },
    addCloseEvent     : function ( event_to_ask_to_iframe, controller ) {
        this.close_event            = event_to_ask_to_iframe;
        this.close_event_controller = controller;
    },
    setIframe         : function ( url_to_set, id ) {
        if ( this.dom_element_loading ) {
            this.dom_element_content.classList.add( "shinken-hidden" );
            this.dom_element_loading.classList.remove( "shinken-hidden" );
        }
        if ( id ) {
            this.setIframeID( id );
        }
        var _id     = this._id ? 'id="' + this._id + '"' : '';
        var _to_set = '<iframe ' + _id + ' src="' + url_to_set + '"></iframe>';
        this.setContent( _to_set );
    },
    setIframeID       : function ( to_set ) {
        this._id = to_set;
    },
    iframeLoaded      : function () {
        this.dom_element_content.classList.remove( "shinken-hidden" );
        this.dom_element_loading.classList.add( "shinken-hidden" );
    },
    askDoClose        : function () {
        if ( this.close_event ) {
            SHINKEN.COMMUNICATION_WITH_IFRAME_CHILD.doActionAfter( this._id, this.close_event );
        }
        else {
            MANAGER.__instance_window_modal_manager.close();
        }
    },
    close             : function () {
        this.doClose();
        if ( this.close_event_controller ) {
            this.close_event_controller.doActionAfter( this.close_event, true );
            this.close_event_controller = null;
        }
        this.close_event = null;
    },
    doClose           : function () {
        this.is_open                       = false;
        this.dom_element_content.innerHTML = '';
        this.dom_element.classList.add( "shinken-hidden" );
        this.dom_element_close.classList.add( "shinken-hidden" );
        if ( this.class_added ) {
            this.dom_element.classList.remove( this.class_added );
            this.class_added = "";
        }
    }
};
MANAGER.__instance_window_modal_manager; //INIT IN LOADING MANAGER

SHINKEN.OBJECT.callbacksAfterCloseModal           = function () {
    this.__class_name__ = "SHINKEN.OBJECT.callbacksAfterCloseModal";
    this.init();
};
SHINKEN.OBJECT.callbacksAfterCloseModal.prototype = {
    init        : function () {
        this.resetActions();
    },
    addCallback : function ( method, param_1, param_2 ) {
        this.contents.push( new SHINKEN.OBJECT.callbackAfterCloseModal( method, param_1, param_2 ) );
    },
    doActions   : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents.pop().doAction();
        }
    },
    hasActions  : function () {
        return this.contents.length;
    },
    resetActions: function () {
        this.contents = [];
    }
};
SHINKEN.OBJECT.callbackAfterCloseModal            = function ( method, param_1, param_2 ) {
    this.__class_name__ = "SHINKEN.OBJECT.callbackAfterCloseModal";
    this.method         = method;
    this.param_1        = param_1;
    this.param_2        = param_2;
    this.init();
};
SHINKEN.OBJECT.callbackAfterCloseModal.prototype  = {
    init    : function () {
    },
    doAction: function () {
        this.method( this.param_1, this.param_2 );
    }
};