//priority 10
//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.Counter           = function ( dom_element, show_if_null ) {
    this.__class_name__ = 'SHINKEN.OBJECT.Counter';
    //type
    //nb
    //_elements_mapping
    //dom_element
    //_counter_final
    //is_discreet
    this._counter_final         = 0;
    this.label                  = "";
    this._is_label_before       = false;
    this._has_animation         = false;
    this._show_if_null          = !!show_if_null;
    this._is_string             = false;
    this._counter_parent_list   = [];
    this._elements_mapping      = {};
    this.uuid                   = SHINKEN.TOOLS.STRING.buildUUID();
    this.timeout_html           = null;
    this.type                   = '';
    this.dom_class_selector     = '';
    this._targets_dom_element   = [];
    this._show_to_parent        = true;
    this.toggle_parent_activity = false;
    this._data_target_name      = "number";
    if ( dom_element ) {
        this.init( dom_element );
    }
};
SHINKEN.OBJECT.Counter.prototype = {
    init            : function ( dom_element, update_with_dom ) {
        this.dom_element = dom_element;
        this.setDiscreet( !this.dom_element );
        if ( this.dom_element ) {
            this.dom_element_label = dom_element.querySelector( '.shinken-counter-label' );
            var _name_parent       = this.dom_element.dataset.parent;
            if ( _name_parent ) {
                this._counter_parent_list.push( MANAGER.__instance_counter_distributor.findCounter( _name_parent ) );
            }
            var _label = this.dom_element_label.querySelector( '.shinken-counter-extra-label' );
            if ( _label ) {
                this.label            = _label.outerHTML;
                this._is_label_before = !!this.dom_element_label.dataset.isBefore;
            }
            var _is_string = this.dom_element_label.dataset.isString;
            if ( _is_string ) {
                this._is_string = true;
            }
            if ( this.dom_element.dataset.showIfNull ) {
                this._show_if_null = true;
            }
            if ( this.dom_element.dataset.isDiscreet ) {
                this.setDiscreet( true );
            }
            if ( update_with_dom ) {
                this.initValueWithDom();
            }
        }
    },
    initFromParent  : function ( parent, update_with_dom ) {
        this.init( DOM.Service.askFindChildElementWithClass( parent.dom_element, this.getDomSelector(), 'shinken-counter-candidate', 30 ), update_with_dom );
    },
    initValueWithDom: function () {
        if ( !this.dom_element ) {
            return;
        }
        if ( !this.dom_element.dataset.number ) {
            return;
        }
        this.update( "init_with_dom" + this.uuid, parseInt( this.dom_element.dataset.number ) );
    },
    //********************************************  SETTER GETTER   **************************************************//
    getValue                    : function () {
        return this._counter_final;
    },
    has                         : function ( name ) {
        return !!this._elements_mapping[ name ];
    },
    setDiscreet                 : function ( to_set ) {
        this.is_discreet = !!to_set;
    },
    hasCounter                  : function () {
        return !!this._counter_final;
    },
    setShowIfNull               : function ( to_set ) {
        this._show_if_null = !!to_set;
    },
    setAnimation                : function ( to_set ) {
        this._has_animation = !!to_set;
    },
    reset                       : function () {
        this._elements_mapping = {};
        this._counter_final    = 0;
        this.showForParent( true );
        this.updateTargetDomElement();
        this._updateHTML();
    },
    showForParent               : function ( show ) {
        this._show_to_parent = !!show;
        this.updateParents();
    },
    updateParents               : function () {
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            this._counter_parent_list[ i ].update( this.uuid, this._show_to_parent ? this._counter_final : 0 );
        }
    },
    update                      : function ( name, nb_counter, tooltip, retry_update_html, is_force ) {
        if ( !nb_counter ) {
            delete this._elements_mapping[ name ];
        }
        else {
            if ( !is_force && this._elements_mapping[ name ] === nb_counter ) {
                return;
            }
            this._elements_mapping[ name ] = nb_counter;
            
        }
        if ( tooltip ) {
            this.setTooltipHtml( tooltip );
        }
        
        this._counter_final = this._is_string ? "" : 0;
        var _keys           = Object.keys( this._elements_mapping );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this._counter_final = this._counter_final + this._elements_mapping[ _keys[ i ] ];
        }
        
        //if ( nb_counter && this.type === 'total' ) {
        //    console.warn( "DEBUG", name, nb_counter, this.type, this.container_class_name, this._counter_final );
        //}
        
        this.updateTargetDomElement();
        this.updateParents();
        return this._askUpdateHTML( retry_update_html );
    },
    setParent                   : function ( to_add ) {
        if ( !to_add ) {
            return;
        }
        //if ( this.type === 'total' ) {
        //    console.warn( "GSOU setParent", this.container_class_name, to_add.container_class_name );
        //}
        
        this._counter_parent_list.push( to_add );
        this.updateParents();
        this._updateHTML();
    },
    setDataTargetName           : function ( to_set ) {
        this._data_target_name = to_set;
    },
    setDomElementLabel          : function ( to_set ) {
        this.dom_element_label = to_set;
        this.is_discreet       = false;
        this._updateHTML();
    },
    addTargetsDomElement        : function ( to_set, data_target_name ) {
        if ( data_target_name ) {
            this.setDataTargetName( data_target_name );
        }
        this._targets_dom_element.push( to_set );
        this.updateTargetDomElement();
    },
    updateTargetDomElement      : function () {
        for ( var i = 0, _size_i = this._targets_dom_element.length; i < _size_i; i++ ) {
            DOM.Service.setDataSet( this._targets_dom_element[ i ], this._data_target_name, this._counter_final || '' );
        }
    },
    setLabel                    : function ( to_set, is_before ) {
        this.label            = DOM.Service.createElement( 'span', { class: 'shinken-counter-extra-label' }, to_set ).outerHTML;
        this._is_label_before = !!is_before;
    },
    isString                    : function ( to_set ) {
        this._is_string = to_set;
    },
    _askUpdateHTML              : function ( retry_update_html ) {
        if ( this.timeout_html ) {
            clearTimeout( this.timeout_html );
        }
        var self          = this;
        this.timeout_html = setTimeout( function () {
            self._updateHTML( retry_update_html );
            self.timeout_html = null;
        }, 50 );
    },
    _updateHTML                 : function ( retry_update_html ) {
        if ( this.is_discreet ) {
            return false;
        }
        if ( !this.dom_element_label ) {
            if ( retry_update_html ) {
                var self = this;
                setTimeout( function () {
                    self._updateHTML();
                }, 100 );
            }
            return false;
        }
        
        if ( this._counter_final ) {
            this.dom_element_label.innerHTML = (this.label ? this._is_label_before ? this.label + this._counter_final : this._counter_final + this.label : this._counter_final);
            DOM.Service.setDataSet( this.dom_element, 'number', this._counter_final );
        }
        else if ( this._show_if_null ) {
            this.dom_element_label.innerHTML = '0';
            DOM.Service.setDataSet( this.dom_element, 'number', '0' );
        }
        else {
            this.dom_element_label.innerHTML = '';
            DOM.Service.setDataSet( this.dom_element, 'number', '' );
        }
        var _parent_dom_element;
        if ( this._has_animation ) {
            _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-pulsate-parent', 10 );
            if ( _parent_dom_element ) {
                DOM.Service.askAddClass( _parent_dom_element, 'shinken-pulsate', 1600 );
            }
        }
        if ( this.toggle_parent_activity ) {
            _parent_dom_element = DOM.Service.findParentElementWithClass( this.dom_element, 'shinken-counter-parent', 10 );
            if ( _parent_dom_element ) {
                if ( this._counter_final ) {
                    _parent_dom_element.classList.add( 'shinken-active' );
                }
                else {
                    _parent_dom_element.classList.remove( 'shinken-active' );
                }
            }
        }
        return true;
    },
    getDomSelector              : function () {
        switch ( this.type ) {
            case "error":
                return ".shinken-error-counter";
            case "warning":
                return ".shinken-warning-counter";
            case "user_set":
                return ".shinken-user-set-counter";
            case "total":
                return ".shinken-window-total-counter";
            default:
                return this.dom_class_selector;
        }
    },
    getObjectParentWithClassName: function ( class_name ) {
        if ( !this.object_parent ) {
            return null;
        }
        if ( this.object_parent.getObjectClassName() === class_name ) {
            return this.object_parent;
        }
        if ( !this._counter_parent_list.length ) {
            return null;
        }
        var _current;
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            _current = this._counter_parent_list[ i ].getObjectParentWithClassName( class_name );
            if ( _current ) {
                return _current;
            }
        }
        return null;
    },
    //********************************************  HTML   **************************************************//
    computeHtml: function () {
        var _value = this._counter_final;
        if ( !_value ) {
            if ( this._show_if_null ) {
                _value = 0;
            }
            else {
                _value = "";
            }
        }
        
        this.setDomElement( DOM.Service.createElement( "span", {
            class        : "shinken-counter shinken-" + this.type + "-counter",
            "data-number": _value
        } ) );
        this.dom_element_label = DOM.Service.createElement( "span", { class: "shinken-counter-label" }, _value );
        DOM.Service.addElementTo( this.dom_element_label, this.dom_element );
    },
    //********************************************  VIEW   **************************************************//
    pulsate: function () {
        if ( !this.hasCounter() ) {
            return;
        }
        if ( this.object_parent && this.object_parent.dom_element ) {
            DOM.Service.askAddClass( this.object_parent.dom_element, 'shinken-pulsate', 1600 );
        }
        else {
            DOM.Service.askAddClass( this.dom_element, 'shinken-pulsate', 1600 );
        }
        for ( var i = 0, _size_i = this._counter_parent_list.length; i < _size_i; i++ ) {
            this._counter_parent_list[ i ].pulsate();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.Counter, SHINKEN.OBJECT.ShinkenObjectHtml );

SHINKEN.OBJECT.CounterInterface           = function () {
};
SHINKEN.OBJECT.CounterInterface.prototype = {
    addExtraCounter               : function ( to_add, type, dom_class_selector, data_target_name, dom_element ) {
        to_add.type                 = type;
        to_add.container_class_name = this.getObjectClassName();
        if ( dom_class_selector ) {
            to_add.dom_class_selector = "." + dom_class_selector;
        }
        if ( data_target_name ) {
            to_add.setDataTargetName( data_target_name );
        }
        this.getExtraCounters()[ type ] = to_add;
        if ( dom_element ) {
            to_add.addTargetsDomElement( dom_element );
        }
        return to_add;
    },
    initCounters                  : function ( parent, update_with_dom ) {
        this.errors                      = new SHINKEN.OBJECT.Counter();
        this.errors.type                 = "error";
        this.errors.container_class_name = this.getObjectClassName();
        this.errors.object_parent        = this;
        
        
        this.warnings                      = new SHINKEN.OBJECT.Counter();
        this.warnings.type                 = "warning";
        this.warnings.container_class_name = this.getObjectClassName();
        
        this.user_set                      = new SHINKEN.OBJECT.Counter();
        this.user_set.type                 = "user_set";
        this.user_set.container_class_name = this.getObjectClassName();
        
        this.total                      = new SHINKEN.OBJECT.Counter();
        this.total.type                 = "total";
        this.total.container_class_name = this.getObjectClassName();
        this.initCountersDom( update_with_dom );
        if ( parent ) {
            this.setParentCounter( parent );
        }
    },
    initCountersDom               : function ( update_with_dom ) {
        if ( this.dom_element ) {
            this.errors.initFromParent( this, update_with_dom );
            this.warnings.initFromParent( this, update_with_dom );
            this.user_set.initFromParent( this, update_with_dom );
            this.total.initFromParent( this, update_with_dom );
            var _keys = Object.keys( this.getExtraCounters() );
            for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                this.getExtraCounterByName( _keys[ i ] ).initFromParent( this, update_with_dom );
            }
        }
    },
    resetCounters                 : function () {
        this.warnings.reset();
        this.errors.reset();
        this.user_set.reset();
        this.total.reset();
        var _keys = Object.keys( this.getExtraCounters() );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getExtraCounterByName( _current_key ).reset();
        }
    },
    hideCountersForParent         : function () {
        this.warnings.showForParent( false );
        this.errors.showForParent( false );
        this.user_set.showForParent( false );
        this.total.showForParent( false );
        
        var _keys = Object.keys( this.getExtraCounters() );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getExtraCounterByName( _current_key ).showForParent( false );
        }
    },
    showCountersForParent         : function () {
        this.warnings.showForParent( true );
        this.errors.showForParent( true );
        this.user_set.showForParent( true );
        this.total.showForParent( true );
        
        var _keys = Object.keys( this.getExtraCounters() );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            this.getExtraCounterByName( _current_key ).showForParent( true );
        }
    },
    setVisibilityCountersForParent: function ( to_set ) {
        to_set ? this.showCountersForParent() : this.hideCountersForParent();
    },
    hasError                      : function () {
        return this.errors.hasCounter();
    },
    hasWarning                    : function () {
        return this.warnings.hasCounter();
    },
    setError                      : function ( data_name, nb ) {
        this.errors.update( data_name, nb );
    },
    setWarning                    : function ( data_name, nb ) {
        this.warnings.update( data_name, nb );
    },
    setUserSet                    : function ( data_name, nb ) {
        this.user_set.update( data_name, nb );
    },
    setTotal                      : function ( data_name, nb ) {
        this.total.update( data_name, nb );
    },
    getCounterError               : function () {
        return this.errors;
    },
    getCounterWarning             : function () {
        return this.warnings;
    },
    getCounterUserSet             : function () {
        return this.user_set;
    },
    getCounterTotal               : function () {
        return this.total;
    },
    getExtraCounters              : function () {
        if ( !this.extraCounters ) {
            this.extraCounters = {};
        }
        return this.extraCounters;
    },
    getExtraCounterByName         : function ( name ) {
        return this.getExtraCounters()[ name ];
    },
    findExtraCounter              : function ( name ) {
        var _counter = this.getExtraCounterByName( name );
        if ( _counter ) {
            return _counter;
        }
        this.addExtraCounter( new SHINKEN.OBJECT.Counter(), name );
        return this.getExtraCounterByName( name );
    },
    setParentCounter              : function ( to_set ) {
        var _parent = to_set || this.parent_container;
        if ( _parent ) {
            this.getCounterError().setParent( _parent.getCounterError() );
            this.getCounterWarning().setParent( _parent.getCounterWarning() );
            this.getCounterUserSet().setParent( _parent.getCounterUserSet() );
            this.getCounterTotal().setParent( _parent.getCounterTotal() );
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
            this.getCounterUserSet().setParent();
            this.getCounterTotal().setParent();
        }
        this.setParentExtraCounter( _parent );
    },
    setParentExtraCounter         : function ( parent ) {
        var _keys = Object.keys( this.getExtraCounters() );
        var _current;
        var _current_key;
        var parent_counter;
        var parent_dom_counter;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key = _keys[ i ];
            _current     = this.getExtraCounterByName( _current_key );
            if ( parent ) {
                parent_counter                    = parent.findExtraCounter( _current_key );
                parent_counter.dom_class_selector = _current.dom_class_selector;
                parent_dom_counter                = DOM.Service.askFindChildElementWithClass( parent.dom_element, parent_counter.getDomSelector(), 'shinken-counter-candidate', 20 );
                if ( parent_dom_counter ) {
                    parent_counter.init( parent_dom_counter, false );
                }
                else {
                    if ( parent_counter._data_target_name === "number" ) {
                        parent_counter.setDataTargetName( _current._data_target_name );
                    }
                    parent_counter.addTargetsDomElement( parent.dom_element );
                }
                _current.setParent( parent_counter );
                parent.setParentCounter();
            }
            else {
                _current.setParent();
            }
        }
    },
    //********************************************  HTML   **************************************************//
    computeCountersHtml: function () {
        this.warnings.computeHtml();
        this.errors.computeHtml();
        this.user_set.computeHtml();
        this.total.computeHtml();
        var _keys = Object.keys( this.getExtraCounters() );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.getExtraCounterByName( _keys[ i ] ).computeHtml();
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterface, SHINKEN.OBJECT.ShinkenObject );

SHINKEN.OBJECT.CounterInterfaceValidation           = function () {
};
SHINKEN.OBJECT.CounterInterfaceValidation.prototype = {
    initCounters            : function () {
        this.errors                      = new SHINKEN.OBJECT.Counter();
        this.errors.type                 = "error";
        this.errors.container_class_name = this.getObjectClassName();
        this.errors.object_parent        = this;
        
        this.warnings                      = new SHINKEN.OBJECT.Counter();
        this.warnings.type                 = "warning";
        this.warnings.container_class_name = this.getObjectClassName();
        this.warnings.object_parent        = this;
    },
    setParentCounter        : function ( to_set ) {
        var _parent = to_set || this.parent_container;
        if ( _parent ) {
            this.getCounterError().setParent( _parent.getCounterError() );
            this.getCounterWarning().setParent( _parent.getCounterWarning() );
        }
        else {
            this.getCounterError().setParent();
            this.getCounterWarning().setParent();
        }
    },
    doActionAfterAddMessages: function () {
        this.setWarning( this.getObjectClassName(), this.messages.getNumberWarnings() );
        this.setError( this.getObjectClassName(), this.messages.getNumberErrors() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceValidation, SHINKEN.OBJECT.CounterInterface );

SHINKEN.OBJECT.CounterInterfaceHtml           = function () {
};
SHINKEN.OBJECT.CounterInterfaceHtml.prototype = {};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceHtml, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.CounterInterfaceHtml, SHINKEN.OBJECT.ShinkenObjectHtml );