//__lib__ lib_common
//priority 30
'use strict';
SHINKEN.OBJECT.SoundNotificationOfChange           = function ( data ) {
    this.init( data );
};
SHINKEN.OBJECT.SoundNotificationOfChange.prototype = {
    init: function ( data ) {
        if ( data ) {
            this.updateData( data );
        }
    },
    //**************************************    EVENT LISTENER     **************************************************//
    doActionAfter: function ( event_name, param ) {
        switch ( event_name ) {
            case "init_with_dom_element":
                if ( this.getDomElement() ) {
                    return;
                }
                if ( !param ) {
                    return;
                }
                this.setDomElement( param.querySelector( ".shinken-sound-notification-container" ) );
                this.setPhaseDomElement( param, "soundNotification" );
                break;
            case "change_value_notification_of_change_sound":
                this.setData( SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED, param );
                break;
            case "notification-configuration-set-dom-element-with-data":
                this.updateHtmlWithData();
                break;
            case "shinken_view_has_disabled_sound_notification":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "user_has_volume_muted_notification":
                this.setPhaseSpecific( SHINKEN.OBJECT.CONST.PHASE.DISCREET_USER );
                break;
            case "set_phase_sound_depending_number_of_change":
                this.setPhaseSpecific( param ? SHINKEN.OBJECT.CONST.PHASE.READY : SHINKEN.OBJECT.CONST.PHASE.STOPPING );
                break;
            case "ask_play_notification_of_sound":
                this.flat_user_volume = param;
                this.setPhaseIfPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.READY );
                break;
            case "ask_simulate_play_notification_of_sound":
                this.simulatePlayAudio( param );
                break;
            case "reset_object":
                this.setDomElement();
                break;
            case "click_done":
                if ( param.target.parentElement.classList.value !== "shinken-external-link-name-cell" ) {
                    SHINKEN_TOOLTIP.hideTooltip();
                }
                if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.DISCREET_NAVIGATOR ) ) {
                    this.setPhase( this.getPreviousPhase() );
                    return;
                }
                break;
        }
    },
    //**************************************    GETTER SETTER         **************************************************//
    getValue         : function () {
        if ( this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === undefined ) {
            return SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.VALUE.DEFAULT;
        }
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ];
    },
    playAudio        : function () {
        //The audio must be load here because we play notification after get user data.
        var audio    = MANAGER.DistributorResourcesManager.getInstance().getResource( "global_sound_notification" ).getContent();
        var _self    = this;
        audio.volume = this.flat_user_volume / 100;
        audio.play().then(
            function success ( response ) {
                _self.setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
            },
            function error ( response ) {
                console.error( response );
                _self.setPhase( SHINKEN.OBJECT.CONST.PHASE.DISCREET_NAVIGATOR );
            } );
    },
    simulatePlayAudio: function ( value ) {
        var audio    = MANAGER.DistributorResourcesManager.getInstance().getResource( "global_sound_notification" ).getContent();
        audio.volume = value / 100;
        audio.pause();
        audio.currentTime = 0;
        audio.play();
    },
    //**************************************    DATAS         **************************************************//
    updateData: function ( data ) {
        var _keys     = Object.keys( data );
        var _sizeData = _keys.length;
        var _currentKey;
        for ( var i = 0; i < _sizeData; i++ ) {
            _currentKey = _keys[ i ];
            this.setData( _currentKey, data[ _currentKey ] );
        }
    },
    setData   : function ( key, value ) {
        switch ( key ) {
            case "value":
                var _keys = Object.keys( value );
                var _current_key;
                for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
                    this.setData( _keys[ i ], value[ _keys[ i ] ] );
                }
                break;
            case SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED:
                if ( typeof value === "object" ) {
                    this[ key ] = value.value;
                }
                else {
                    this[ key ] = value;
                }
                break;
        }
    },
    //********************************************  PHASE  *****************************************************//
    setPhaseSpecific: function ( to_set ) {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.DISCREET_NAVIGATOR ) ) {
            this.setPreviousPhaseForced( to_set );
        }
        else {
            this.setPhase( to_set );
        }
    },
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        this.setTooltipHtml( "" );
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.playAudio();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.DISCREET_USER:
                this.setTooltipHtml( _( "notification.sound_user_warning", [DICTIONARY_COMMON_UI] ) );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.DISCREET_NAVIGATOR:
                this.setTooltipHtml( _( "notification.sound_navigator_warning", [DICTIONARY_COMMON_UI] ) );
                SHINKEN_TOOLTIP.showTooltip( this.getDomElement() );
                break;
            default:
                break;
        }
    },
    //**************************************    SAVE         **************************************************//
    getDataToSave: function () {
        var _to_return                                                          = {};
        _to_return[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] = this.getValue();
        return _to_return;
    },
    //**************************************    HTML         **************************************************//
    updateHtmlWithData: function () {
        var _dom     = document.querySelector( "#shinken-modal-container #sound-" + this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] );
        _dom.checked = true;
    },
    isEnabled         : function () {
        return this[ SHINKEN.OBJECT.NOTIFICATION.CONST.OF_CHANGE.FIELD.ENABLED ] === true;
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SoundNotificationOfChange, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SoundNotificationOfChange, SHINKEN.OBJECT.ShinkenObjectHtml );
