//priority 3
//__lib__ lib_common
"use strict";
SHINKEN.OBJECT.ShinkenObject           = function () {
    this.__class_name__ = "SHINKEN.OBJECT.ShinkenObject";
};
SHINKEN.OBJECT.ShinkenObject.prototype = {
    //********************************************  DEBUG   **************************************************//
    setShinkenDebug : function ( to_set ) {
        this.is_shinken_debug = to_set;
        var _components       = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            if ( _components[ i ] ) {
                _components[ i ].setShinkenDebug( to_set );
            }
        }
    },
    isShinkenDebugOn: function () {
        return this.is_shinken_debug;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getChildrenObject       : function () {
        return [];
    },
    getChildrenObjectDict   : function () {
        return {};
    },
    initMessages            : function ( to_set ) {
        this.messages = new OBJECT.Messages();
    },
    setMessages             : function ( to_set ) {
        this.initMessages();
        if ( !to_set ) {
            return;
        }
        var _keys = Object.keys( to_set );
        
        var _current_key;
        var _current_status;
        for ( var i = 0, _size_i = _keys.length; i < _size_i; i++ ) {
            _current_key    = _keys[ i ];
            _current_status = OBJECT.MessageService.parseBackendStatus( _current_key );
            for ( var j = 0, _size_j = to_set[ _current_key ].length; j < _size_j; j++ ) {
                this.messages.addMessage( _current_status, to_set[ _current_key ][ j ] );
            }
        }
        this.doActionAfterAddMessages();
    },
    addMessages             : function ( shinken_messages ) {
        this.messages.addMessages( shinken_messages.getAllMessages() );
    },
    addMessage              : function ( status, text ) {
        if ( !this.messages ) {
            this.messages = new OBJECT.Messages();
        }
        this.messages.addMessage( status, text );
    },
    doActionAfterAddMessages: function () {
    },
    getMessages             : function () {
        return this.messages;
    },
    getAllObjectWithMessages: function () {
        var to_return = [];
        if ( this.messages && this.messages.hasStatus() ) {
            to_return.push( this );
        }
        var _components = this.getChildrenObject();
        for ( var j = 0, _size_j = _components.length; j < _size_j; j++ ) {
            if ( _components[ j ] ) {
                to_return = SHINKEN.TOOLS.ARRAY.concat( to_return, _components[ j ].getAllObjectWithMessages() );
            }
        }
        return to_return;
    },
    //********************************************  VALIDATION   **************************************************//
    setNeedValidation: function ( to_set ) {
        this.need_validation = to_set;
        var _components      = this.getChildrenObject();
        for ( var i = 0, _size_i = _components.length; i < _size_i; i++ ) {
            _components[ i ].setNeedValidation( to_set );
        }
    },
    //********************************************  OTHER   **************************************************//
    getObjectClassName: function () {
        return this.__class_name__;
    },
    isObjectClassName : function ( to_test ) {
        return to_test === this.__class_name__;
    }
};

SHINKEN.OBJECT.InterfaceHtml           = function () {
};
SHINKEN.OBJECT.InterfaceHtml.prototype = {
    //********************************************  GETTER SETTER  *****************************************************//
    addClass: function ( to_add ) {
        if ( !this.class ) {
            this.class = to_add;
        }
        else {
            this.class = this.class + " " + to_add;
        }
    },
    getClass: function ( to_add ) {
        return this.class || "";
    }
};

SHINKEN.OBJECT.ShinkenObjectHtml           = function () {
};
SHINKEN.OBJECT.ShinkenObjectHtml.prototype = {
    //********************************************  SETTER GETTER   **************************************************//
    setDomElement             : function ( to_set ) {
        this.dom_element = to_set;
        this.doActionAfterSetDomElement();
    },
    setLabel                  : function ( to_set ) {
        this.label = to_set;
    },
    getLabel                  : function () {
        return this.label;
    },
    doActionAfterSetDomElement: function () {
    },
    getDomElement             : function () {
        return this.dom_element;
    },
    addDomElement             : function ( to_add ) {
        return DOM.Service.addElementTo( to_add, this.getDomElement() );
    },
    changeContentDomElement   : function ( new_content ) {
        DOM.Service.empty( this.getDomElement() );
        this.addDomElement( new_content );
    },
    askUpdateHtml             : function () {
        var self = this;
        if ( self.timeout_ask_compute_html ) {
            clearTimeout( self.timeout_ask_compute_html );
        }
        self.timeout_ask_compute_html = setTimeout( function () {
            self.updateHtml();
            self.timeout_ask_compute_html = null;
        }, 200 );
    },
    updateHtml                : function () {
    },
    resetHTML                : function () {
        DOM.Service.removeElement(this.getDomElement());
    },
    computeHtml               : function () {
        this.computeHtmlExtra();
    },
    computeHtmlExtra          : function () {
    },
    getObjectType             : function () {
        return "";
    },
    computeHtml_setEventName  : function ( to_set ) {
        this.event_name = to_set;
    },
    computeHtml_setParamName  : function ( to_set ) {
        this.param_name = to_set;
    },
    setVisibilityState        : function ( to_set ) {
        this.visibility_state = to_set;
        if ( this.getDomElement() ) {
            DOM.Service.setDataSet( this.getDomElement(), "visibilityState", this.getVisibilityState() );
        }
        this.setVisibilityState_lvl_1();
    },
    setVisibilityState_lvl_1        : function ( to_set ) {
    },
    getVisibilityState        : function () {
        return this.visibility_state || "";
    },
    isVisible        : function () {
        switch ( this.visibility_state ){
            case SHINKEN.CONST.VISIBILITY_STATE.HIDDEN:
            case SHINKEN.CONST.VISIBILITY_STATE.TOTALLY_FORM_EXCLUDE:
                return false;
        }
        return true;
    },
    //********************************************  EVENT LISTENER  **************************************************//
    onClick       : function ( event ) {
    },
    hidePopup     : function ( event ) {
    },
    askHidePopup  : function ( dom_element ) {
        if ( dom_element === this.getDomElement() ) {
            return false;
        }
        this.hidePopup( dom_element );
        return true;
    },
    askAddClass   : function ( to_add, time_out ) {
        if ( !time_out ) {
            return;
        }
        if ( !this.getDomElement() ) {
            var self = this;
            setTimeout( function () {
                self.askAddClass( to_add, time_out - 100 );
            }, 100 );
            return;
        }
        
        DOM.Service.askAddClass( this.getDomElement(), to_add, time_out );
    },
    //********************************************  UPDATE HTML  **************************************************//
    setTooltipHtml     : function ( to_set, tooltip_type ) {
        this.tooltip_html = to_set;
        this.tooltip_type = tooltip_type;
        this.computeHtml_tooltip();
    },
    computeHtml_tooltip: function () {
        var _dom = this.getDomElement();
        if ( !_dom ) {
            return;
        }
        if ( this.tooltip_html ) {
            _dom.setAttribute( "onmouseenter", "SHINKEN_TOOLTIP.showTooltip(this)" );
            _dom.setAttribute( "onmouseleave", "SHINKEN_TOOLTIP.hideTooltip()" );
            if ( this.tooltip_type ) {
                this.dom_element.setAttribute( "shi-tip-type", this.tooltip_type );
            }
            _dom.setAttribute( "shi-tip-html", this.tooltip_html );
        }
        else {
            _dom.setAttribute( "shi-tip-html", "" );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectHtml, SHINKEN.OBJECT.ShinkenObject );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectHtml, SHINKEN.OBJECT.InterfaceHtml );


SHINKEN.OBJECT.ShinkenObjectContainer           = function () {
};
SHINKEN.OBJECT.ShinkenObjectContainer.prototype = {
    initContents: function () {
        this.contents = [];
        this.mapping  = {};
    },
    //********************************************  SETTER GETTER   **************************************************//
    getSize              : function () {
        return this.contents.length;
    },
    getContents          : function () {
        return this.contents;
    },
    getContent           : function ( index ) {
        return this.contents[ index ];
    },
    getContentByUUID     : function ( uuid ) {
        var _index = this.mapping[ uuid ];
        if ( _index === undefined ) {
            return null;
        }
        return this.contents[ _index ];
    },
    getMappingIndex : function ( uuid ) {
        return this.mapping[ uuid ];
    },
    add                  : function ( to_add ) {
        if ( this.mapping[ to_add.getUUID() ] !== undefined ) {
            this.contents[ this.mapping[ to_add.getUUID() ] ] = to_add;
        }
        else {
            this.mapping[ to_add.getUUID() ] = this.contents.push( to_add ) - 1;
        }
        return to_add;
    },
    insertAtIndex        : function ( to_add, index ) {
        SHINKEN.TOOLS.ARRAY.insert( this.contents, to_add, index );
        this.computeMapping();
    },
    removeContent        : function ( uuid_to_remove ) {
        var _to_remove = this.getContentByUUID( uuid_to_remove );
        if ( !_to_remove ) {
            return;
        }
        _to_remove.remove();
        SHINKEN.TOOLS.ARRAY.removeElementByIndex( this.contents, this.mapping[ uuid_to_remove ] );
        this.computeMapping();
    },
    resetContents        : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].remove();
        }
        this.initContents();
    },
    resetContentsCounters: function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].resetCounters ) {
                this.contents[ i ].resetCounters();
            }
        }
    },
    computeMapping       : function () {
        this.mapping = {};
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.mapping[ this.contents[ i ].getUUID() ] = i;
        }
    },
    getObjectsType       : function () {
        return "";
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectContainer, SHINKEN.OBJECT.ShinkenObject );

SHINKEN.OBJECT.ShinkenObjectContainerHtml           = function () {
};
SHINKEN.OBJECT.ShinkenObjectContainerHtml.prototype = {
    //********************************************  EVENT LISTENER   **************************************************//
    onClick     : function ( event ) {
        this.askHidePopup( this.getDomByEvent( event ) );
    },
    askHidePopup: function ( dom_element ) {
        if ( dom_element === this.getDomElement() ) {
            return false;
        }
        this.hidePopup();
        var _keys = Object.keys( this.contents );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.contents[ _keys[ i ] ].askHidePopup( dom_element );
        }
        return true;
    },
    //********************************************  SETTER GETTER   **************************************************//
    getContentByEvent: function ( event ) {
        if ( !event ) {
            return null;
        }
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, "name", 10 );
        if ( !_parent_dom_element ) {
            return null;
        }
        var _type = _parent_dom_element.dataset.objectType;
        if ( _type === this.getObjectsType() ) {
            return this.getContentByUUID( _parent_dom_element.dataset.name );
        }
    },
    getDomByEvent    : function ( event ) {
        if ( !event ) {
            return null;
        }
        return DOM.Service.findParentElementWithDataSet( event.target, "name", 10 );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectContainerHtml, SHINKEN.OBJECT.ShinkenObjectContainer );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ShinkenObjectContainerHtml, SHINKEN.OBJECT.ShinkenObjectHtml );

