//__lib__ lib_common
'use strict';

SHINKEN.OBJECT.InterfaceSlidePanelHorizontal           = function () {
};
SHINKEN.OBJECT.InterfaceSlidePanelHorizontal.prototype = {
    init    : function ( name, dom_element_main_part, min_width, max_width ) {
        this.initCommon();
        this.setName( name );
        this.setMainPartDomElement( dom_element_main_part );
        this.setMinWidth( min_width );
        this.setMaxWidth( max_width );
    },
    initSize: function ( init_with_ratio ) {
        this.width_screen   = window.innerWidth;
        this.width_original = DOM.Service.getBoundingClientRect( this.dom_element_main_part.parentElement, DOM.CONST.STYLE.WIDTH );
        this.computeAfterResize( this.width_original * (init_with_ratio || 0.5) );
    },
    initSizePixel: function ( pixels ) {
        this.width_screen   = window.innerWidth;
        this.width_original = DOM.Service.getBoundingClientRect( this.dom_element_main_part.parentElement, DOM.CONST.STYLE.WIDTH );
        this.computeAfterResize( pixels );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    onDragStop: function () {
        this.current_width = DOM.Service.getBoundingClientRect( this.td_content, DOM.CONST.STYLE.WIDTH );
    },
    askClose  : function () {
        DOM.Service.addOrRemoveClasses( this.td_content, true, "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, true, "shinken-hidden" );
    },
    askOpen   : function () {
        DOM.Service.addOrRemoveClasses( this.td_content, false, "shinken-hidden" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, false, "shinken-hidden" );
    },
    computePinButtons : function ( current_width ) {
        DOM.Service.addOrRemoveClasses( this.td_buttons, this.min_width === current_width, "shinken-min-width-on" );
        DOM.Service.addOrRemoveClasses( this.td_buttons, this.getMaxWidth() === current_width, "shinken-max-width-on" );
    },
    doActionAfter    : function ( event_name, param ) {
        switch ( event_name ) {
            case "compute_after_resize_done":
                this.computePinButtons( this.current_width );
                break;
        }
    },
    //********************************************  COMPUTE  *****************************************************//
    computeAfterResize  : function ( width ) {
        if ( width < this.min_width ) {
            width = this.min_width;
        }
        else if ( width > this.max_width ) {
            width = this.max_width;
        }
        this.current_width = width;
        DOM.Service.setStyle( this.td_content, DOM.CONST.STYLE.WIDTH, this.current_width );
        this.doActionAfter( "compute_after_resize_done" );
    },
    computeAfterDragMove: function ( delta_x ) {
        var _new_width = this.current_width - delta_x;
        if ( _new_width < this.min_width ) {
            _new_width = this.min_width;
        }
        if ( _new_width > this.getMaxWidth() ) {
            _new_width = this.getMaxWidth();
        }
        DOM.Service.setStyle( this.td_content, DOM.CONST.STYLE.WIDTH, _new_width );
        this.computePinButtons( _new_width );
    },
    computeSizes        : function () {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.INIT ) ) {
            return;
        }
        var _new_width = window.innerWidth;
        var _ratio     = _new_width / this.width_screen;
        this.computeAfterResize( this.current_width * _ratio );
        this.width_screen = _new_width;
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getMaxWidth    : function () {
        return this.max_width;
    },
    setMinWidth    : function ( to_set ) {
        this.min_width = to_set;
    },
    setMaxWidth    : function ( to_set ) {
        this.max_width = to_set;
    },
    getCurrentRatio: function () {
        return this.current_width / this.width_original;
    },
    //********************************************  HTML  *****************************************************//
    computeButtonHtml      : function () {
        var _to_return  = DOM.Service.createElement( "td", { class: "shinken-slide-panel-table-cell-buttons" } );
        var _buttons    = DOM.Service.createElement( "div", { class: "shinken-slide-panel-buttons shinken-user-select-none" } );
        var _div_shadow = DOM.Service.createElement( "div", { class: "shinken-slide-panel-buttons-shadow" } );
        DOM.Service.addElementTo( _div_shadow, _buttons );
        DOM.Service.addElementTo( _buttons, _to_return );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class      : "shinken-slide-panel-button shinkon shinkon-double-chevron-right",
            onclick    : "MANAGER.EventManager.clickOnButton(event)",
            "data-type": "slide-panel-horizontal",
            "data-name": this.name + "-" + SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_RIGHT
        } ), _buttons );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class                          : "shinken-slide-panel-button shinkon shinkon-resize-vertical shinken-draggable",
            "data-drag-is-in-screen"       : true,
            "data-drag-resize-element-name": this.name,
            "data-type"                    : "slide-panel-horizontal",
            onmousedown                    : "MANAGER.DragNDropManager.dragStartSingle(event)"
        } ), _buttons );
        DOM.Service.addElementTo( DOM.Service.createElement( "div", {
            class      : "shinken-slide-panel-button shinkon shinkon-double-chevron-left",
            onclick    : "MANAGER.EventManager.clickOnButton(event)",
            "data-type": "slide-panel-horizontal",
            "data-name": this.name + "-" + SHINKEN.OBJECT.SLIDE_PANEL.ACTION.PIN_TO_LEFT
        } ), _buttons );
        return _to_return;
    },
    _computeHtml           : function () {
        this.setDomElement( DOM.Service.createElement( "div", {
            class: "shinken-slide-panel-content shinken-height-100"
        } ) );
        if ( this.content_html ) {
            this.addDomElement( this.content_html );
        }
        this.modifyStructureMainPart();
    },
    modifyStructureMainPart: function () {
        var _dom_parent        = this.dom_element_main_part.parentElement;
        var _main_container    = DOM.Service.createElement( "div", { class: "shinken-slide-panel-content-all", "data-type": this.type } );
        var _table_structure   = DOM.Service.createElement( "table", { class: "shinken-table" } );
        this._tr_structure     = DOM.Service.createElement( "tr" );
        this._td_for_main_part = DOM.Service.createElement( "td", { class: "shinken-main-part-cell shinken-vertical-align-top" } );
        this.td_content        = DOM.Service.createElement( "td", { class: "shinken-slide-panel-table-cell-content shinken-vertical-align-top" } );
        this.td_buttons        = this.computeButtonHtml();
        DOM.Service.addElementTo( this.getDomElement(), this.td_content );
        DOM.Service.addElementTo( this._tr_structure, _table_structure );
        DOM.Service.addElementTo( _table_structure, _main_container );
        DOM.Service.addElementTo( _main_container, _dom_parent );
        DOM.Service.addElementTo( this.dom_element_main_part, this._td_for_main_part );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.InterfaceSlidePanelHorizontal, SHINKEN.OBJECT.InterfaceSlidePanel );

SHINKEN.OBJECT.SlidePanelRight           = function ( name, dom_element_main_part, min_width, max_width ) {
    this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_RIGHT );
    this.init( name, dom_element_main_part, min_width, max_width );
};
SHINKEN.OBJECT.SlidePanelRight.prototype = {
    //********************************************  EVENT LISTENER  *****************************************************//
    pinToRight: function () {
        var _width = this.min_width || 0;
        this.computeAfterResize( _width );
    },
    pinToLeft : function () {
        this.computeAfterResize( this.getMaxWidth() || this.width_original );
    },
    //********************************************  SETTER GETTER  *****************************************************//
    
    //********************************************  HTML   **************************************************//
    computeHtml: function () {
        this._computeHtml();
        DOM.Service.addElementTo( this._td_for_main_part, this._tr_structure );
        DOM.Service.addElementTo( this.td_buttons, this._tr_structure );
        DOM.Service.addElementTo( this.td_content, this._tr_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelRight, SHINKEN.OBJECT.InterfaceSlidePanelHorizontal );

SHINKEN.OBJECT.SlidePanelLeft           = function ( name, dom_element_main_part, min_width, max_width ) {
    this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_LEFT );
    this.init( name, dom_element_main_part, min_width, max_width );
};
SHINKEN.OBJECT.SlidePanelLeft.prototype = {
    //********************************************  EVENT LISTENER  *****************************************************//
    pinToRight: function () {
        this.computeAfterResize( this.getMaxWidth() || this.width_original );
    },
    pinToLeft : function () {
        var _width = this.min_width || 0;
        this.computeAfterResize( _width );
    },
    //********************************************  SETTER GETTER  *****************************************************//
    
    
    //********************************************  HTML   **************************************************//
    computeHtml: function () {
        this._computeHtml();
        DOM.Service.addElementTo( this.td_content, this._tr_structure );
        DOM.Service.addElementTo( this.td_buttons, this._tr_structure );
        DOM.Service.addElementTo( this._td_for_main_part, this._tr_structure );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelLeft, SHINKEN.OBJECT.InterfaceSlidePanelHorizontal );

SHINKEN.OBJECT.SlidePanelLeftFromHtml           = function ( name, dom_element, min_width, max_width ) {
    this.setType( SHINKEN.OBJECT.SLIDE_PANEL.TYPE.HORIZONTAL_LEFT );
    this.initSpecific( name, dom_element, min_width, max_width );
};
SHINKEN.OBJECT.SlidePanelLeftFromHtml.prototype = {
    initSpecific: function ( name, dom_element, min_width, max_width ) {
        this.init( name, dom_element.querySelector( ".shinken-slide-panel-main-part" ), min_width, max_width );
        this.td_content        = dom_element.querySelector( ".shinken-slide-panel-table-cell-content" );
        this.td_buttons        = dom_element.querySelector( ".shinken-slide-panel-table-cell-buttons" );
        this._td_for_main_part = dom_element.querySelector( ".shinken-main-part-cell" );
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    pinToRight: function () {
        this.computeAfterResize( this.getMaxWidth() || this.width_original );
    },
    pinToLeft : function () {
        var _width = this.min_width || 0;
        this.computeAfterResize( _width );
    },
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.SlidePanelLeftFromHtml, SHINKEN.OBJECT.InterfaceSlidePanelHorizontal );
