//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.ViewHistory           = function ( parent, name, page_size ) {
    this.init( parent, name, page_size );
};
SHINKEN.OBJECT.ViewHistory.prototype = {
    init                     : function ( parent, name, page_size ) {
        this.initPhase();
        this.name                      = name || "view_history_name_default";
        this.parent                    = parent;
        this.page_size                 = page_size;
        this.current_history_view_list = new SHINKEN_LIST.SetFromDataWithPagination();
        this.current_history_view_list.setPagination( new SHINKEN_LIST.Pagination( this.getPageSize(), this.name ) );
        this.current_history_view_list.setHeaders( new SHINKEN_LIST.HeadersFromData(
            [
                { name: SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.DATE_HISTORY, label: _( "list.header_history.date_history", [DICTIONARY_COMMON_UI] ) },
                { name: SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.USER_HISTORY, label: _( "list.header_history.user_history", [DICTIONARY_COMMON_UI] ) },
                { name: SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY, label: _( "list.header_history.text_history", [DICTIONARY_COMMON_UI] ) }
            ] ) );
    },
    getPageSize              : function () {
        return this.page_size;
    },
    getHistoryDataFromBackend: function ( url ) {
        var _success = ( _status, data ) => {
            this.formatAndApplyData( data.output );
        };
        SHINKEN.COMUNICATION.requestGet( url, _success );
    },
    formatAndApplyData       : function ( data ) {
        let _data_formatted = this.parseBackendData( data );
        this.current_history_view_list.setLines( this.current_history_view_list.computeLines( _data_formatted ) );
        this.parent.doActionAfter( "history_backend_loaded_done" );
    },
    
    //********************************************  EVENT LISTENER  **************************************************//
    doActionAfter: function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_pagination_btn":
                this.current_history_view_list.doActionAfter( event_name, param_1 );
                break;
            case "click_on_selector":
            case "click_on_item_selector":
                this.current_history_view_list.doActionAfter( event_name, param_1, param_2, param_3 );
                break;
        }
    },
    //********************************************  PARSING  *****************************************************//
    parseBackendData                     : function ( data ) {
        let _to_return = [];
        for ( let i = 0; i < data.length; i++ ) {
            _to_return.push( this.parseBackendDataLine( data[ i ] ) );
        }
        return _to_return;
    },
    parseBackendDataLine                 : function ( data ) {
        let _to_return                                                     = {};
        _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.DATE_HISTORY ] = DATE_TIME.getDateAndTimeToHtml( data.date );
        _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.USER_HISTORY ] = data.instigator_user.user_name;
        _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = "";
        switch ( data.action.type ) {
            case "SAVE":
                _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.action.update", [DICTIONARY_COMMON_UI] );
                break;
            case "CREATION":
                _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.action.creation", [DICTIONARY_COMMON_UI] );
                break;
            case "CLONE":
                let sanitized_data_string                                          = SHINKEN.TOOLS.STRING.cleanXss( data.action.context.reference_weather.name );
                _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = SHINKEN.TOOLS.STRING.format( _( "history.views.copy", ["ui_visu_lang"] ), sanitized_data_string );
                break;
            case "NEW_OWNER":
                _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = SHINKEN.TOOLS.STRING.format( _( "history.action.new_owner", [DICTIONARY_COMMON_UI] ), data.action.context.new_owner.user_name );
                break;
            case "UPDATE":
                _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = this.parseBackendDataLineForActionUpdate( data );
                break;
            case "DELETION":
                _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] += _( "history.action.delete", [DICTIONARY_COMMON_UI] );
                _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] += this.parseBackendDataLineForActionDeletion( data );
                break;
            case "RESTORATION":
                _to_return[ SHINKEN.OBJECT.VIEW.HISTORY.LIST.HEADER.TEXT_HISTORY ] = _( "history.action.restore", [DICTIONARY_COMMON_UI] );
                break;
        }
        return _to_return;
    },
    parseBackendDataLineForActionDeletion: function ( data ) {
        //let text_history_deletion = "";
        //let groups = "";
        //if ( data.groups && data.groups.length === 1 ) {
        //    text_history_deletion += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.shared_links_removed_from_groups", ["ui_visu_lang"] ) ) + "</div>";
        //}-
        //else {
        //    for ( let i = 0, _size_i = data.groups.length; i < _size_i; i++ ) {
        //    groups +=  data.groups[i] + " ";
        //    }
        //    text_history_deletion += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.shared_links_removed_from_groups", ["ui_visu_lang"] ), groups ) + "</div>";
        //
        //}
        return "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.shared_links_removed_from_groups", ["ui_visu_lang"] ) ) + "</div>";
    },
    
    parseBackendDataLineForActionUpdate: function ( data ) {
        let text_history_update = "";
        if ( data.action.context.published.new && !data.action.context.published.old ) {
            text_history_update += "<div class='shinken-history-action'>" + _( "history.views.weather.update_publish", ["ui_visu_lang"] ) + "</div>";
        }
        if ( data.action.context.nb_widgets.old > data.action.context.nb_widgets.new ) {
            let nb_widgets = data.action.context.nb_widgets.old - data.action.context.nb_widgets.new;
            if ( nb_widgets === 1 ) {
                text_history_update += "<div class='shinken-history-action'>" + _( "history.views.weather.update_remove_widget", ["ui_visu_lang"] ) + "</div>";
            }
            else {
                text_history_update += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.update_remove_widgets", ["ui_visu_lang"] ), nb_widgets ) + "</div>";
            }
        }
        if ( data.action.context.nb_widgets.old < data.action.context.nb_widgets.new ) {
            let nb_widgets = data.action.context.nb_widgets.new - data.action.context.nb_widgets.old;
            if ( nb_widgets === 1 ) {
                text_history_update += "<div class='shinken-history-action'>" + _( "history.views.weather.update_add_widget", ["ui_visu_lang"] ) + "</div>";
            }
            else {
                text_history_update += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.update_add_widgets", ["ui_visu_lang"] ), nb_widgets ) + "</div>";
            }
        }
        if ( data.action.context.new_links.length > 0 ) {
            for ( let i = 0; i < data.action.context.new_links.length; i++ ) {
                text_history_update += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.new_link", ["ui_visu_lang"] ), data.action.context.new_links[ i ].link_name ) + "</div>";
            }
        }
        if ( data.action.context.removed_links.length > 0 ) {
            for ( let j = 0; j < data.action.context.removed_links.length; j++ ) {
                text_history_update += "<div class='shinken-history-action'>" + SHINKEN.TOOLS.STRING.format( _( "history.views.weather.remove_link", ["ui_visu_lang"] ), data.action.context.removed_links[ j ].link_name ) + "</div>";
            }
        }
        return text_history_update;
    },
    //*******************************************  GETTER SETTER  ****************************************************//
    setDomElementTarget: function ( dom_element_target ) {
        this.dom_element_parent_target = dom_element_target;
    },
    //****************************²****************  EXPORT DATA  *****************************************************//
    getDataToExport: function () {
        return this.current_history_view_list.getDataToExport();
    },
    //*******************************************  OTHER  ****************************************************//
    reset: function () {
        this.resetHTML();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.INIT );
    },
    //*******************************************  HTML  ****************************************************//
    computeHtml        : function () {
        this.current_history_view_list.computeHtml();
        this.setDomElement( DOM.Service.createElement( 'div', { class: "shinken-view-history" } ) );
        this.addDomElement( this.current_history_view_list.getDomElement() );
    },
    addLoading         : function ( text_to_add ) {
        if ( !this.dom_element_parent_target ) {
            return;
        }
        DOM.Service.addLoadingFrameV2( this.dom_element_parent_target );
    },
    clickOnItemSelector: function ( event, parent_name, element ) {
        this.current_history_view_list.clickOnItemSelector( event, parent_name, element );
        this.computeSizes();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ViewHistory, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ViewHistory, SHINKEN.OBJECT.PhaseInterface );