//__lib__ lib_shinken_V02_01
'use strict';

PROPERTY.RadioListAbstract           = function () {
};
PROPERTY.RadioListAbstract.prototype = {
    init: function () {
        this.state = null;
    },
    //********************************************  EVENT LISTENER  **************************************************//
    ___clickOnRadioBtn: function ( value ) {
        this.component_radio_list.clickOnRadioBtn( value );
        this.updateView();
    },
    doActionAfter     : function ( event_name, param ) {
        switch ( event_name ) {
            case "do_action_after_init_dom_element":
                this.setValueFromUser( param );
                break;
            case "value_changed":
                this.component_radio_list.doActionAfter( event_name, param );
                break;
        }
    },
    //********************************************  GET / SET ***********************************************//
    ___unset                : function () {
        this.setValueFromUser( '' );
    },
    setValueFromUser        : function ( value ) {
        if ( !value ) {
            value = PROPERTY.CONST.COMMON.VALUE.DEFAULT;
        }
        this.clickOnRadioBtn( value );
    },
    setDefaultValue         : function ( to_set ) {
        this.component_radio_list.setDefaultValue( to_set );
    },
    setButtonVisibilityState: function ( button_name, to_set ) {
        this.component_radio_list.setButtonVisibilityState( button_name, to_set );
    },
    setButtonTooltip: function ( button_name, to_set, tooltip_type ) {
        this.component_radio_list.setButtonTooltip( button_name, to_set, tooltip_type );
    },
    getNbButtonVisible                  : function () {
        var _to_return = 0;
        for ( var i = 0, _size_i = this.component_radio_list.getSize(); i < _size_i; i++ ) {
            if ( this.component_radio_list.getContent(i).isVisible() ) {
                _to_return++;
            }
        }
        return _to_return;
    },
    //********************************************  SAVE     *********************************************************//
    getValue          : function () {
        return this.component_radio_list.getValue();
    },
    getDataToSaveFinal: function () {
        return this.getValue();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListAbstract, PROPERTY.InterfaceCommon );

PROPERTY.RadioListFromHtml           = function ( dom_element ) {
    this.initSpecific( dom_element );
};
PROPERTY.RadioListFromHtml.prototype = {
    initSpecific: function ( dom_element ) {
        this.init();
        this.initWithDomElement( dom_element );
        this.component_radio_list = new COMPONENT.RadioListGeneric( dom_element, this );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromHtml, PROPERTY.RadioListAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromHtml, PROPERTY.InterfaceCommonFromHtml );

PROPERTY.RadioListFromData           = function ( property_name, data_buttons ) {
    this.initSpecific( property_name, data_buttons );
};
PROPERTY.RadioListFromData.prototype = {
    initSpecific: function ( property_name, data_buttons ) {
        this.name                 = property_name;
        this.component_radio_list = new COMPONENT.RadioListFromData( data_buttons, this.name );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY.CONST.COMMON.TYPES.RADIO_LIST;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_radio_list.computeHtml();
        DOM.Service.addElementTo( this.component_radio_list.getDomElement(), this.dom_cell_action );
    },
    computeHtml_setEventName            : function ( to_set ) {
        return this.component_radio_list.computeHtml_setEventName( to_set );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromData, PROPERTY.RadioListAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.RadioListFromData, PROPERTY.InterfaceCommonFromData );
