//__lib__ lib_shinken_V02_01
'use strict';

PROPERTY.StringInputAbstract           = function () {
};
PROPERTY.StringInputAbstract.prototype = {
    init: function () {
    },
    //********************************************  EVENT LISTENER  **************************************************//
    askComputeAfterChange: function () {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( null, this );
    },
    doActionAfterChange  : function ( args ) {
    },
    onFocus              : function () {
    },
    ___onFocusOut        : function () {
    },
    doActionAfter        : function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "click_on_button":
                switch ( param_1 ) {
                    case "clean_input_value":
                        this.component_input.setValueFromJs( "" );
                        break;
                }
                break;
        }
    },
    //********************************************  SETTER GETTER   **************************************************//
    setValueFromUser: function ( value ) {
        this.component_input.setValueFromJs( value );
    },
    setStatus       : function ( _to_set ) {
        this.status = _to_set;
        this.component_input.setStatus( _to_set );
    },
    getValue        : function () {
        return this.component_input.getValue();
    },
    setPlaceholder  : function ( _to_set ) {
        return this.component_input.setPlaceholder( _to_set );
    },
    //********************************************  SAVE     *********************************************************//
    getDataToSave: function () {
        return SHINKEN.TOOLS.STRING.trimExtented( this.getValue() );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputAbstract, PROPERTY.InterfaceCommon );

PROPERTY.StringInputFromData           = function ( property_name, value ) {
    this.__class_name__ = 'PROPERTY.StringInputFromData';
    this.initSpecific( property_name, value );
};
PROPERTY.StringInputFromData.prototype = {
    initSpecific: function ( property_name, value ) {
        this.name = property_name;
        this.init();
        this.component_input = new COMPONENT.InputFromDataV2( value, this.name );
    },
    //********************************************  HTML    **********************************************************//
    computeHtml                         : function () {
        this.computeHtml_container();
        this.computeHtml_common();
    },
    computeHtml_getType                 : function () {
        return PROPERTY.CONST.COMMON.TYPES.STRING_INPUT;
    },
    computeHtml_getCellPropActionContent: function () {
        this.component_input.computeHtml();
        DOM.Service.addElementTo( this.component_input.getDomElement(), this.dom_cell_action );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputFromData, PROPERTY.StringInputAbstract );
SHINKEN.TOOLS.CLASS.addPrototype( PROPERTY.StringInputFromData, PROPERTY.InterfaceCommonFromData );

