//__lib__ lib_common
'use strict';

CONTROLLER.Help = (function ( self ) {
    "use strict";
    self._dom_element_help = null;
    //********************************************  EVENT LISTENER  **************************************************//
    self.toggleHelp        = function ( event ) {
        event.preventDefault();
        event.stopPropagation();
        if ( !self._dom_element_help ) {
            self._dom_element_help = document.getElementById( 'id-shinken-help-pop-up' );
            self._dom_element_help.classList.remove( 'shinken-hidden' );
            return;
        }
        self._dom_element_help.classList.toggle( 'shinken-hidden' );
    };
    self.closeHelp         = function () {
        if ( !self._dom_element_help ) {
            return;
        }
        self._dom_element_help.classList.add( 'shinken-hidden' );
    };
    return self;
})( CONTROLLER.Help || {} );

MANAGER.HelpGenerator = (function ( self ) {
    "use strict";
    self.content                   = [];
    self.size                      = 0;
    //********************************************  INIT  **************************************************//
    self.init                              = function (type_trad) {
        self.type_trad = type_trad;
        self.initContent();
        if ( !self.size ) {
            return;
        }
        self.buildButtonHtml();
        self.buildContentHtml();
        self.initEventListener();
    };
    self.initContent               = function () {
        var _found = document.querySelectorAll( ".shinken-help-container .shinken-help-content" );
        for ( var i = 0, _size_i = _found.length; i < _size_i; i++ ) {
            self.content.push( new OBJECT.Help( _found[ i ] ) );
            DOM.Service.removeElement( _found[ i ] );
        }
        self.size    = self.content.length;
        self.content = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( self.content, [ "order_tab", "name_tab", "order" ] );
    };
    self.initEventListener         = function () {
        document.addEventListener( 'keydown', function ( event ) {
            MANAGER.EventManager.keydown( event );
        } );
    };
    //********************************************  HTML  **************************************************//
    self.buildButtonHtml           = function () {
        var _button_f1       = DOM.Service.createElement( 'div', { class: "shinken-help-button-container", onclick: "CONTROLLER.Help.toggleHelp(event)", 'data-name': "toggle_help" } );
        _button_f1.innerHTML = '<button class="shinken-button"><table><tr><td><span class="key">F1</span></td><td>' + _( 'common.help.label', self.type_trad ) + '</td></tr></table></button>';
        document.body.appendChild( _button_f1 );
    };
    self.buildContentHtml          = function (class_to_add) {
        var _content_to_html  = DOM.Service.createElement( 'div', {
            id     : "id-shinken-help-pop-up",
            class  : "shinken-hidden " + class_to_add,
            onclick: "MANAGER.EventManager.stopPropagation(event)"
        } );
        var _container_html   = DOM.Service.createElement( 'div', { class: "shinken-help-container" } );
        var _container_html_2 = DOM.Service.createElement( 'div', { class: "shinken-help-container-2" } );
        var _container_html_3 = DOM.Service.createElement( 'div', { class: "shinken-help-container-3" },
            "<div class='shinken-text-centred'><div class='shinken-help-title'>" + _( 'common.help.label', self.type_trad ) + "</div></div>" );
        var _current_tab;
        var _current_tab_name = "";
        for ( var i = 0, _size_i = self.size; i < _size_i; i++ ) {
            if ( _current_tab_name !== self.content[ i ].tab ) {
                _current_tab_name = self.content[ i ].tab;
                _current_tab      = WINDOW.ElementService.getWindowTargetHtml( 'div', _current_tab_name, !i );
                _container_html_3.appendChild( _current_tab );
            }
            _current_tab.appendChild( self.content[ i ].getHtml() );
        }
        _content_to_html.appendChild( _container_html );
        _container_html.appendChild( _container_html_2 );
        _container_html_2.appendChild( self.buildWindowsLineHtml() );
        _container_html_2.appendChild( _container_html_3 );
        document.body.appendChild( _content_to_html );
        document.body.appendChild( _content_to_html );
    };
    self.buildWindowsLineHtml      = function () {
        var _to_return = DOM.Service.createElement( 'div', {
            class      : "shinken-help-windows-title-menu shinken-window-group",
            "data-name": "help-group",
            onclick    : "MANAGER.EventManager.clickOnWindowNavigation(event,'help-group')"
        } );
        var _tab_list  = SHINKEN.TOOLS.ARRAY.extractKeys( this.content, [ 'tab', 'name_tab' ], true, true );
        _tab_list      = SHINKEN.TOOLS.ARRAY.removeDuplicateArray( _tab_list );
        _tab_list      = self.concatDuplicationWindowID( _tab_list );
        var _current;
        for ( var i = 0, _size_i = _tab_list.length; i < _size_i; i++ ) {
            _current = _tab_list[ i ];
            _to_return.appendChild( WINDOW.ElementService.getWindowHtml( "div", _current[ 0 ], _current[ 1 ], "help-group", !i ) );
        }
        var _button_close = DOM.Service.createElement( 'div', { class: "shinken-help-close-button shinkon-times-bold", onclick: "CONTROLLER.Help.toggleHelp(event)" } );
        _to_return.appendChild( _button_close );
        return _to_return;
    };
    self.concatDuplicationWindowID = function ( tab_list ) {
        var _to_return = [];
        var _mapping   = {};
        var _current;
        var _index;
        for ( var i = 0, _size_i = tab_list.length; i < _size_i; i++ ) {
            _current = tab_list[ i ];
            if ( _mapping[ _current[ 0 ] ] ) {
                _index                    = _mapping[ _current[ 0 ] ] - 1;
                _to_return[ _index ][ 1 ] = _to_return[ _index ][ 1 ] + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE + _current[ 1 ];
            }
            else {
                _mapping[ _current[ 0 ] ] = _to_return.push( _current );
            }
        }
        return _to_return;
    };
    return self;
})( MANAGER.HelpGenerator || {} );


OBJECT.Help = function ( dom_element ) {
    this.dom_element = dom_element;
    this.tab         = dom_element.dataset.tab;
    this.order       = parseInt( dom_element.dataset.order ) || 1;
    this.order_tab   = parseInt( dom_element.dataset.tabOrder ) || 1;
    this.name_tab    = dom_element.dataset.tabName || "??";
};

OBJECT.Help.prototype = {
    getHtml: function () {
        return this.dom_element;
    }
};