//__lib__ lib_common
//priority 10
SHINKEN.NAVIGATOR = (function ( self ) {
    "use strict";
    
    var navigator = {
        isChrome : false,
        isFireFox: false,
        isIE     : false,
        isHidden : false
    };
    
    
    setInterval( function () {
        setDocumentHidden();
    }, 2000 );
    
    function setDocumentHidden () {
        navigator.isHidden = document.hidden;
    }
    
    self.isNavigator          = function ( type ) {
        return navigator[ type ];
    };
    self.isNavigatorHidden    = function () {
        return navigator.isHidden;
    };
    self.init                 = function ( nb_try ) {
        var _navigator_class = '';
        if ( window.navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            navigator.isFireFox = true;
            _navigator_class    = 'shinken-navigator-is-firefox';
        }
        else if ( window.navigator.userAgent.indexOf( 'Chrome' ) !== -1 ) {
            navigator.isChrome = true;
            _navigator_class   = 'shinken-navigator-is-chrome';
        }
        if ( document.body ) {
            document.body.classList.add( _navigator_class );
        }
        else if ( nb_try ) {
            setTimeout( function () {
                nb_try = nb_try - 1;
                SHINKEN.NAVIGATOR.init( nb_try );
            }, 1000 );
        }
    };
    self.shinken_beforeunload = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_beforeunload();
            default:
                return '';
        }
    };
    self.shinken_unload       = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_unload();
            default:
                return '';
        }
    };
    
    
    return self;
})( SHINKEN.NAVIGATOR || {} );


SHINKEN.NAVIGATOR.init( 50 );
