//priority 10
//__lib__ lib_common
var CLIPBOARD_SERVICE = (function ( self ) {
    "use strict";
    self.dom_textarea     = null;
    self.dom_parent       = null;
    self.dom_button       = null;
    self.dom_text_to_copy = null;
    self.type             = null;
    
    self.TYPE      = {};
    self.TYPE.TEXT = 'text';
    self.TYPE.HTML = 'html';
    
    self.setContent       = function ( dom_event, value, displayResultCallBack ) {
        var _dom_button = DOM.Service.findParentElementWithClass( dom_event, 'shinken-button', 10 );
        setValueTextArea( value );
        self.dom_textarea.select();
        
        var status = false;
        try {
            status = document.execCommand( 'copy' );
            displayResultCallBack ? displayResultCallBack( status, _dom_button ) : displayResult( status, _dom_button );
            setValueTextArea( '' );
        }
        catch ( err ) {
            console.log( 'Unable to copy.' );
        }
    };
    self.buildHtmlButtons = function ( hasCopyButton, hasEditButton, event_name, param ) {
        var table_buttons = DOM.Service.createElement( "table", { class: "shinken-copy-buttons-container" } );
        var line_buttons  = DOM.Service.createElement( "tr", {} );
        if ( hasCopyButton ) {
            var button_copy_cell = DOM.Service.createElement( "td", { class: "shinken-btn-copy-cell" } );
            var button_copy      = DOM.Service.createElement( "td", {
                class             : "shinken-button shinken-btn-copy shinken-btn-copy-text",
                onclick           : 'MANAGER.EventManager.clickOnButton(event)',
                'data-status-copy': '0',
                'data-name'       : event_name ? event_name : '',
                'data-param'      : param ? param : '',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_text_copy' )
            } );
            var icon_button_copy = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinicon-copy" } );
            
            button_copy.appendChild( icon_button_copy );
            button_copy_cell.appendChild( button_copy );
            line_buttons.appendChild( button_copy_cell );
        }
        if ( hasEditButton ) {
            var button_edit_cell = DOM.Service.createElement( "td", { class: "shinken-btn-edit-cell" } );
            var button_edit      = DOM.Service.createElement( "td", {
                class             : "shinken-btn-copy",
                onclick           : 'MANAGER.EventManager.clickOnPaste(event)',
                'data-status-copy': '0',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_edition' )
            } );
            var icon_button_edit = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinken-icons-url shinken-icons-url-write" } );
            
            button_edit.appendChild( icon_button_edit );
            button_edit_cell.appendChild( button_edit );
            line_buttons.appendChild( button_edit_cell );
        }
        table_buttons.appendChild( line_buttons );
        return table_buttons;
    };
    
    self.buildHtmlButtons_V2 = function ( hasCopyButton, hasEditButton, event_name, param ) {
        var table_buttons = DOM.Service.createElement( "table", { class: "shinken-copy-buttons-container" } );
        var line_buttons  = DOM.Service.createElement( "tr", {} );
        if ( hasCopyButton ) {
            var button_copy_cell          = DOM.Service.createElement( "td", { class: "shinken-btn-copy-cell shinken-button-container" } );
            var button_copy               = DOM.Service.createElement( "div", {
                class             : "shinken-button shinken-btn-copy shinken-btn-copy-text",
                onclick           : "MANAGER.EventManager.clickOnButton(event, '" + event_name + "', '" + param + "' )",
                'data-status-copy': '0',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_text_copy' )
            } );
            var icon_button_copy          = DOM.Service.createElement(
                "span", {
                    class: "shinken-copy-default-message shinicon shinicon-copy"
                } );
            button_copy.appendChild( icon_button_copy );
            button_copy_cell.appendChild( button_copy );
            line_buttons.appendChild( button_copy_cell );
        }
        if ( hasEditButton ) {
            var button_edit_cell = DOM.Service.createElement( "td", { class: "shinken-btn-edit-cell" } );
            var button_edit      = DOM.Service.createElement( "td", {
                class             : "shinken-btn-copy",
                onclick           : 'MANAGER.EventManager.clickOnPaste(event)',
                'data-status-copy': '0',
                onmouseenter      : 'SHINKEN_TOOLTIP.showTooltip(this);',
                onmouseleave      : 'SHINKEN_TOOLTIP.hideTooltip();',
                'shi-tip-html'    : _( 'copy_service.tooltip_edition' )
            } );
            var icon_button_edit = DOM.Service.createElement( "span", { class: "shinken-copy-default-message shinken-icons-url shinken-icons-url-write" } );
            
            button_edit.appendChild( icon_button_edit );
            button_edit_cell.appendChild( button_edit );
            line_buttons.appendChild( button_edit_cell );
        }
        table_buttons.appendChild( line_buttons );
        return table_buttons;
    };
    
    self.doPaste = function ( event ) {
        event.preventDefault();
        var clipboardData = event.clipboardData || window.clipboardData;
        var to_return     = window.clipboardData ? clipboardData.getData( 'Text' ) : clipboardData.getData( "text/plain" );
        to_return         = to_return.trim();
        if ( SHINKEN.NAVIGATOR.isNavigator( 'isIE' ) ) {
            pasteHtmlForIE( SHINKEN.TOOLS.STRING.cleanXss( to_return ) );
        }
        else {
            document.execCommand( "insertHTML", false, SHINKEN.TOOLS.STRING.cleanXss( to_return ) );
        }
        return to_return;
    };
    
    init();
    
    //private
    function init () {
        setTimeout( function () {
            createDomTextArea();
        }, 1000 );
    }
    
    function createDomTextArea () {
        self.dom_textarea               = document.createElement( 'textarea' );
        self.dom_textarea.id            = 'id-shinken-copy-clipboard-container';
        self.dom_textarea.style.opacity = '0';
        var _body                       = document.querySelector( 'body' );
        _body.appendChild( self.dom_textarea );
    }
    
    
    function setValueTextArea ( to_set ) {
        self.dom_textarea.value = to_set;
    }
    
    
    function displayResult ( status, dom_button ) {
        var _text     = status ? _( 'copy_service.copySuccess' ) : _( 'copy_service.copyFail' );
        var _state    = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.STATUS.COPY_FAILED;
        var _position = status ? SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_SUCCESS : SHINKEN.OBJECT.NOTIFICATION.CONST.PLACEMENT.COPY_NOTIFICATION_FAILED;
        SHINKEN.TOOLS.NOTIFICATION.addNotification( _text, _state, dom_button, _position, 2000 );
    }
    
    function pasteHtmlForIE ( text_to_paste ) {
        var sel,
            range;
        
        if ( window.getSelection ) {
            sel = window.getSelection();
            if ( sel.getRangeAt && sel.rangeCount ) {
                range = sel.getRangeAt( 0 );
                range.deleteContents();
                
                var _div = DOM.Service.createElement( "div", {}, text_to_paste );
                
                var frag = document.createDocumentFragment(),
                    node,
                    lastNode;
                
                while ( (node = _div.firstChild) ) {
                    lastNode = frag.appendChild( node );
                }
                range.insertNode( frag );
                
                // Preserve the selection
                if ( lastNode ) {
                    range = range.cloneRange();
                    range.setStartAfter( lastNode );
                    range.collapse( true );
                    sel.removeAllRanges();
                    sel.addRange( range );
                }
            }
        }
    }
    
    return self;
    
})( {} );