//__lib__ lib_common
'use strict';

SHINKEN_GRID.Cell           = function ( data ) {
    this.init( data );
};
SHINKEN_GRID.Cell.prototype = {
    init: function ( data ) {
        this.uuid = SHINKEN.TOOLS.STRING.buildUUID();
        this.initInternal();
        this.initPhase();
        this.class = "shinken-grid-cell shinken-draggable";
        this.updateData( data );
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.READY );
    },
    //********************************************  EVENT LISTENER  *********************************************//
    onScroll: function ( event, shinken_grid ) {
        if ( this.isPhase( SHINKEN.OBJECT.CONST.PHASE.READY ) && shinken_grid.isInPhase( [SHINKEN.OBJECT.CONST.PHASE.RUNNING, SHINKEN.OBJECT.CONST.PHASE.EDITING] ) ) {
            this.computeHtml( shinken_grid );
        }
    },
    //********************************************  GETTER SETTER  *****************************************************//
    getUUID       : function () {
        return this.uuid;
    },
    getContentUUID: function () {
        if ( this.content ) {
            return this.content.getUUID();
        }
    },
    //********************************************  JSON  *****************************************************//
    _getValidOwnChildren: function () {
        return new SHINKEN.OBJECT.DefaultConfigurationChildren( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.CONTENT, "SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty"]
        ] );
    },
    _getValidOwnProperty: function () {
        return new SHINKEN_VALIDATION.Parameters( [
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE, undefined, true],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE, undefined, true],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH, SHINKEN_VALIDATION.CONST.OTHERS.DEFINE_STRING_OR_INTEGER_POSITIVE, [SHINKEN_GRID.CONST.SPECIAL_VALUE.ALL, this.getDefaultValueLabel()]],
            [SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT, SHINKEN_VALIDATION.CONST.NUMBER.INTEGER_POSITIVE]
        ] );
    },
    
    //********************************************  OTHERS  *****************************************************//
    isVisible            : function () {
        var _box      = this.getDisplayBox();
        var _dom      = this.getDomScrollingParent();
        var _rect     = DOM.Service.getBoundingClientRect( _dom );
        var _box_cell = { top: _box.top + _rect.top, bottom: _box.top + _rect.top };
        var _box_grid = { top: _rect.top + _dom.scrollTop, bottom: _rect.bottom + _dom.scrollTop };
        return DOM.Service.isVisibleIntoScrollingVerticalParent_Box( _box_cell, _box_grid );
    },
    getDomScrollingParent: function () {
    },
    //********************************************  COMPUTE  *****************************************************//
    computeMapping: function ( mapping ) {
        if ( this.content && this.content.computeMapping ) {
            this.content.computeMapping( mapping );
        }
    },
    computeSizes  : function ( shinken_grid ) {
        var _current_phase = this.getCurrentPhase();
        switch ( _current_phase ) {
            case SHINKEN.OBJECT.CONST.PHASE.READY:
                this.computeHtml( shinken_grid );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.RUNNING:
                this.updateSize( shinken_grid );
                break;
        }
    },
    updateSize    : function ( shinken_grid ) {
        if ( shinken_grid ) {
            this.tile_pixel_size = shinken_grid.tile_pixel_size;
            this.font_size       = shinken_grid.font_size;
        }
        
        DOM.Service.setStyles( this.dom_element, this.getStyle() );
        this.dom_element.className = this.getClass();
        this._updateSize();
        if ( this.content ) {
            this.content.updateSize();
        }
        this.dom_element.classList.remove( "shinken-no-opacity" );
    },
    _updateSize   : function () {
    },
    computeContentWithChange: function () {
        var _to_return = 0;
        if ( this.content ) {
            _to_return = this.content.computeContentWithChange();
        }
        return _to_return;
    },
    //********************************************  SAVE  *****************************************************//
    
    //********************************************  FORM  *****************************************************//
    
    //********************************************  HTML   **************************************************//
    
    computeHtml         : function ( shinken_grid ) {
        if ( this.dom_element ) {
            return;
        }
        if ( !__has_edit_mode__ && this.hasIssues() ) {
            return;
        }
        
        this.tile_pixel_size = shinken_grid.tile_pixel_size;
        this.font_size       = shinken_grid.font_size;
        
        this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ]                     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X );
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ]     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN );
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ]     = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX );
        this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] = shinken_grid.getValue( SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT );
        
        if ( !this.confirmDoComputeHtml( shinken_grid ) ) {
            return;
        }
        if ( !this.isVisible( shinken_grid ) ) {
            return;
        }
        this.dom_element = DOM.Service.createElement( "div", this.getAttribute() );
        
        this.content_container        = DOM.Service.createElement( "div", { class: 'shinken-grid-cell-container shinken-height-100' } );
        var _widget_container_wrapped = this.wrapHtmlContainer( this.content_container );
        DOM.Service.addElementTo( _widget_container_wrapped, this.dom_element );
        DOM.Service.addElementTo( this.dom_element, shinken_grid.dom_element );
        if ( this.content ) {
            this.content.setDomElementParent( this.content_container );
            this.content.computeHtml( this.tile_pixel_size * this.getComputedWidth(), this.tile_pixel_size * this.height );
        }
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    wrapHtmlContainer   : function ( container ) {
        return container;
    },
    confirmDoComputeHtml: function () {
        return true;
    },
    getAttribute        : function () {
        var _to_return = {
            class: this.getClass(),
            style: DOM.Service.styleToHtml( this.getStyle() )
        };
        this.getUserInteraction( _to_return );
        return _to_return;
    },
    getUserInteraction  : function ( attributes ) {
        attributes[ "onclick" ] = "MANAGER.EventManager.clickOnButton(event, 'focus-on-shinken-cell-grid-from-cell', '" + this.getUUID() + "')";
    },
    getClass            : function () {
        return this.class + " shinken-no-opacity";
    },
    getComputedWidth    : function () {
        return this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH ) === WEATHER.CONST.WIDTH_ALL ? this[ SHINKEN_GRID.CONST.PARAM.GRID.TILES_MAX_X ] : this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.WIDTH );
    },
    getStyle            : function () {
        var _to_return = this.getDisplayBox();
        var _padding   = parseInt( DOM.BodyService.getWidth() * this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_PERCENT ] / 100 );
        if ( !_to_return[ DOM.CONST.STYLE.WIDTH ] || !_to_return[ DOM.CONST.STYLE.HEIGHT ] ) {
            _padding = 0;
        }
        else {
            if ( this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] !== SHINKEN_GRID.CONST.SPECIAL_VALUE.SEPARATION_GRID_ELEMENT_MAX_UNLIMITED ) {
                _padding = Math.min( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MAX ] );
            }
            _padding = Math.max( _padding, this[ SHINKEN_GRID.CONST.PARAM.GRID.SEPARATION_GRID_ELEMENT_MIN ] );
            
        }
        _to_return[ DOM.CONST.STYLE.PADDING ] = _padding / 2;
        return _to_return;
    },
    getDisplayBox       : function () {
        var _to_return                       = {};
        _to_return[ DOM.CONST.STYLE.WIDTH ]  = this.tile_pixel_size * this.getComputedWidth();
        _to_return[ DOM.CONST.STYLE.HEIGHT ] = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.HEIGHT );
        _to_return[ DOM.CONST.STYLE.TOP ]    = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_Y );
        _to_return[ DOM.CONST.STYLE.LEFT ]   = this.tile_pixel_size * this.getValue( SHINKEN_GRID.CONST.PARAM.GRID_CELL.POSITION_X );
        return _to_return;
    },
    
    //********************************************  HTML   **************************************************//
    callbackForPhase: function () {
        if ( this.isPreviousPhase( SHINKEN.OBJECT.CONST.PHASE.READY ) ) {
            this.updateSize();
        }
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.DefaultConfigurationWithOwnProperty );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_GRID.Cell, SHINKEN.OBJECT.InterfaceHtml );

