//__lib__ lib_common
'use strict';
SHINKEN.OBJECT.ElementWindowGroupSaveObject           = function () {
    this.saving_progress_bar      = null;
    this.dom_saving_bar_container = null;
    this._controller              = null;
    this.init();
};
SHINKEN.OBJECT.ElementWindowGroupSaveObject.prototype = {
    init: function ( controller ) {
        this._controller = controller;
        this.initCounters();
        this.initPhase();
        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
    },
    //********************************************  EVENT LISTENER  **************************************************//
    clickOnButton   : function ( event, event_name, param ) {
        switch ( event_name ) {
            case "click-on-apply-button":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_SAVING );
                break;
            case "click-on-cancel-button":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL );
                break;
            case "click-on-validate-confirmation-popup":
                var _current_phase = this.getCurrentPhase();
                switch ( _current_phase ) {
                    case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_SAVING:
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.SAVING );
                        break;
                    case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL:
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.CANCEL );
                        break;
                    case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CLOSE:
                        SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "ask-for-pop-up-close-accepted" );
                        this.setPhase( SHINKEN.OBJECT.CONST.PHASE.CLOSE );
                        break;
                }
                MANAGER.__instance_confirmation_popup.hide();
                break;
            case "click-on-cancel-confirmation-popup":
                this.setPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING );
                MANAGER.__instance_confirmation_popup.hide();
                SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "ask-for-pop-up-close-refused" );
                break;
        }
    },
    doActionAfter   : function ( event_name ) {
        switch ( event_name ) {
            case "ask-for-pop-up-close-event":
                if ( !this.getCounterUserSet().hasCounter() ) {
                    SHINKEN.COMMUNICATION_WITH_IFRAME_PARENT.doActionAfter( "ask-for-pop-up-close-accepted" );
                }
                else {
                    this.setPhase( SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CLOSE );
                }
                break;
        }
    },
    callbackForPhase: function () {
        var _current = this.getCurrentPhase();
        switch ( _current ) {
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_SAVING:
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CANCEL:
            case SHINKEN.OBJECT.CONST.PHASE.ASK_FOR_CLOSE:
                this.doConfirmationPopup();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.SAVING:
                this.saving_progress_bar.doProgress( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.PREPARATION_CALL );
                break;
            case SHINKEN.OBJECT.CONST.PHASE.CANCEL:
                this.getController().cancelUserModification();
                break;
            case SHINKEN.OBJECT.CONST.PHASE.CLOSE:
                break;
            default:
                break;
        }
    },
    //********************************************  GETTER SETTER  ************************************************//
    getController: function () {
        return this._controller;
    },
    //********************************************  PROGRESS BAR  ************************************************//
    _doActionWhenProgressStart: function ( current_step, param ) {
        switch ( current_step ) {
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.PREPARATION_CALL:
                this.saving_progress_bar.setTitleStep( current_step, _( "progress_bar.saving_in_progress", [DICTIONARY_COMMON_UI] ) );
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.CALL_IN_PROGRESS:
                this._askForSave();
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_ANALYSE:
                this.doTreatment( param );
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.END:
                var _current_step = this.saving_progress_bar.getStep( current_step );
                var _message      = _current_step.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_OK_WITH_WARNING ) ?
                                    _( 'progress_bar.saving_succeed_with_warning', [DICTIONARY_COMMON_UI] ) :
                                    _( "progress_bar.saving_succeed", [DICTIONARY_COMMON_UI] );
                this.saving_progress_bar.setTitleStep( current_step, _message );
                break;
            default:
                break;
        }
    },
    _doActionWhenProgressEnd  : function ( current_step, param ) {
        //if ( this.saving_progress_bar.isPhase( SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK ) ) {
        //    this.saving_progress_bar.setTitleStep( current_step, _( "progress_bar.saving_failed", [DICTIONARY_COMMON_UI] ) );
        //}
        switch ( current_step ) {
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.PREPARATION_CALL:
                this.saving_progress_bar.doProgress( SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.CALL_IN_PROGRESS );
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.BACKEND_RETURN_TREATMENT:
                switch ( this.saving_progress_bar.getCurrentPhase() ) {
                    case SHINKEN.OBJECT.CONST.PHASE.RUNNING_NOK:
                        break;
                }
                break;
            case SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.END:
                this._doActionWhenSaveEnd();
                break;
        }
    },
    _doActionWhenSaveEnd      : function () {
    },
    doTreatment               : function ( param ) {
    },
    _askForSave               : function () {
    },
    //********************************************  HTML  **************************************************//
    computeHtml                      : function () {
        this.dom_element              = DOM.Service.createElement( "table", { "class": "shinken-window-group-save-table-action-button" } );
        var _tr                       = DOM.Service.createElement( "tr", {} );
        var _td_saving_bar            = DOM.Service.createElement( "td", { "class": "shinken-window-group-save-progress-bar-cell" } );
        var _td_apply                 = DOM.Service.createElement( "td", {} );
        var _td_cancel                = DOM.Service.createElement( "td", {} );
        this.dom_saving_bar_container = DOM.Service.createElement( "div", { "class": "shinken-window-group-save-container-saving-bar" } );
        var _apply_button_container   = DOM.Service.createElement( "div", { "class": "shinken-window-group-save-container-action-button" } );
        var _cancel_button_container  = DOM.Service.createElement( "div", { "class": "shinken-window-group-save-container-action-button" } );
        var _apply_button             = DOM.Service.createElement( "div", {
            "class"  : "shinken-window-group-save-action-button shinken-window-group-save-apply-button",
            "onclick": "MANAGER.EventManager.clickOnButton(event, 'click-on-apply-button')"
        }, _( 'window_group_save.action_button.apply', [DICTIONARY_COMMON_UI] ) );
        var _onclick_attribute_cancel = 'MANAGER.EventManager.clickOnButton(event, "click-on-cancel-button")';
        var _cancel_button            = DOM.Service.createElement( "div", {
            "class"  : "shinken-window-group-save-action-button shinken-window-group-save-cancel-button",
            "onclick": _onclick_attribute_cancel
        }, _( 'window_group_save.action_button.cancel', [DICTIONARY_COMMON_UI] ) );
        
        DOM.Service.addElementTo( this.dom_saving_bar_container, _td_saving_bar );
        
        DOM.Service.addElementTo( _apply_button, _apply_button_container );
        DOM.Service.addElementTo( _apply_button_container, _td_apply );
        
        DOM.Service.addElementTo( _cancel_button, _cancel_button_container );
        DOM.Service.addElementTo( _cancel_button_container, _td_cancel );
        
        DOM.Service.addElementTo( _td_saving_bar, _tr );
        DOM.Service.addElementTo( _td_apply, _tr );
        DOM.Service.addElementTo( _td_cancel, _tr );
        DOM.Service.addElementTo( _tr, this.dom_element );
        this.getCounterUserSet().addTargetsDomElement( this.dom_element );
        this.saving_progress_bar = new SHINKEN.OBJECT.Progressbar( this, SHINKEN.OBJECT.PROGRESS_BAR_CONST.SAVING_WITH_TREATMENT_AFTER_CALL.END, 500, this.dom_saving_bar_container );
    },
    buildHtmlTitleConfirmationPopup  : function () {
        return "";
    },
    buildHtmlContentConfirmationPopup: function () {
        return DOM.Service.createElement( "div", {} );
    },
    doConfirmationPopup              : function () {
        MANAGER.__instance_confirmation_popup.reset();
        MANAGER.__instance_confirmation_popup.setTitle( this.buildHtmlTitleConfirmationPopup() );
        MANAGER.__instance_confirmation_popup.setContent( this.buildHtmlContentConfirmationPopup() );
        MANAGER.__instance_confirmation_popup.setController( this._controller.controller_name );
        MANAGER.__instance_confirmation_popup.show();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ElementWindowGroupSaveObject, SHINKEN.OBJECT.PhaseInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ElementWindowGroupSaveObject, SHINKEN.OBJECT.ProgressbarInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.ElementWindowGroupSaveObject, SHINKEN.OBJECT.CounterInterface );
