//__lib__ lib_common
'use strict';

WINDOW.ElementGroup           = function ( name ) {
    this.init( name );
};
WINDOW.ElementGroup.prototype = {
    init       : function ( name ) {
        this.initContents();
        this.initCounters();
        this.active_window = null;
        this.name          = SHINKEN.TOOLS.STRING.escapeBackslash( name );
    },
    initWindows: function () {
    },
    //********************************************  GETTER SETTER  **************************************************//
    setActiveWindow                   : function ( window_name ) {
        var _current;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            _current.setActive( _current.getName() === window_name );
            if ( _current.isActive() ) {
                this.active_window = _current;
                if ( _current.hasProperties() ) {
                    MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.UPDATE_VIEW_ON_WINDOW_PROPERTIES, window_name );
                }
            }
        }
        this._doExtraActionAfterSetActiveWindow();
    },
    getActiveWindow                   : function () {
        if ( !this.active_window ) {
            for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
                if ( this.contents[ i ].isActive() ) {
                    this.active_window = this.contents[ i ];
                    break;
                }
            }
        }
        return this.active_window;
    },
    clickOnWindow                     : function ( window_name ) {
        var _active_window = this.getActiveWindow();
        if ( _active_window && _active_window.getName() === window_name ) {
            return false;
        }
        var _current_window = this.getWindowByName( window_name );
        if ( _current_window && !_current_window.isClickable() ) {
            return false;
            }
        this.setActiveWindow( window_name );
        return true;
    },
    _doExtraActionAfterSetActiveWindow: function () {
    },
    getWindowByName                   : function ( window_name ) {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            if ( this.contents[ i ].getName() === window_name ) {
                return this.contents[ i ];
            }
        }
        return null;
    },
    
    setParentCounter                  : function ( parent ) {
        
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].setParentCounter( parent );
        }
    },
    setContentDomElementTarget        : function ( window_name, to_set ) {
        var _to_return = this.getWindowByName( window_name );
        this.getWindowByName( window_name ).setContentDomElementTarget( to_set );
        return _to_return;
    },
    hasProblems                       : function ( window_name ) {
        return this.getWindowByName( window_name ).hasProblems();
    },
    setVisibilityWindowState          : function ( to_set, window_name ) {
        var _window = this.getWindowByName( window_name );
        if ( _window ) {
            _window.setVisibilityState( to_set );
            _window.doActionAfter( "set_visibility_state" );
        }
    },
    //********************************************  OTHERS  **************************************************//
    pulsateElementIfNotActive: function ( window_name ) {
        if ( this.getActiveWindow().getName() !== window_name ) {
            DOM.Service.askAddClass( this.getElementByName( window_name ).dom_element, 'shinken-pulsate', 2000 );
        }
    },
    cancelUserModification   : function () {
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            this.contents[ i ].cancelUserModification();
        }
    },
    //********************************************  SAVE  **************************************************//
    getDataToSave: function () {
        return this.getActiveWindow().getDataToSave();
    },
    getUrlToSave           : function () {
        return this.getActiveWindow().getUrlToSave();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroup, SHINKEN.OBJECT.ShinkenObjectContainerHtml );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroup, SHINKEN.OBJECT.CounterInterface );

WINDOW.ElementGroupWithCommaAbstract           = function ( name ) {
};
WINDOW.ElementGroupWithCommaAbstract.prototype = {
    //********************************************  GETTER SETTER  **************************************************//
    _doExtraActionAfterSetActiveWindow: function () {
        if ( !this.getDomElement() ){
            return;
        }
        var _current;
        var _is_first = false;
        var _is_last  = false;
        for ( var i = 0, _size_i = this.contents.length; i < _size_i; i++ ) {
            _current = this.contents[ i ];
            if ( !_is_first && _current.isVisible() ) {
                _is_first = true;
                DOM.Service.addOrRemoveClasses( _current.getDomElement(), true, "shinken-is-first-comma" );
            }
            else {
                DOM.Service.addOrRemoveClasses( _current.getDomElement(), false, "shinken-is-first-comma" );
            }
        }
        for ( i = this.contents.length; i > 0; i-- ) {
            _current = this.contents[ i - 1 ];
            if ( !_is_last && _current.isVisible() ) {
                _is_last = true;
                DOM.Service.addOrRemoveClasses( _current.getDomElement(), true, "shinken-is-last-comma" );
            }
            else {
                DOM.Service.addOrRemoveClasses( _current.getDomElement(), false, "shinken-is-last-comma" );
            }
        }
    }
};