'use strict';
"use strict";
var PROPERTY = PROPERTY || {};
PROPERTY.CONST = PROPERTY.CONST || {
    NAME                           : {
        ACTIVE_CHECKS_ENABLED                                      : "active_checks_enabled",
        ACL_MAKE_DOWNTIME                                          : "acl_make_downtime",
        ACL_MAKE_ACKNOWLEDGE                                       : "acl_make_acknowledge",
        ACL_FORCE_RESULT_CHECK                                     : "acl_force_result_check",
        ACL_FORCE_RETRY_CHECK                                      : "acl_force_retry_check",
        ACL_IN_TAB_HISTORY                                         : "acl_in_tab_history",
        ACL_SHARE_EVERYBODY                                        : "acl_share_everybody",
        ACL_SHOW_HISTORY_RANGE                                     : "acl_show_history_range",
        ACL_SHOW_SLA_RANGE                                         : "acl_show_sla_range",
        ACL_TRY_CHECK_ON_SYNCHRONIZER                              : "acl_try_check_on_synchronizer",
        ACL_TRY_CHECK_ON_POLLER                                    : "acl_try_check_on_poller",
        ACL_CHANGE_ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW    : {
            NAME : "acl_change_element_visibility_on_not_authenticated_view",
            VALUE: {
                IS_ADMIN_SHINKEN: "is_admin_shinken"
            }
        },
        ADDRESS                                                    : "address",
        ADVANCED_TIME_PERIODS                                      : "advanced_time_periods",
        AUTHENTICATION_COOKIE_VALIDITY_DURATION                    : 'authentication_cookie_validity_duration', BP_RULE: "bp_rule",
        BUSINESS_IMPACT                                            : "business_impact",
        BUSINESS_IMPACT_MODULATIONS                                : "business_impact_modulations",
        BUSINESS_IMPACT_MODULATION_NAME                            : "business_impact_modulation_name",
        CAN_SUBMIT_COMMANDS                                        : "can_submit_commands",
        CHECK_COMMAND                                              : "check_command",
        CHECK_COMMAND_ARGS                                         : "check_command_args",
        CHECK_INTERVAL                                             : "check_interval",
        CHECK_FRESHNESS                                            : 'check_freshness',
        CHECK_PERIOD                                               : "check_period",
        CHECK_RUNNING_TIMEOUT                                      : "check_running_timeout",
        COMMAND_NAME                                               : "command_name",
        COMMAND_LINE                                               : "command_line",
        CONTACTS                                                   : "contacts",
        CONTACT_NAME                                               : "contact_name",
        CONTACT_GROUPS                                             : "contact_groups",
        CONTACTGROUP_NAME                                          : "contactgroup_name",
        CONTACTGROUPS                                              : "contactgroups",
        DEFAULT_VALUE                                              : "default_value",
        DEFINITION_ORDER                                           : "definition_order",
        DISPLAY_NAME                                               : "display_name",
        DEFAULT_SUBMIT_TO_STAGING                                  : "default_submit_to_staging",
        DOWNTIME_ON_DELETE_ELEMENT_API_PORT                        : "downtime_on_delete_element_api_port",
        DOWNTIME_ON_DELETE_ELEMENT_AUTHOR                          : "downtime_on_delete_element_author",
        DOWNTIME_ON_DELETE_ELEMENT_COMMENT                         : "downtime_on_delete_element_comment",
        DOWNTIME_ON_DELETE_ELEMENT_DURATION                        : "downtime_on_delete_element_duration",
        DUPLICATE_FOREACH_NAME                                     : "duplicate_foreach",
        ENABLED                                                    : "enabled",
        ESCALATIONS                                                : "escalations",
        ESCALATION_NAME                                            : "escalation_name",
        ESCALATION_OPTIONS                                         : "escalation_options",
        EDITION_CONTACTS                                           : "edition_contacts",
        EDITION_CONTACT_GROUPS                                     : "edition_contact_groups",
        EVENT_HANDLER                                              : "event_handler",
        ELEMENT_VISIBILITY_ON_NOT_AUTHENTICATED_VIEW               : "element_visibility_on_not_authenticated_view",
        EXCLUDE                                                    : "exclude",
        FIRST_NOTIFICATION_DELAY                                   : "first_notification_delay",
        FIRST_NOTIFICATION_TIME                                    : "first_notification_time",
        FLAP_DETECTION_OPTIONS                                     : "flap_detection_options",
        FRESHNESS_THRESHOLD                                        : "freshness_threshold",
        HOST_NAME                                                  : "host_name",
        HOST_NOTIFICATION_OPTIONS                                  : "host_notification_options",
        HOST_NOTIFICATION_PERIOD                                   : "host_notification_period",
        HOSTGROUPS                                                 : "hostgroups",
        HOSTGROUP_NAME                                             : "hostgroup_name",
        IP_RANGE                                                   : "iprange",
        IMPORT_INTERVAL                                            : "import_interval",
        IS_ADMIN                                                   : "is_admin",
        IS_CLUSTER                                                 : "is_cluster",
        LOW_FLAP_THRESHOLD                                         : "low_flap_threshold",
        LAST_NOTIFICATION_TIME                                     : "last_notification_time",
        HIGH_FLAP_THRESHOLD                                        : "high_flap_threshold",
        SLA_WARNING_THRESHOLD                                      : "sla_warning_threshold",
        SLA_CRITICAL_THRESHOLD                                     : "sla_critical_threshold",
        MACRO_MODULATIONS                                          : "macromodulations",
        MACROMODULATION_NAME                                       : "macromodulation_name",
        MAINTENANCE_PERIOD                                         : "maintenance_period",
        MAX_CHECK_ATTEMPTS                                         : "max_check_attempts",
        NAME                                                       : "name",
        VISUALISATION_NAME                                         : "visualisation_name",
        NOTE_URL                                                   : "notes_url",
        NOTE_MULTI_URL                                             : "notes_multi_url",
        NOTIFICATIONS_ENABLED                                      : "notifications_enabled",
        NOTIFICATION_PERIOD                                        : "notification_period",
        NOTIFICATIONWAY_NAME                                       : "notificationway_name",
        NOTIFICATIONWAYS                                           : "notificationways",
        PACK                                                       : "pack",
        PASSWORD                                                   : 'password',
        PASSIVE_CHECKS_ENABLED                                     : 'passive_checks_enabled',
        PERIOD_ADVANCED_NAME                                       : "period_advanced_type",
        PERIOD_DAY_NAME                                            : "period_day_type",
        POLLER_TAG                                                 : "poller_tag",
        PROCESS_PERF_DATA                                          : 'process_perf_data',
        PREFIX                                                     : "prefix",
        REACTIONNER_TAG                                            : "reactionner_tag",
        RESULTMODULATION_NAME                                      : "resultmodulation_name",
        RETRY_INTERVAL                                             : "retry_interval",
        NOTIFICATION_OPTIONS                                       : "notification_options",
        NOTIFICATION_CONTACTS                                      : "notification_contacts",
        NOTIFICATION_CONTACT_GROUPS                                : "notification_contact_groups",
        NOTIFICATION_INTERVAL                                      : "notification_interval",
        OUTPUT_RULES                                               : "output_rules",
        ORDER                                                      : "order",
        PARENTS                                                    : "parents",
        PORT_RANGE                                                 : "port_range",
        PUT_IN                                                     : "put_in",
        PUT_IN_USER                                                : "put_in_user",
        REALM                                                      : "realm",
        RESULT_MODULATIONS                                         : "resultmodulations",
        SERVICE_NOTIFICATION_OPTIONS                               : "service_notification_options",
        SERVICE_DESCRIPTION                                        : "service_description",
        SERVICE_EXCLUDES                                           : "service_excludes",
        SHELL_EXECUTION                                            : "shell_execution",
        SYNC_NAME                                                  : "sync_name",
        TIMEPERIOD_NAME                                            : "timeperiod_name",
        TEMPLATE_MEMBERS                                           : "template_members",
        THRESHOLDS_DISPLAY                                         : "thresholds_display",
        USER_RIGHTS_PROPERTY_PERMISSION_THRESHOLDS_DISPLAY_CAN_EDIT: "user__rights__property_permission__thresholds_display__can_edit",
        TIMEPERIODS                                                : "timeperiods",
        TIMEOUT                                                    : "timeout",
        USE                                                        : "use",
        VIEW_CONTACTS                                              : "view_contacts",
        VIEW_CONTACT_GROUPS                                        : "view_contact_groups",
        WARNING_THRESHOLD_CPU_USAGE                                : "warning_threshold_cpu_usage",
        TIMEPERIOD_DAYS                                            : {
            MONDAY   : "monday",
            TUESDAY  : "tuesday",
            WEDNESDAY: "wednesday",
            THURSDAY : "thursday",
            FRIDAY   : "friday",
            SATURDAY : "saturday",
            SUNDAY   : "sunday"
        },
        SYNCKEY_PREFIX                                             : "properties_used_as_synckey_for_"
    },
    TYPES                          : {
        BOOLEAN                   : "boolean",
        DATA                      : "data",
        MULTI_SELECT              : "select-multi",
        MULTI_SELECT_BASIC        : "select-multi-basic",
        RANGE                     : "range",
        RANGE_BUSINESS_IMPACT     : "range_business_impact",
        RANGE_WITH_INPUT          : "range_with_input",
        SINGLE_SELECT             : "select-single",
        SINGLE_SELECT_WITH_INPUT  : "select-single-with-input",
        STRING_INPUT              : "input_string",
        STRING_INPUT_WITH_RENDER  : "string_input_with_render",
        STRING_INPUT_WITH_DROPDOWN: "input-string-with-dropdown",
        CHECKBOX_SINGLE           : "checkbox-single",
        CHECKBOX_MULTI            : "checkbox-multi",
        RADIO_LIST                : "radio-list",
        RADIO_LIST_CUMULATIVE     : "radio-list-cumulative",
        MULTI_LINE_OBJECT         : "multi-line-object",
        PROPERTY_INFORMATION      : "property-information"
    },
    CLASS                          : {
        SKINKEN_LINE: "shinken-element-property-line"
    },
    DEFAULT_BUTTON_LABEL           : "default_button",
    BUTTON_LABEL                   : {
        DEFAULT          : "default_button",
        NULL             : "null_button",
        NO_OVERRIDE      : "no_override_button",
        USER_SET         : "user_set_button",
        COPY_TO_CLIPBOARD: "copy_to_clipboard_button",
        SET_DOM_EDITABLE : "set_dom_editable",
        INHERITANCE      : "inheritance_button",
        ADD              : "add_button",
        TARGET_URL       : "target_url_button",
        REMOVE           : "remove_button"
    },
    STATE_PROPERTY                 : {
        INHERITANCE_AND_USER          : "inheritance-and-user-and-plus",
        INHERITANCE                   : "inheritance-only",
        USER_SET                      : "user-set",
        USER_SET_NONE                 : "user-set-none",
        USER_FORCED_DEFAULT           : "user-default-forced",
        USER_SET_MASS_CHANGE_PLUS_ONLY: "user-set-mass-change-plus-only",
        OVERRIDE                      : "override-only",
        OVERRIDE_AND_PLUS             : "override-and-plus",
        OVERRIDE_FORCED_DEFAULT       : "override-default-forced"
    },
    STATE_PROBLEM_PROPERTY         : {
        NONE       : "none",
        HAS_ERROR  : "has_error",
        HAS_WARNING: "has_warning"
    },
    STATE_VALUE_PLUS               : {
        ON : "+",
        OFF: ""
    },
    STATE_IS_NULL_VALUE            : {
        TRUE : "1",
        FALSE: "0"
    },
    ACTIVE                         : {
        TRUE : "1",
        FALSE: "0"
    },
    MAX_SELECTABLE_ITEMS           : {
        RESULT_MODULATIONS: "4"
    },
    CUSTOM_SELECT                  : {
        PLUS_AND_INHERITANCE       : "__PLUS_AND_INHERITANCE__",
        PLUS_AND_OVERRIDE          : "__PLUS_AND_OVERRIDE__",
        NONE                       : "null",
        INHERITANCE                : "__INHERITANCE__",
        DEFAULT                    : "__DEFAULT_NO_TEMPLATE__",
        DEFAULT_FORCED             : "__DEFAULT_NO_TEMPLATE_FORCED__",
        DEFAULT_OR_INHERITANCE     : "__DEFAULT_OR_INHERITANCE__",
        NO_OVERRIDE                : "__NO_OVERRIDE__",
        ENTER_VALUE_FOR_MASS_CHANGE: "__ENTER_VALUE_FOR_MASS_CHANGE__",
        CONSISTENCY_VALUE          : "__CONSISTENCY_VALUE__"
    },
    DEFAULT_TO_LINK                : {
        "has_plus": false,
        "links"   : [{ "name": "__DEFAULT_NO_TEMPLATE__", "exists": false }]
    },
    NONE_TO_LINK                   : {
        "has_plus": false,
        "links"   : [{ "name": "null", "exists": false }]
    },
    DRAG_N_DROP                    : {
        TYPE: {
            SELECTED_ITEM: "selected-item"
        }
    },
    BOOLEAN                        : {
        STATE_INHERITANCE: {
            INHERITANCE: true,
            DEFAULT    : false
        }
    },
    DATA                           : {
        IDENTIFIER_DATA_LOCAL: "_",
        PROTECTED_PLACEHOLDER: "********",
        GROUP                : {
            LOCALE   : "local",
            INHERITED: "templates",
            DFE      : "foreach-dfe"
        },
        STATUS               : {
            NONE  : "",
            NEW   : "shinken-data-status-new",
            HIDDEN: "shinken-data-hidden"
        }
    },
    TIMEPERIOD                     : {
        SEPARATOR   : {
            RANGES  : ",",
            HOURS   : "-",
            HOUR_MIN: ":"
        },
        FORMAT_LABEL: {
            FULL : "full",
            RANGE: "range",
            HOUR : "hour"
        },
        NO_MONTH    : "None"
    },
    ACL_MULTI                      : {
        NAME: {
            READ    : "read",
            CREATE  : "create",
            ORGANIZE: "organize",
            MODIFY  : "modify",
            DELETE  : "delete",
            ALL     : "all"
        }
    },
    ACL_TYPE                       : {
        HISTORY_SLA: "history_sla",
        HISTORY    : "history",
        SLA        : "sla"
    },
    OVERRIDE                       : {
        SEPARATOR: {
            AFTER_NAME    : ", ",
            AFTER_PROPERTY: " ",
            BETWEEN       : "-=#=-"
        }
    },
    NOTES_URL                      : {
        SEPARATOR: {
            ENTRY    : "~#~",
            KEY_VALUE: "~="
        }
    },
    CHECK_COMMAND                  : {
        SEPARATOR: "!"
    },
    PROTECTED_STATUS               : {
        NONE              : 0,
        PROTECTED         : 1,
        PROTECTED_MODIFIED: 2
    },
    SELECTOR                       : {
        MAIN: "main-selector"
    },
    MASS_CHANGE                    : {
        ACTION      : {
            NONE                               : "NONE",
            ADD                                : "ADD",
            ADD_SYNCHRO                        : "ADD_SYNCHRO",
            ADD_CONSISTENCY                    : "ADD_CONSISTENCY",
            MOVE                               : "MOVE",
            EMPTY                              : "EMPTY",
            EMPTY_DATA                         : "EMPTY_DATA",
            EMPTY_DATA_OVERRIDE                : "EMPTY_DATA_OVERRIDE",
            FORCE_TO_DEFAULT                   : "FORCE_TO_DEFAULT",
            REPLACE                            : "REPLACE",
            REMOVE                             : "REMOVE",
            REMOVE_SYNCHRO                     : "REMOVE_SYNCHRO",
            REMOVE_ALL_EXCEPT                  : "REMOVE_ALL_EXCEPT",
            SET                                : "SET",
            SET_SYNCHRO                        : "SET_SYNCHRO",
            SET_OR_CREATE                      : "SET_OR_CREATE",
            SET_IF_DATA_EXISTS_ON_ITEM         : "SET_IF_DATA_EXISTS_ON_ITEM",
            SET_IF_DATA_EXISTS_ON_ITEM_OVERRIDE: "SET_IF_DATA_EXISTS_ON_ITEM_OVERRIDE",
            SET_IF_DATA_IS_SET_ON_ITEM         : "SET_IF_DATA_IS_SET_ON_ITEM",
            SET_IF_DATA_IS_SET_ON_ITEM_OVERRIDE: "SET_IF_DATA_IS_SET_ON_ITEM_OVERRIDE",
            SET_IF_EXIST                       : "SET_IF_EXIST"
        },
        ACTION_EXTRA: {
            NONE  : "NONE",
            LAST  : "LAST",
            FIRST : "FIRST",
            BEFORE: "BEFORE",
            AFTER : "AFTER"
        },
        PLUS_ACTION : {
            NONE: "NONE",
            OFF : "OFF",
            ON  : "ON"
        },
        SELECTOR    : {
            ACTION        : "mass_change_action",
            ACTION_EXTRA  : "mass_change_action_extra",
            ELEMENT_EXTRA : "mass_change_element_extra",
            ELEMENT_SINGLE: "mass_change_element_single",
            ACTION_PLUS   : "mass_change_plus_action"
        }
    },
    HIDDEN                         : "hidden",
    PROPERTY_INFORMATION_TAG       : "-information",
    NAME_IN_SOURCE                 : {
        COMPUTE_NEW_ELEMENT                   : "compute_new_element",
        COMPUTE_ELEMENT_DIFFERENCE            : "compute_element_difference",
        COMPUTE_DELETED_ELEMENT_NOT_IN_SOURCE : "compute_deleted_element_not_in_source",
        DOWNTIME_ON_DELETE_ELEMENT_ACTIVATED  : "downtime_on_delete_element_activated",
        DOWNTIME_ON_DELETE_ELEMENT_API_USE_SSL: "downtime_on_delete_element_api_use_ssl",
        MERGE_MODE                            : "merge_mode",
        PUT_IN                                : "put_in",
        VMWARE_SERVER_USE_SSL                 : "vmware_server_use_ssl"
    },
    MAPPING_PROPERTY_TO_MACRO_HOST : {
        "host_name"               : "$HOSTNAME$",
        "address"                 : "$HOSTADDRESS$",
        "visualisation_name"      : "$HOSTVISUALISATIONNAME$",
        "display_name"            : "$HOSTDISPLAYNAME$",
        "max_check_attempts"      : "$MAXHOSTATTEMPTS$",
        "hostgroups"              : "$HOSTGROUPNAME$",
        "check_command"           : "$HOSTCHECKCOMMAND$",
        "first_notification_delay": "$HOSTFIRSTNOTIFICATIONDELAY$",
        "notes_url"               : "$HOSTNOTESURL$",
        "notes_multi_url"         : "$HOSTNOTESMULTIURL$",
        "realm"                   : "$HOSTREALM$",
        "business_impact"         : "$HOSTBUSINESSIMPACT$"
    },
    MAPPING_PROPERTY_TO_MACRO_CHECK: {
        "service_description"     : "$SERVICEDESC$",
        "max_check_attempts"      : "$MAXSERVICEATTEMPTS$",
        "is_volatile"             : "$SERVICEISVOLATILE$",
        "hostgroup_name"          : "$SERVICEGROUPNAME$",
        "check_command"           : "$SERVICECHECKCOMMAND$",
        "notes_url"               : "$SERVICENOTESURL$",
        "notes_multi_url"         : "$SERVICENOTESMULTIURL$",
        "business_impact"         : "$SERVICEBUSINESSIMPACT$",
        "first_notification_delay": "$SERVICEFIRSTNOTIFICATIONDELAY$"
    }
};
PROPERTY.getTypeByName              = function ( property_name, shinken_element_type ) {
    switch ( property_name ) {
        case PROPERTY.CONST.NAME.CHECK_INTERVAL:
        case PROPERTY.CONST.NAME.CHECK_RUNNING_TIMEOUT:
        case PROPERTY.CONST.NAME.FIRST_NOTIFICATION_DELAY:
        case PROPERTY.CONST.NAME.FLAP_DETECTION_OPTIONS:
        case PROPERTY.CONST.NAME.FRESHNESS_THRESHOLD:
        case PROPERTY.CONST.NAME.MAX_CHECK_ATTEMPTS:
        case PROPERTY.CONST.NAME.NOTE_URL:
        case PROPERTY.CONST.NAME.NOTIFICATION_INTERVAL:
        case PROPERTY.CONST.NAME.NOTIFICATION_OPTIONS:
        case PROPERTY.CONST.NAME.RETRY_INTERVAL:
            return PROPERTY.CONST.TYPES.STRING_INPUT;
        case PROPERTY.CONST.NAME.THRESHOLDS_DISPLAY:
            return PROPERTY.CONST.TYPES.STRING_INPUT_WITH_RENDER;
        case PROPERTY.CONST.NAME.CHECK_PERIOD:
        case PROPERTY.CONST.NAME.MAINTENANCE_PERIOD:
        case PROPERTY.CONST.NAME.NOTIFICATION_PERIOD:
            return PROPERTY.CONST.TYPES.SINGLE_SELECT;
        case PROPERTY.CONST.NAME.USE:
        case PROPERTY.CONST.NAME.VIEW_CONTACTS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACTS:
        case PROPERTY.CONST.NAME.EDITION_CONTACTS:
        case PROPERTY.CONST.NAME.VIEW_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.NOTIFICATION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.EDITION_CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.BUSINESS_IMPACT_MODULATIONS:
        case PROPERTY.CONST.NAME.CONTACTS:
        case PROPERTY.CONST.NAME.CONTACT_GROUPS:
        case PROPERTY.CONST.NAME.ESCALATIONS:
        case PROPERTY.CONST.NAME.MACRO_MODULATIONS:
        case PROPERTY.CONST.NAME.RESULT_MODULATIONS:
        case PROPERTY.CONST.NAME.PARENTS:
        case PROPERTY.CONST.NAME.NOTIFICATIONWAYS:
        case PROPERTY.CONST.NAME.CONTACTGROUPS:
        case PROPERTY.CONST.NAME.HOSTGROUPS:
            return PROPERTY.CONST.TYPES.MULTI_SELECT;
        case PROPERTY.CONST.NAME.HOST_NAME:
            switch ( shinken_element_type ) {
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_HOST:
                case OBJECT.CONST.ELEMENT.TYPE.CHECK_ON_CLUSTER:
                    return PROPERTY.CONST.TYPES.MULTI_SELECT;
                case OBJECT.CONST.ELEMENT.TYPES.CHECK_ON_TPL_HOST:
                case OBJECT.CONST.ELEMENT.TYPES.CHECK_ON_TPL_CLUSTER:
                    return PROPERTY.CONST.TYPES.STRING_INPUT_WITH_DROPDOWN;
                default:
                    return PROPERTY.CONST.TYPES.STRING_INPUT;
            }
        case PROPERTY.CONST.NAME.LOW_FLAP_THRESHOLD:
        case PROPERTY.CONST.NAME.HIGH_FLAP_THRESHOLD:
            return PROPERTY.CONST.TYPES.RANGE;
        case PROPERTY.CONST.NAME.SLA_CRITICAL_THRESHOLD:
        case PROPERTY.CONST.NAME.SLA_WARNING_THRESHOLD:
            return PROPERTY.CONST.TYPES.RANGE_WITH_INPUT;
        case PROPERTY.CONST.NAME.NOTE_MULTI_URL:
            return PROPERTY.CONST.TYPES.MULTI_LINE_OBJECT;
        default:
            if ( SHINKEN.TOOLS.STRING.startsWith( property_name, PROPERTY.CONST.DATA.IDENTIFIER_DATA_LOCAL ) ) {
                return PROPERTY.CONST.TYPES.DATA;
            }
            return "";
        
    }
    
};
PROPERTY.getPropertyInformationName = function ( property_name ) {
    return property_name + PROPERTY.CONST.PROPERTY_INFORMATION_TAG;
};
var SOURCE = {};
SOURCE.CONST = {
    ASK_IMPORT   : {
        NONE     : 0,
        ASKED    : 1,
        CONFIRMED: 2
    },
    VIEW_TYPES   : {
        DETAIL: 0,
        ALL   : 1
    },
    TYPES        : {
        ALL      : 'all',
        COLLECTOR: 'collector',
        LISTENER : 'listener',
        ANALYZER : 'analyzer'
    },
    FIELD        : {
        NAME               : 'source_name',
        TYPE               : 'type',
        ORDER              : 'order',
        STATE              : 'state',
        ENABLED            : 'enabled',
        NEXT_IMPORT        : 'next_import',
        NB_ELEMENTS_OK     : 'nb_elements_ok',
        NB_ELEMENTS_WARNING: 'nb_elements_warning',
        NB_ELEMENTS_ERROR  : 'nb_elements_error',
        OUTPUT             : 'output',
        LAST_IMPORT        : 'last_import',
        LAST_IMPORT_HTML   : 'last_import_html',
        NEXT_IMPORT_HTML   : 'next_import_html',
        IMPORT_INTERVAL    : 'import_interval',
        IMPORT_ENABLED     : 'import_enabled',
        ALREADY_IMPORT     : 'already_import',
        IP_RANGES          : 'ip_range',
        MODULE_TYPE        : 'module_type',
        FULLY_MERGED       : 'fully_merged'
    },
    STATE        : {
        OK                          : 'OK',
        PENDING                     : 'PENDING',
        WARNING                     : 'WARNING ',
        CRITICAL                    : 'CRITICAL',
        RUNNING                     : 'RUNNING',
        NOT_CONFIGURED              : 'not-configured',
        NOT_CONFIGURED_BEFORE_IMPORT: 'not-configured-before-import',
        IN_PROGRESS                 : 'difference-computing',
        NEVER_IMPORT                : 'never-import',
        READY_FOR_IMPORT            : 'ready-for-import',
        CONFIGURATION_ERROR         : 'CONFIGURATION_ERROR',
        NEED_CONFIRMATION           : 'need-confirmation'
    },
    RANGE        : {
        ID         : '_id',
        NAME       : 'discovery_name',
        STATE      : 'state',
        ENABLED    : 'discovery_enabled',
        DESCRIPTION: 'notes',
        IP_RANGE   : 'iprange',
        SOURCE_NAME: 'source_name'
    },
    CONFIGURATION: {
        INVALID_ORDER: 'INVALID_ORDER'
    }
};
SHINKEN.TOOLS.DICT = (function ( self ) {
    "use strict";
    self.CONST   = {};
    self.assign  = function ( dest, src ) {
        var _keys = Object.keys( src );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key         = _keys[ i ];
            dest[ _current_key ] = src[ _current_key ];
        }
        return dest;
    };
    self.assigns = function ( dest, srcs ) {
        return srcs.reduce( self.assign, dest );
    };
    self.clone  = function (to_clone) {
        var json = JSON.stringify(to_clone);
        var to_return = JSON.parse(json);
        
        return to_return;
    }
    return self;
})( SHINKEN.TOOLS.DICT || {} );
SHINKEN.NAVIGATOR = (function ( self ) {
    "use strict";
    
    var navigator = {
        isChrome : false,
        isFireFox: false,
        isIE     : false,
        isHidden : false
    };
    
    
    setInterval( function () {
        setDocumentHidden();
    }, 2000 );
    
    function setDocumentHidden () {
        navigator.isHidden = document.hidden;
    }
    
    self.isNavigator          = function ( type ) {
        return navigator[ type ];
    };
    self.isNavigatorHidden    = function () {
        return navigator.isHidden;
    };
    self.init                 = function ( nb_try ) {
        var _navigator_class = '';
        if ( window.navigator.userAgent.indexOf( 'Firefox' ) !== -1 ) {
            navigator.isFireFox = true;
            _navigator_class    = 'shinken-navigator-is-firefox';
        }
        else if ( window.navigator.userAgent.indexOf( 'Chrome' ) !== -1 ) {
            navigator.isChrome = true;
            _navigator_class   = 'shinken-navigator-is-chrome';
        }
        if ( document.body ) {
            document.body.classList.add( _navigator_class );
        }
        else if ( nb_try ) {
            setTimeout( function () {
                nb_try = nb_try - 1;
                SHINKEN.NAVIGATOR.init( nb_try );
            }, 1000 );
        }
    };
    self.shinken_beforeunload = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_beforeunload();
            default:
                return '';
        }
    };
    self.shinken_unload       = function ( page_name ) {
        switch ( page_name ) {
            case 'page-analyzer-job':
                return analyzer_unload();
            default:
                return '';
        }
    };
    
    
    return self;
})( SHINKEN.NAVIGATOR || {} );
SHINKEN.NAVIGATOR.init( 50 );
var DATE_TIME = {};
var __traduction;
DATE_TIME.FORMAT = {
    TIME           : {
        DEFAULT: "HH:MM:SS",
        HH_MM  : "HH:MM"
    },
    DATE           : {
        DEFAULT   : "YYYY-MM-DD",
        WITH_SLASH: "YYYY/MM/DD",
        NO_YEAR   : "MM-DD"
    },
    TIME_PERIOD    : {
        YEAR   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30 * 355,
            KEY      : 'year',
            SHORT_KEY: 'short_year'
        },
        MONTH  : {
            NB_MS    : 1000 * 60 * 60 * 24 * 30,
            KEY      : 'month',
            SHORT_KEY: 'short_month'
        },
        WEEK   : {
            NB_MS    : 1000 * 60 * 60 * 24 * 7,
            KEY      : 'week',
            SHORT_KEY: 'short_week'
        },
        DAY    : {
            NB_MS    : 1000 * 60 * 60 * 24,
            KEY      : 'day',
            SHORT_KEY: 'short_day'
        },
        HOUR   : {
            NB_MS    : 1000 * 60 * 60,
            KEY      : 'hour',
            SHORT_KEY: 'short_hour'
        },
        MINUTE : {
            NB_MS    : 1000 * 60,
            KEY      : 'minute',
            SHORT_KEY: 'short_minute'
        },
        SECONDE: {
            NB_MS    : 1000,
            KEY      : 'second',
            SHORT_KEY: 'short_second'
        }
    },
    NOW            : 'now',
    TYPE_VALIDATION: {
        HOUR: "hour",
        MIN : "min"
    }
};
DATE_TIME.now = function() {
    return new Date();
};
DATE_TIME.buildDate = function(day_delta) {
    var _to_return = new Date();
    _to_return.setDate(_to_return.getDate()+day_delta);
    return _to_return;
};
DATE_TIME.getTimestampNow = function() {
    return Date.now();
};
DATE_TIME.FORMAT.getTime = function( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.TIME.DEFAULT;
    }
    format = format.toUpperCase();
    switch ( format ) {
        case DATE_TIME.FORMAT.TIME.DEFAULT:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
        case DATE_TIME.FORMAT.TIME.HH_MM:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 );
        default:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getHours(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMinutes(), 2 ) + ':' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getSeconds(), 2 );
    }
    
};
DATE_TIME.FORMAT.get_date = function( date, format ) {
    if ( !format ) {
        format = DATE_TIME.FORMAT.DATE.DEFAULT;
    }
    
    switch ( format ) {
        case DATE_TIME.FORMAT.DATE.DEFAULT:
            return date.getFullYear() +  '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
        case DATE_TIME.FORMAT.DATE.NO_YEAR:
            return SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
        case DATE_TIME.FORMAT.DATE.WITH_SLASH:
            return date.getFullYear() + '/' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '/' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
        default:
            return  date.getFullYear() + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getMonth() + 1, 2 ) + '-' + SHINKEN.TOOLS.STRING.prefix_by_zero( date.getDate(), 2 );
    }
    
};
DATE_TIME.FORMAT.get_date_from_timestamp = function( timestamp, format ) {
    return DATE_TIME.FORMAT.get_date(new Date(timestamp*1000), format);
};
DATE_TIME.FORMAT.get_time_from_timestamp = function( timestamp, format ) {
    return DATE_TIME.FORMAT.getTime(new Date(timestamp*1000), format);
};
DATE_TIME.initTraduction = function() {
    __traduction = [];
    var keys = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _short_label;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key = keys[ i ];
        _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        _short_label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        __traduction[ _label ] = [_( 'timeperiods.' + _label ), _( 'timeperiods.' + _label + 's' )];
        __traduction[ _short_label ] = [_( 'timeperiods.' + _short_label ), _( 'timeperiods.' + _short_label + 's' )];
    }
    __traduction[ DATE_TIME.NOW ] = [_( 'timeperiods.now' ), ''];
};
DATE_TIME.getTraduction = function( key, is_plural ) {
    if ( !__traduction ) {
        this.initTraduction();
    }
    return __traduction[ key ][ is_plural ? 1 : 0 ];
};
DATE_TIME.durationToString = function( timestamp, is_short_name, limit ) {
    if ( !timestamp ) {
        return DATE_TIME.getTraduction( DATE_TIME.NOW, false );
    }
    
    var in_the_past = false;
    if ( timestamp < 0 ) {
        in_the_past = true;
        timestamp = -timestamp;
    }
    
    if ( !limit ) {
        limit = 9999;
    }
    var toReturn = '';
    var _nb;
    var keys = Object.keys( DATE_TIME.FORMAT.TIME_PERIOD );
    var _key,
        _label,
        _nb_sec;
    for ( var i = 0, size = keys.length; i < size; i++ ) {
        _key = keys[ i ];
        if ( is_short_name ) {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'SHORT_KEY' ];
        }
        else {
            _label = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'KEY' ];
        }
        
        _nb_sec = DATE_TIME.FORMAT.TIME_PERIOD[ _key ][ 'NB_MS' ];
        
        if ( timestamp >= _nb_sec ) {
            _nb = parseInt( timestamp / _nb_sec );
            if ( toReturn ) {
                toReturn += " ";
            }
            toReturn += _nb + " " + DATE_TIME.getTraduction( _label, _nb > 1 );
            timestamp = timestamp - _nb * _nb_sec;
            limit--;
        }
        if ( limit <= 0 ) {
            break;
        }
    }
    if ( !toReturn ) {
        toReturn = DATE_TIME.getTraduction( DATE_TIME.NOW, false );
    }
    else if ( in_the_past ) {
        toReturn = _( 'timeperiods.agoMoment' ) + ' ' + toReturn;
    }
    else {
        toReturn = _( 'timeperiods.inMoment' ) + ' ' + toReturn;
    }
    return toReturn;
};
DATE_TIME.relativeTime = function( elapsed ) {
    if ( elapsed < 0 ) {
        return relativeTime( -elapsed ) + ' ago';
    }
    var msPerSecond = DATE_TIME.FORMAT.TIME_PERIOD[ 'SECONDE' ][ 'NB_MS' ];
    var msPerMinute = DATE_TIME.FORMAT.TIME_PERIOD[ 'MINUTE' ][ 'NB_MS' ];
    var msPerHour = DATE_TIME.FORMAT.TIME_PERIOD[ 'HOUR' ][ 'NB_MS' ];
    var msPerDay = DATE_TIME.FORMAT.TIME_PERIOD[ 'DAY' ][ 'NB_MS' ];
    var msPerMonth = DATE_TIME.FORMAT.TIME_PERIOD[ 'MONTH' ][ 'NB_MS' ];
    var msPerYear = DATE_TIME.FORMAT.TIME_PERIOD[ 'YEAR' ][ 'NB_MS' ];
    
    if ( elapsed < msPerMinute ) {
        return Math.round( elapsed / msPerSecond );
    }
    else if ( elapsed < msPerHour ) {
        return Math.round( elapsed / msPerMinute );
    }
    else if ( elapsed < msPerDay ) {
        return Math.round( elapsed / msPerHour );
    }
    else if ( elapsed < msPerMonth ) {
        return Math.round( elapsed / msPerDay );
    }
    else if ( elapsed < msPerYear ) {
        return Math.round( elapsed / msPerMonth );
    }
    else {
        return Math.round( elapsed / msPerYear );
    }
};
DATE_TIME.isValid = function( type, string_value ) {
    if ( isNaN( string_value ) ) {
        return false;
    }
    var _value_splitted = string_value.split( '' );
    var _size = _value_splitted.length;
    var value;
    switch ( type ) {
        case DATE_TIME.FORMAT.TYPE_VALIDATION.HOUR:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 23 ) {
                return false;
            }
            break;
        case DATE_TIME.FORMAT.TYPE_VALIDATION.MIN:
            if ( _size !== 2 ) {
                return false;
            }
            if ( isNaN( _value_splitted[ 0 ] ) || isNaN( _value_splitted[ 1 ] ) ) {
                return false;
            }
            value = parseInt( string_value );
            if ( value < 0 || value > 59 ) {
                return false;
            }
            break;
        default:
            console.warn( "DATE_TIME.isValid : unknown format =>", type );
    }
    return true;
};
DATE_TIME.isValidRangeTimeperiod = function( time1, time2 ) {
    return (DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time1 ) <= DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, time2 ));
};
DATE_TIME.splitTimeperiodDay = function( value ) {
    var _to_return = [];
    var _timeperiod_ranges = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES );
    for ( var i = 0, _size = _timeperiod_ranges.length; i < _size; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodRanges( _timeperiod_ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodRanges = function( value ) {
    var ranges = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS );
    var _size_ranges = ranges.length;
    var _to_return = [];
    for ( var i = 0; i < _size_ranges; i++ ) {
        _to_return.push( DATE_TIME.splitTimeperiodTime( ranges[ i ] ) );
    }
    return _to_return;
};
DATE_TIME.splitTimeperiodTime = function( value ) {
    var _to_return = {};
    var _time_splitted = value.split( PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN );
    if ( _time_splitted.length !== 2 ) {
        _to_return.invalid = true;
        return _to_return;
    }
    _to_return.hour = _time_splitted[ 0 ].trim();
    _to_return.min = _time_splitted[ 1 ].trim();
    
    return _to_return;
};
DATE_TIME.getTimeperiodLabel = function( type, value ) {
    switch ( type ) {
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR:
            return value.hour + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOUR_MIN + value.min;
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE:
            return DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 0 ] ) + PROPERTY.CONST.TIMEPERIOD.SEPARATOR.HOURS + DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.HOUR, value[ 1 ] );
        case PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.FULL:
            var _current_range;
            var _to_return = "";
            var _size = value.length;
            for ( var i = 0; i < _size; i++ ) {
                _current_range = value[ i ];
                _to_return += DATE_TIME.getTimeperiodLabel( PROPERTY.CONST.TIMEPERIOD.FORMAT_LABEL.RANGE, value[ i ] );
                if ( (value + 1) !== _size ) {
                    _to_return += PROPERTY.CONST.TIMEPERIOD.SEPARATOR.RANGES;
                }
            }
            return _to_return;
    }
};
DATE_TIME.initHistoricArrayTimeStamp             = function ( length ) {
        var toReturn = [];
        for ( var i = length - 1; i>=0; i-- ) {
            toReturn.push( DATE_TIME.buildDate(- i).getTime()/1000 );
        }
        return toReturn;
    };
DATE_TIME.getTimezoneOffsetInHour = function( value ) {
    return value.getTimezoneOffset() / 60;
};
DOM.ScrollService = (function ( self ) {
    "use strict";
    
    self.getMiddleScrollPosition       = function ( dom_element_container ) {
        var _top    = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.TOP );
        var _bottom = DOM.Service.getBoundingClientRect( dom_element_container, DOM.CONST.STYLE.BOTTOM );
        
        return ((_bottom - _top) / 2) + _top;
    };
    self.getFirstVisibleDom            = function ( dom_element_container, css_selector_children, move_down ) {
        var _position = DOM.Service.getBoundingClientRect( dom_element_container, move_down ? DOM.CONST.STYLE.TOP : DOM.CONST.STYLE.BOTTOM );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _position, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFromMiddle = function ( dom_element_container, css_selector_children, move_down ) {
        var _middle_pos = DOM.ScrollService.getMiddleScrollPosition( dom_element_container );
        var _list       = SHINKEN.TOOLS.ARRAY.parseToArray( dom_element_container.querySelectorAll( css_selector_children ) );
        var _size       = _list.length;
        if ( !_size ) {
            return null;
        }
        return self.getCloserVisibleDomFrom( _list, _middle_pos, move_down, dom_element_container );
    };
    self.getCloserVisibleDomFrom       = function ( list, position, move_down, dom_element_container ) {
        var _size  = list.length;
        var _index = move_down ? _size - 1 : 0;
        var _delta = move_down ? -1 : 1;
        
        var _closer_index     = _index;
        var _last_closer_diff = 9999;
        var _current;
        for ( ; _index < _size && _index >= 0; _index = _index + _delta ) {
            _current = list[ _index ];
            if ( !DOM.Service.isVisible( _current ) ) {
                continue;
            }
            if ( DOM.Service.getMissingScrollPositionToBeVisible( _current, dom_element_container ) ) {
                continue;
            }
            var _median = DOM.Service.getBoundingClientRect( _current, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
            if ( Math.abs( _median - position ) < _last_closer_diff ) {
                _last_closer_diff = Math.abs( _median - position );
                _closer_index     = _index;
                continue;
            }
            else {
                break;
            }
        }
        return list[ _closer_index ];
    };
    self.isVisible                     = function ( dom_element_container, dom_element_to_test, marge, action_type ) {
        if ( !dom_element_to_test ) {
            return false;
        }
        marge               = marge || 0;
        var _rect_to_test   = dom_element_to_test.getBoundingClientRect();
        var _rect_container = dom_element_container.getBoundingClientRect();
        
        if ( action_type ) {
            if ( _rect_to_test.bottom - _rect_container.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_DOWN;
            }
            if ( _rect_container.bottom - _rect_to_test.top <= marge ) {
                return action_type === DOM.CONST.ATTRIBUTE.SCROLL_TOP;
            }
            return true;
        }
        else {
            return _rect_to_test.bottom - _rect_container.top >= marge && _rect_container.bottom - _rect_to_test.top >= marge;
        }
    };
    self.bindWith                      = function ( dom_element, dom_element_to_bind_with, previous_position_vertical, action_type ) {
        switch ( action_type ) {
            case DOM.CONST.ATTRIBUTE.SCROLL_TOP:
            case DOM.CONST.ATTRIBUTE.SCROLL_DOWN:
                if ( self.isVisible( dom_element, dom_element_to_bind_with, 3 * DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT ), action_type ) ) {
                    return;
                }
                else {
                    var _delta = DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.STYLE.HEIGHT );
                    if ( previous_position_vertical ) {
                        _delta = previous_position_vertical - DOM.Service.getBoundingClientRect( dom_element_to_bind_with, DOM.CONST.SPECIAL.MEDIAN_TOP_BOTTOM );
                    }
                    self.changeVerticaly( dom_element, _delta, action_type );
                }
                break;
        }
    };
    self.changeVerticaly               = function ( dom_element, delta, action_type ) {
        dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] = Math.ceil( dom_element[ DOM.CONST.ATTRIBUTE.SCROLL_TOP ] - delta );
    };
    
    return self;
})( DOM.ScrollService || {} );
SHINKEN.TOOLS.NUMBER = (function ( self ) {
    "use strict";
    self.roundTo                 = function ( number, precision ) {
        if ( !precision ) {
            precision = 0;
        }
        var _number = Number( number );
        return _number.toFixed( precision );
    };
    self.parseFloat              = function ( number ) {
        if ( typeof number === "string" ) {
            number = number.replace( ',', '.' );
        }
        return parseFloat( number );
    };
    self.percent                 = function ( number ) {
        return self.roundTo( number * 100, 2 );
    };
    self.getRandom               = function ( min, max ) {
        return Math.floor( Math.random() * (max - min + 1) + min );
    };
    self.percent_no_extem        = function ( number ) {
        var toReturn = self.percent( number );
        if ( toReturn === '100.00' ) {
            toReturn = 100;
            if ( number !== 1 ) //IN ORDER TO NOT BE AT 100% WHEN THE PERCENT IS ROUNDED
            {
                toReturn = 99.99;
            }
        }
        else if ( toReturn === '-100.00' ) {
            toReturn = -100;
        }
        else if ( toReturn === '0.00' ) {
            toReturn = 0;
        }
        return toReturn;
    };
    self.getPathIconSla          = function ( sla_percent, critical_threshold, warning_threshold ) {
        sla_percent        = parseFloat( sla_percent );
        critical_threshold = parseFloat( critical_threshold );
        warning_threshold  = parseFloat( warning_threshold );
        var _path          = "";
        if ( sla_percent < critical_threshold ) {
            _path = "assets/images/widget/sla/storm.svg";
        }
        else if ( sla_percent >= critical_threshold && sla_percent < warning_threshold ) {
            _path = "assets/images/widget/sla/cloud.svg";
        }
        else {
            _path = 'assets/images/widget/sla/sun.svg';
        }
        return _path;
    };
    self.getDateToFormatedNumber = function ( number_date ) {
        if ( number_date > 9 ) {
            return number_date;
        }
        return "0" + number_date;
    };
    self.getValueInInterval      = function ( value, min, max ) {
        return Math.max( Math.min( value, max ), min );
    };
    return self;
})( SHINKEN.TOOLS.NUMBER || {} );
var __lang_obj        = {};
var DICTIONARY_COMMON = "common";
var DICTIONARY_COMMON_UI = "common_ui";
function __gup ( name, url ) {
    if ( !url ) {
        url = location.href;
    }
    name        = name.replace( /[\[]/, "\\\[" ).replace( /[\]]/, "\\\]" );
    var regexS  = "[\\?&]" + name + "=([^&#]*)";
    var regex   = new RegExp( regexS );
    var results = regex.exec( url );
    return results == null ? null : results[ 1 ];
}
function _load_lang_obj_array ( dictionary_origin_array ) {
    for ( var i = 0, _size_i = dictionary_origin_array.length; i < _size_i; i++ ) {
        _load_lang_obj( dictionary_origin_array[ i ] );
    }
}
function _load_lang_obj ( dictionary_origin ) {
    if ( __lang_obj[ dictionary_origin ] ) {
        return;
    }
    var lang                        = __gup( 'lang' );
    lang                            = !lang ? __shinken_lang__ : lang;
    var _to_return                  = dictionary_origin !== DICTIONARY_COMMON ? 'lang_' + dictionary_origin + '_' : 'lang_';
    if ( dictionary_origin === DICTIONARY_COMMON_UI ){
        _to_return = DICTIONARY_COMMON_UI + "_";
    }
    _to_return += lang === 'fr' ? lang : 'en';
    __lang_obj[ dictionary_origin ] = eval( _to_return );
}
function _ ( to_trad, dictionary_origin ) {
    var elts                    = to_trad.split( '.' );
    var dictionary_origin_array = !dictionary_origin ? [ DICTIONARY_COMMON ] : dictionary_origin;
    _load_lang_obj_array( dictionary_origin_array );
    
    for ( var j = 0, _size_j = dictionary_origin_array.length; j < _size_j; j++ ) {
        var _to_return = __lang_obj[ dictionary_origin_array[ j ] ][ elts[ 0 ] ];
        var _found     = true;
        for ( var i = 0, _size = elts.length; i < _size; i++ ) {
            _to_return = i !== 0 ? _to_return[ elts[ i ] ] : _to_return;
            if ( typeof _to_return === 'undefined' ) {
                _found = false;
                break;
            }
        }
        if ( _found ) {
            return _to_return;
        }
    }
    return 'TO_TRAD(' + to_trad + ')';
}
COMPONENT.Interface = function() {
};
COMPONENT.Interface.prototype = {
    initInterface: function() {
        this.url_param_key = this.dom_element.dataset.urlParamKey;
    },
    doExtraAction: function() {
        if ( this.url_param_key ) {
            this.updateUrlWithValue()
        }
    },
    updateUrlWithValue: function() {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Interface, SHINKEN.OBJECT.CounterInterface );
COMPONENT.Checkbox           = function ( dom_element, parent ) {
    this.init( dom_element, parent );
};
COMPONENT.Checkbox.prototype = {
    init                       : function ( dom_element, parent ) {
        this.dom_element = dom_element;
        this.initCounters( parent );
        this.checkbox_user      = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-user" ), this );
        this.checkbox_inherited = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-inherited" ), this );
        this.checkbox_default   = new OBJECT.ElementCheckbox( dom_element.querySelector( ".shinken-checkbox-default" ), this );
        this.initInterface();
    },
    toggleCheckedUser          : function () {
        var _value = !this.isCheckedUser();
        this.setCheckedUser( _value );
    },
    isCheckedUser              : function () {
        return this.checkbox_user.isChecked();
    },
    isCheckedInheritance       : function () {
        return this.checkbox_inherited.isChecked();
    },
    isCheckedDefault           : function () {
        return this.checkbox_default.isChecked();
    },
    setCheckedUser             : function ( to_set ) {
        this.checkbox_user.setChecked( to_set );
        this.doExtraAction();
    },
    setCheckedInheritance      : function ( to_set ) {
        this.checkbox_inherited.setChecked( to_set );
    },
    getChildrenObject              : function () {
        return [this.checkbox_user, this.checkbox_inherited, this.checkbox_default];
    },
    updateUrlWithValue         : function () {
        var _value = this.isCheckedUser() ? '1' : '';
        SHINKEN.HIGHWAY.setParam( this.url_param_key, _value );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Checkbox, COMPONENT.Interface );
COMPONENT.InputRange           = function ( dom_element, property ) {
    this.init( dom_element, property );
};
COMPONENT.InputRange.prototype = {
    init                 : function ( dom_element, property ) {
        this.type_range      = dom_element.dataset.type;
        this.dom_input_range = dom_element.querySelector( ".shinken-range-container input" );
        switch ( property.type ) {
            case PROPERTY.CONST.TYPES.RANGE_WITH_INPUT:
                this.component_input = new COMPONENT.Input( dom_element.querySelector( ".shinken-input-table" ), property );
                if ( property.is_mass_change ) {
                    this.component_input.setPlaceholder( _( "mass-change.label.enter_a_value" ) );
                }
                this.value = this.dom_input_range.dataset.lastValueFromUser;
                break;
            
            default:
                this.component_label_input = new COMPONENT.Label( dom_element.querySelector( ".shinken-label-input-range" ) );
                this.value                 = parseInt( this.dom_input_range.dataset.lastValueFromUser ) + "";
                break;
        }
        this.value_from_user = property.is_mass_change ? '' : this.value;
        this.min             = this.dom_input_range.getAttribute( 'min' );
        this.max             = this.dom_input_range.getAttribute( 'max' );
        this.unit            = dom_element.dataset.unit;
        this.property_name   = property.getName();
        this.is_mass_change  = property.is_mass_change;
    },
    askComputeAfterChange: function ( dom_element, parent ) {
        if ( this.is_disabled ) {
            return;
        }
        this.component_input.askComputeAfterChange( dom_element, parent || this );
    },
    setValue             : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = false;
        }
        this.value                 = to_set;
        this.dom_input_range.value = to_set;
        if ( this.component_input ) {
            if ( updateInputField && this.component_input.getValue() !== to_set ) {
                this.updateInput();
            }
            else if ( !updateInputField ) {
                this.emptyInput();
            }
        }
        else {
            this.updateLabel();
        }
    },
    setValueFromUser     : function ( to_set, updateInputField ) {
        if ( typeof(updateInputField) === "undefined" ) { // IE Hack
            updateInputField = true;
        }
        if ( to_set === null || to_set === undefined ) {
            to_set = this.dom_input_range.value;
            if ( this.component_input && to_set !== "0" && to_set !== "100" ) {
                to_set += ".000";
            }
        }
        to_set               = to_set + '';
        this.value_from_user = to_set;
        this.setValue( to_set, updateInputField );
    },
    updateInput          : function () {
        this.component_input.dom_element_input.value = this.value;
        this.component_input.setValueFromInput();
        this.component_input.validateValueInput();
    },
    emptyInput           : function () {
        this.component_input.dom_element_input.value = '';
        this.component_input.setValueFromInput();
        this.component_input.resetCounters();
        this.component_input.setStatus( COMPONENT.CONST.STATUS.NONE );
        this.component_input.validateValueInput();
    },
    updateLabel          : function () {
        var _to_set;
        if ( this.is_mass_change && this.value === '' ) {
            _to_set = _( "mass-change.label.enter_a_value" );
        }
        else {
            switch ( this.type_range ) {
                case PROPERTY.CONST.TYPES.RANGE:
                    _to_set = this.value + this.unit;
                    break;
                case PROPERTY.CONST.TYPES.RANGE_BUSINESS_IMPACT:
                    _to_set = _( "element.business_impact_" + this.value );
                    break;
            }
        }
        this.component_label_input.updateLabel( _to_set );
    },
    getValue             : function () {
        return this.value;
    },
    getValueFromUser     : function () {
        return this.value_from_user;
    },
    getChildrenObject        : function () {
        var _to_return = [];
        if ( this.component_input ) {
            _to_return.push( this.component_input );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InputRange, SHINKEN.OBJECT.CounterInterface );
COMPONENT.ListSelectElement           = function ( dom_element ) {
    this.init( dom_element );
};
COMPONENT.ListSelectElement.prototype = {
    init               : function ( dom_element ) {
        this.dom_element = dom_element;
        this.is_filtered   = false;
        this.reason_to_set = [];
        this.element = new OBJECT.ElementList();
        if ( dom_element ) {
            this.dom_title   = dom_element.querySelector( '.' + 'shinken-option-title' );
            this.initElement();
            this.is_selected = dom_element.classList.contains( 'shinken-selected' );
        }
    },
    initElement        : function () {
        this.element = new OBJECT.ElementList();
        this.element.canHaveXssFailure = !!this.dom_element.dataset.canHaveXssFailure;
        this.element.setName( this.dom_element.dataset.keyName, this.dom_element );
        this.element.setLabel( this.dom_element.dataset.keyLabel );
        this.element.setState( this.dom_element.dataset.state );
        this.element.setIsDisabled( this.dom_element.dataset.isDisabled );
        this.element.setIsForceToNull( this.dom_element.dataset.forceToNull );
        this.element.setType( this.dom_element.dataset.type );
        this.element.setUUID( this.dom_element.dataset.uuid );
        this.element.setItemType( this.dom_element.dataset.itemType );
        this.element.setIsHiddenForAdminSi( this.dom_element.dataset.isHiddenForAdminSi );
        this.element.setIsLock(this.dom_element.classList.contains("shinken-option-locked"));
        this.element.setErrorMessage( this.dom_element.dataset.errorMessage );
    },
    getElement         : function () {
        return this.element;
    },
    getDomElement      : function () {
        return this.dom_element;
    },
    getName            : function () {
        return this.element.getName();
    },
    getLabel           : function () {
        return this.element.getLabel();
    },
    getState           : function () {
        return this.element.getState();
    },
    getTextContent     : function () {
        return this.dom_title.textContent;
    },
    getTextContentShort: function () {
        return this.dom_title.dataset.label;
    },
    setSelected        : function ( _to_set, extra_class, reason ) {
        if ( !reason ) {
            reason = "shinken-main-selector";
        }
        if ( _to_set ) {
            SHINKEN.TOOLS.ARRAY.addElement( this.reason_to_set, reason );
            this.dom_element.classList.add( 'shinken-selected' );
            if ( extra_class ) {
                DOM.Service.addClasses( this.dom_element, extra_class );
            }
        }
        else {
            SHINKEN.TOOLS.ARRAY.removeElement( this.reason_to_set, reason );
            if ( this.reason_to_set.length ) {
                return;
            }
            this.dom_element.classList.remove( 'shinken-selected' );
            this.dom_element.classList.remove( 'shinken-select-focused' );
            this.dom_element.classList.remove( 'shinken-select-no-events' );
            if ( extra_class ) {
                DOM.Service.removeClasses( this.dom_element, extra_class );
            }
        }
        this.is_selected = _to_set;
    },
    isSelected         : function () {
        return this.is_selected;
    },
    setIsFiltered      : function ( to_set ) {
        this.is_filtered = to_set;
        if ( to_set ) {
            this.dom_element.classList.add( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
        else {
            this.dom_element.classList.remove( COMPONENT.CONST.LIST_SELECT_ELEMENT.CLASS.HIDDEN );
        }
    },
    doFilter           : function ( filter ) {
        if ( !MANAGER.__instance_element_distributor.current_user.is_admin && this.element.is_hidden_for_admin_si ) {
            return false;
        }
        if ( this.element.state === COMPONENT.CONST.TAG.STATE.OVERRIDE_UNKNOWN ) {
            return false;
        }
        if ( !filter ) {
            this.setIsFiltered( false );
            return this.element.type === OBJECT.CONST.ELEMENT_LIST.TYPE.USER;
        }
        if ( this.element.type !== OBJECT.CONST.ELEMENT_LIST.TYPE.USER ) {
            this.setIsFiltered( true );
            return false;
        }
        if ( SHINKEN.TOOLS.STRING.containsIgnoreCase( this.element.getName(), filter ) ) {
            this.setIsFiltered( false );
            return true;
        }
        else {
            this.setIsFiltered( true );
            return false;
        }
    },
    updateHtmlLabel    : function ( label ) {
        this.element.setLabel( label );
        this.dom_element.innerHTML = this.getLabel();
    }
};
MANAGER.DistributorObjectManager           = function () {
    this.objects = {};
};
MANAGER.DistributorObjectManager.prototype = {
    addObject : function ( _id, object ) {
        this.objects[ _id ] = object;
    },
    findObject: function ( _id ) {
        return this.objects[ _id ];
    },
    reset     : function () {
        this.objects = {};
    }
};
MANAGER.__instance_object_distributor      = new MANAGER.DistributorObjectManager();
MANAGER.DragNDropManager = (function ( self ) {
    "use strict";
    self.last_element_hovered = null;
    self.current_parent_name  = null;
    self.type_drag_start      = null;
    self.list_element         = null;
    self.single_element_drag  = null;
    self.options              = null;
    
    self.dragStartSingle           = function ( event ) {
        self.single_element_drag = DOM.Service.findParentElementWithClass( event.target, "shinken-draggable", 50 );
        self.single_element_drag.classList.add( "shinken-drag-active" );
        self._bounding_origin                = self.single_element_drag.getBoundingClientRect();
        self._mouse_x_origin                 = parseInt( event.clientX );
        self._mouse_y_origin                 = parseInt( event.clientY );
        document.querySelector( 'body' ).classList.add( "shinken-drag-active" );
        document.documentElement.addEventListener( 'mousemove', self.dragSingle, false );
        document.documentElement.addEventListener( 'mouseup', self.dragEndSingle, false );
        self._initParametersIsInWindow();
    };
    self.dragSingle                = function ( event ) {
        if ( !self.single_element_drag ) {
            return;
        }
        var _delta_x = parseInt( event.clientX ) - self._mouse_x_origin + self._bounding_origin.left;
        var _delta_y = parseInt( event.clientY ) - self._mouse_y_origin + self._bounding_origin.top;
        
        if ( self.options._is_in_screen ) {
            var _result = self._computeIsInScreen( _delta_x, _delta_y );
            _delta_x    = _result.x;
            _delta_y    = _result.y;
        }
        DOM.Service.setStyles( self.single_element_drag, { "top": _delta_y + 'px', "left": _delta_x + 'px' } );
    };
    self.dragEndSingle             = function () {
        document.documentElement.removeEventListener( 'mousemove', self.dragSingle, false );
        document.documentElement.removeEventListener( 'mouseup', self.dragEndSingle, false );
        document.querySelector( 'body' ).classList.remove( "shinken-drag-active" );
        self.single_element_drag.classList.remove( "shinken-drag-active" );
        self.single_element_drag = null;
    };
    self.dragStartShinken          = function ( e, type, parent_name, key_name ) {
        var _object = MANAGER.__instance_property_distributor.findElement( parent_name, true );
        if ( _object.is_disabled ) {
            return false;
        }
        e.dataTransfer.setData( 'text', 'anything' );
        self.type_drag_start      = type;
        self.current_parent_name  = parent_name;
        self.list_element         = _object.dragStartShinken( type, key_name );
        self.last_element_hovered = self.list_element.getDragged().getDomElement().parentNode;
        self.last_index           = self.last_element_hovered.dataset.index;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        
        var _list_droppable = _object.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = _list_droppable[ i ].getBoundingClientRect().width + 'px';
        }
    };
    self.dragOverShinken           = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
        if ( self.current_parent_name !== parent_name ) {
            return false;
        }
        if ( self.type_drag_start !== type ) {
            return false;
        }
        var _current_index_hovered = dom_element.dataset.index;
        if ( _current_index_hovered === self.last_index ) {
            return false;
        }
        
        self.list_element.changeElementPosition( self.last_index, _current_index_hovered );
        self.last_index = _current_index_hovered;
        self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        self.last_element_hovered = dom_element;
        self.last_element_hovered.classList.add( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
    };
    self.dragEndShinken            = function ( e, type ) {
        var _list_droppable = MANAGER.__instance_property_distributor.last_element_focus.dom_element.querySelectorAll( '.droppable' );
        for ( var i = 0, _size_i = _list_droppable.length; i < _size_i; i++ ) {
            _list_droppable[ i ].style.width = '';
        }
        
        if ( MANAGER.__instance_property_distributor.last_element_focus.is_disabled ) {
            return false;
        }
        e.preventDefault();
        MANAGER.__instance_property_distributor.last_element_focus.resetDragging();
        
        if ( self.last_element_hovered ) {
            self.last_element_hovered.classList.remove( MANAGER.CONST.DRAG_N_DROP.CLASS.HOVER );
        }
        self.last_element_hovered = null;
        self.current_parent_name  = null;
        self.type_drag_start      = null;
        self.list_element         = null;
        self.pause_timeout        = null;
    };
    self.dropShinken               = function ( e, type, parent_name, dom_element ) {
        e.preventDefault();
    };
    self._computeIsInScreen        = function ( _delta_x, _delta_y ) {
        var _to_return = { x: _delta_x, y: _delta_y };
        if ( _delta_x < 0 ) {
            _to_return.x = 0;
        }
        else if ( (_delta_x + self._bounding_origin.width) > self.options._is_in_screen.parameters.window_width ) {
            _to_return.x = self.options._is_in_screen.parameters.window_width - self._bounding_origin.width - self.options._is_in_screen.parameters.scrollbar_x_width;
        }
        
        if ( _delta_y < 0 ) {
            _to_return.y = 0;
        }
        else if ( (_delta_y + self._bounding_origin.height) > self.options._is_in_screen.parameters.window_height ) {
            _to_return.y = self.options._is_in_screen.parameters.window_height - self._bounding_origin.height - self.options._is_in_screen.parameters.scrollbar_y_height;
        }
        return _to_return;
    };
    self._initParametersIsInWindow = function () {
        self.options = {
            _is_in_screen: {
                is_active : false,
                parameters: {}
            }
        };
        if ( !self.single_element_drag ){
            return;
        }
        if ( !DOM.Service.hasKeyInDataSet(self.single_element_drag,'dragIsInScreen' )){
            return;
        }
        self.options._is_in_screen.is_active = true;
        
        var _body                             = document.querySelector( 'body' );
        self.options._is_in_screen.parameters = {
            window_width      : window.innerWidth,
            window_height     : window.innerHeight,
            scrollbar_x_width : DOM.Service.scrollbarIsVisible( _body, 'width' ) ? 17 : 0,
            scrollbar_y_height: DOM.Service.scrollbarIsVisible( _body, 'height' ) ? 17 : 0
        };
    };
    return self;
})
( MANAGER.DragNDropManager || {} );
OBJECT.ElementList           = function () {
    this.init();
};
OBJECT.ElementList.prototype = {
    init                 : function () {
        this.is_disabled = false;
        this.is_useless  = false;
    },
    getName              : function () {
        return this.name;
    },
    getState             : function () {
        return this.state;
    },
    getType              : function () {
        return this.type;
    },
    getItemType          : function () {
        return this.item_type ? this.item_type : '';
    },
    getLabel             : function () {
        return this.label;
    },
    setName              : function ( to_set, dom_element ) {
        this.name = to_set;
        this.setLabel( to_set, dom_element );
    },
    setLabel             : function ( to_set ) {
        if ( this.canHaveXssFailure ) {
            this.label = SHINKEN.TOOLS.STRING.cleanXss( to_set );
        }
        else {
            this.label = to_set;
        }
    },
    setState             : function ( to_set ) {
        this.state = to_set;
    },
    setIsDisabled        : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_disabled = !!to_set;
    },
    setIsUseless         : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_useless = !!to_set;
    },
    setIsForceToNull     : function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_force_to_null = !!to_set;
    },
    setIsHiddenForAdminSi: function ( to_set ) {
        if ( to_set === 'false' ) {
            to_set = false;
        }
        this.is_hidden_for_admin_si = !!to_set;
    },
    setIsLock: function ( to_set ) {
        this.is_lock = to_set;
    },
    setErrorMessage: function ( to_set ) {
        this.error_message = to_set;
    },
    setUUID              : function ( to_set ) {
        this.uuid = to_set;
        this.findShinkenElement();
    },
    findShinkenElement   : function () {
        if ( this.uuid && this.item_type ) {
            var _shinken_element = MANAGER.__instance_element_distributor.getElementByDict( this );
            if ( _shinken_element ) {
                this.setShinkenElement( _shinken_element );
            }
        }
    },
    setShinkenElement    : function ( to_set ) {
        this.shinken_element = to_set;
    },
    setType              : function ( to_set ) {
        this.type = to_set;
    },
    setItemType          : function ( to_set ) {
        this.item_type = to_set;
        this.findShinkenElement();
    },
    clone                : function () {
        var _to_return = new OBJECT.ElementList();
        var _keys      = Object.keys( this );
        var _current_key;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current_key               = _keys[ i ];
            _to_return[ _current_key ] = this[ _current_key ];
        }
        return _to_return;
    },
    getClass             : function () {
        var _to_return = "";
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            _to_return += " shinken-element-new";
        }
        else if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            _to_return += " shinken-element-unknown";
        }
        else if ( this.is_disabled ) {
            _to_return += " shinken-element-disabled";
        }
        return _to_return;
    },
    getError             : function () {
        if ( this.state === COMPONENT.CONST.TAG.STATE.UNKNOWN ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.NEW ) {
            return 1;
        }
        if ( this.state === COMPONENT.CONST.TAG.STATE.IT_SELF ) {
            return 1;
        }
        if ( this.is_disabled ) {
            return 1;
        }
        if ( this.is_lock ) {
            return 1;
        }
        return 0;
    },
    getTooltip           : function () {
        var _to_return = "";
        if ( this.is_useless ) {
            switch ( this.type ) {
                case 'user' :
                    _to_return = _( 'element.tooltip_edition_contact_not_expert' );
                    break;
            }
        }
        if ( this.is_disabled ) {
            if ( _to_return ) {
                _to_return += "<br>";
            }
            _to_return += _( 'element.tooltip_disabled' );
        }
        switch ( this.state ) {
            case COMPONENT.CONST.TAG.STATE.NEW :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_NEW :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_new_disabled' );
                }
                else {
                    _to_return = _( 'element.tooltip_new' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.WORKING :
                if ( this.is_disabled ) {
                    _to_return = _( 'element.tooltip_working_disabled' );
                }
                else {
                    _to_return = _( 'element.tooltip_working' );
                }
                break;
            case COMPONENT.CONST.TAG.STATE.UNKNOWN :
            case COMPONENT.CONST.TAG.STATE.OVERRIDE_UNKNOWN :
                _to_return = _( 'element.tooltip_undefined' );
                break;
            case COMPONENT.CONST.TAG.STATE.IT_SELF :
                _to_return = _( 'element.tooltip_it_self' );
                break;
        }
        if ( this.is_force_to_null ) {
            if ( _to_return ) {
                _to_return += "<br>";
            }
            _to_return += SHINKEN.TOOLS.STRING.format( _( 'element.double_link_long_warning' ), this.getLabel() );
        }
        return _to_return;
    },
    getValueFinal        : function () {
        var _to_return = {};
        switch ( this.getState() ) {
            case OBJECT.CONST.TEMPLATE.STATUS.UNKNOWN:
            case OBJECT.CONST.TEMPLATE.STATUS.NEW:
            case COMPONENT.CONST.TAG.STATE.UNKNOWN:
            case COMPONENT.CONST.TAG.STATE.NEW:
                _to_return.name   = this.name;
                _to_return.exists = false;
                break;
            default:
                _to_return.name      = this.name;
                _to_return.item_type = this.getItemType();
                _to_return._id       = this.uuid;
                _to_return.exists    = true;
                break;
        }
        return _to_return;
    }
};
CONTROLLER.Help = (function ( self ) {
    "use strict";
    self._dom_element_help = null;
    self.toggleHelp        = function ( event ) {
        event.preventDefault();
        event.stopPropagation();
        if ( !self._dom_element_help ) {
            self._dom_element_help = document.getElementById( 'id-shinken-help-pop-up' );
            self._dom_element_help.classList.remove( 'shinken-hidden' );
            return;
        }
        self._dom_element_help.classList.toggle( 'shinken-hidden' );
    };
    self.closeHelp         = function () {
        if ( !self._dom_element_help ) {
            return;
        }
        self._dom_element_help.classList.add( 'shinken-hidden' );
    };
    return self;
})( CONTROLLER.Help || {} );
MANAGER.HelpGenerator = (function ( self ) {
    "use strict";
    self.content                   = [];
    self.size                      = 0;
    self.init                              = function (type_trad) {
        self.type_trad = type_trad;
        self.initContent();
        if ( !self.size ) {
            return;
        }
        self.buildButtonHtml();
        self.buildContentHtml();
        self.initEventListener();
    };
    self.initContent               = function () {
        var _found = document.querySelectorAll( ".shinken-help-container .shinken-help-content" );
        for ( var i = 0, _size_i = _found.length; i < _size_i; i++ ) {
            self.content.push( new OBJECT.Help( _found[ i ] ) );
            DOM.Service.removeElement( _found[ i ] );
        }
        self.size    = self.content.length;
        self.content = SHINKEN.TOOLS.ARRAY.sortArrayMultiple( self.content, [ "order_tab", "name_tab", "order" ] );
    };
    self.initEventListener         = function () {
        document.addEventListener( 'keydown', function ( event ) {
            MANAGER.EventManager.keydown( event );
        } );
    };
    self.buildButtonHtml           = function () {
        var _button_f1       = DOM.Service.createElement( 'div', { class: "shinken-help-button-container", onclick: "CONTROLLER.Help.toggleHelp(event)", 'data-name': "toggle_help" } );
        _button_f1.innerHTML = '<button class="shinken-button"><table><tr><td><span class="key">F1</span></td><td>' + _( 'common.help.label', self.type_trad ) + '</td></tr></table></button>';
        document.body.appendChild( _button_f1 );
    };
    self.buildContentHtml          = function (class_to_add) {
        var _content_to_html  = DOM.Service.createElement( 'div', {
            id     : "id-shinken-help-pop-up",
            class  : "shinken-hidden " + class_to_add,
            onclick: "MANAGER.EventManager.stopPropagation(event)"
        } );
        var _container_html   = DOM.Service.createElement( 'div', { class: "shinken-help-container" } );
        var _container_html_2 = DOM.Service.createElement( 'div', { class: "shinken-help-container-2" } );
        var _container_html_3 = DOM.Service.createElement( 'div', { class: "shinken-help-container-3" },
            "<div class='shinken-text-centred'><div class='shinken-help-title'>" + _( 'common.help.label', self.type_trad ) + "</div></div>" );
        var _current_tab;
        var _current_tab_name = "";
        for ( var i = 0, _size_i = self.size; i < _size_i; i++ ) {
            if ( _current_tab_name !== self.content[ i ].tab ) {
                _current_tab_name = self.content[ i ].tab;
                _current_tab      = WINDOW.ElementService.getWindowTargetHtml( 'div', _current_tab_name, !i );
                _container_html_3.appendChild( _current_tab );
            }
            _current_tab.appendChild( self.content[ i ].getHtml() );
        }
        _content_to_html.appendChild( _container_html );
        _container_html.appendChild( _container_html_2 );
        _container_html_2.appendChild( self.buildWindowsLineHtml() );
        _container_html_2.appendChild( _container_html_3 );
        document.body.appendChild( _content_to_html );
        document.body.appendChild( _content_to_html );
    };
    self.buildWindowsLineHtml      = function () {
        var _to_return = DOM.Service.createElement( 'div', {
            class      : "shinken-help-windows-title-menu shinken-window-group",
            "data-name": "help-group",
            onclick    : "MANAGER.EventManager.clickOnWindowNavigation(event,'help-group')"
        } );
        var _tab_list  = SHINKEN.TOOLS.ARRAY.extractKeys( this.content, [ 'tab', 'name_tab' ], true, true );
        _tab_list      = SHINKEN.TOOLS.ARRAY.removeDuplicateArray( _tab_list );
        _tab_list      = self.concatDuplicationWindowID( _tab_list );
        var _current;
        for ( var i = 0, _size_i = _tab_list.length; i < _size_i; i++ ) {
            _current = _tab_list[ i ];
            _to_return.appendChild( WINDOW.ElementService.getWindowHtml( "div", _current[ 0 ], _current[ 1 ], "help-group", !i ) );
        }
        var _button_close = DOM.Service.createElement( 'div', { class: "shinken-help-close-button shinkon-times-bold", onclick: "CONTROLLER.Help.toggleHelp(event)" } );
        _to_return.appendChild( _button_close );
        return _to_return;
    };
    self.concatDuplicationWindowID = function ( tab_list ) {
        var _to_return = [];
        var _mapping   = {};
        var _current;
        var _index;
        for ( var i = 0, _size_i = tab_list.length; i < _size_i; i++ ) {
            _current = tab_list[ i ];
            if ( _mapping[ _current[ 0 ] ] ) {
                _index                    = _mapping[ _current[ 0 ] ] - 1;
                _to_return[ _index ][ 1 ] = _to_return[ _index ][ 1 ] + SHINKEN.TOOLS.STRING.CONST.WHITE_SPACE + _current[ 1 ];
            }
            else {
                _mapping[ _current[ 0 ] ] = _to_return.push( _current );
            }
        }
        return _to_return;
    };
    return self;
})( MANAGER.HelpGenerator || {} );
OBJECT.Help = function ( dom_element ) {
    this.dom_element = dom_element;
    this.tab         = dom_element.dataset.tab;
    this.order       = parseInt( dom_element.dataset.order ) || 1;
    this.order_tab   = parseInt( dom_element.dataset.tabOrder ) || 1;
    this.name_tab    = dom_element.dataset.tabName || "??";
};
OBJECT.Help.prototype = {
    getHtml: function () {
        return this.dom_element;
    }
};
WINDOW.ElementGroup           = function ( name ) {
    this.name = SHINKEN.TOOLS.STRING.escapeBackslash(name);
    this.list = {};
    this.init();
};
WINDOW.ElementGroup.prototype = {
    init                     : function () {
        this.dom_element = document.querySelector( '.' + WINDOW.CONST.CLASS.WINDOW_GROUP + '[data-name="' + this.name + '"]' );
        this.initWindows();
    },
    initWindows              : function () {
        var _dom_elements = this.dom_element.querySelectorAll( '.' + WINDOW.CONST.CLASS.WINDOW_TAB + '[data-group-name="' + this.name + '"]' );
        this.size         = _dom_elements.length;
        var _current;
        var _current_name;
        var _has_properties;
        for ( var i = 0; i < this.size; i++ ) {
            _current                   = _dom_elements[ i ];
            _current_name              = _current.dataset.name;
            _has_properties            = _current.dataset.hasProperties;
            this.list[ _current_name ] = _has_properties ? new WINDOW.ElementWithProperties( _current_name, _current ) : new WINDOW.Element( _current_name, _current );
            MANAGER.__instance_object_distributor.addObject( this.list[ _current_name ].getUUID(), this.list[ _current_name ] );
        }
    },
    getActiveWindow          : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.list[ _keys[ i ] ].is_active ) {
                return this.list[ _keys[ i ] ];
            }
        }
        return null;
    },
    getWindowByName: function ( window_name ) {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if ( this.list[ _keys[ i ] ].getName() === window_name ) {
                return this.list[ _keys[ i ] ];
            }
        }
        return null;
    },
    
    clickOnWindow            : function ( window_name ) {
        var _active_window = this.getActiveWindow();
        if ( _active_window && _active_window.getName() === window_name ) {
            return;
        }
        var _current_window = this.getWindowByName( window_name );
        if ( _current_window && _current_window.is_disabled ) {
            return;
        }
        var _keys = Object.keys( this.list );
        var _current;
        var current_window;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            _current.setActive( _current.getName() === window_name );
            if ( _current.is_active ) {
                current_window = _current;
            }
        }
        if ( current_window.hasProperties() ) {
            MANAGER.ListenerEventManager.afterAction( MANAGER.CONST.AFTER_ACTION.UPDATE_VIEW_ON_WINDOW_PROPERTIES, window_name );
        }
        return true;
    },
    getElementByID           : function ( id ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getUUID() === id ) {
                return _current;
            }
        }
        return null;
    },
    getElementByName         : function ( name ) {
        var _keys = Object.keys( this.list );
        var _current;
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _current = this.list[ _keys[ i ] ];
            if ( _current.getName() === name ) {
                return _current;
            }
        }
        return null;
    },
    getDomElementTargets            : function () {
        return this.dom_element_targets;
    },
    setParentCounter         : function ( parent ) {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].setParentCounter( parent );
        }
    },
    setContentDomElementTarget      : function ( window_name, to_set ) {
        var _to_return = this.getWindowByName( window_name );
        this.getWindowByName( window_name ).setContentDomElementTarget( to_set );
        return _to_return;
    },
    hasProblems                     : function ( window_name ) {
        return this.getWindowByName(window_name).hasProblems();
    },
    focusOnFirstWindowWithProblem: function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            if (this.list[_keys[i]].hasProblems() ) {
                this.clickOnWindow(this.list[_keys[i]].name);
                return;
            }
        }
    },
    pulsateElementIfNotActive: function ( window_name ) {
        if ( this.getActiveWindow().getName() !== window_name ) {
            DOM.Service.askAddClass( this.getElementByName( window_name ).dom_element, 'shinken-pulsate', 2000 );
        }
    },
    cancelUserModification   : function () {
        var _keys = Object.keys( this.list );
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            this.list[ _keys[ i ] ].cancelUserModification();
        }
    },
    
    getDataToSave: function () {
        var _keys      = Object.keys( this.list );
        var _to_return = [];
        for ( var i = 0, _size = _keys.length; i < _size; i++ ) {
            _to_return = SHINKEN.TOOLS.ARRAY.concat( _to_return, this.list[ _keys[ i ] ].getDataToSave() );
        }
        return _to_return;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroup, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementGroup, SHINKEN.OBJECT.ShinkenObjectHtml );
WINDOW.ElementService = (function ( self ) {
    self.getWindowTargetHtml = function ( dom_tag, tab_name, is_active ) {
        var _class_to_add = is_active ? "shinken-window-target" : "shinken-window-target shinken-hidden";
        var _to_return    = DOM.Service.createElement( dom_tag, { id: "id-shinken-window-" + tab_name + "-target", class: _class_to_add } );
        return _to_return;
    };
    self.getWindowHtml       = function ( dom_tag, window_id, label, group_name, is_active ) {
        var _class_to_add = is_active ? "shinken-window-element shinken-active" : "shinken-window-element";
        var _to_return    = DOM.Service.createElement( dom_tag, {
            class            : _class_to_add,
            "data-group-name": group_name,
            "data-name"      : window_id,
            id               : "id-shinken-window-" + window_id
        }, label );
        return _to_return;
    };
    return self;
})( WINDOW.ElementService || {} );
WINDOW.Element           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.Element';
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.Element.prototype = {
    init          : function () {
        this.initDomElement();
        if ( this.is_menu ) {
            var _dom_element_counters = this.dom_element.querySelectorAll( '.shinken-counter' );
            this.counters             = {};
            var _current;
            for ( var i = 0, _size_i = _dom_element_counters.length; i < _size_i; i++ ) {
                _current                                      = _dom_element_counters[ i ];
                this.counters[ _current.dataset.counterType ] = new SHINKEN.OBJECT.Counter();
                this.counters[ _current.dataset.counterType ].init( _current );
            }
        }
        else {
            this.initCounters();
        }
    },
    initDomElement: function () {
        this.id = this.dom_element.getAttribute( 'id' );
        if ( this.is_menu ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.is_active = true;
        }
        this.dom_element_target = document.getElementById( this.id + '-target' );
        if ( !this.dom_element_target ) {
            console.warn( "[LA STRUCTURE HTML des windows n'est pas correcte]", this.id, this.id + '-target  ==> not found' );
        }
    },
    getName       : function () {
        return this.name;
    },
    getLabel                   : function () {
        return this.label || this.name;
    },
    getUUID         : function () {
        return this.id;
    },
    setHasRequired: function ( to_set ) {
        if ( to_set ) {
            this.dom_element.querySelector( '.shinken-required-field' ).classList.remove( 'shinken-hidden' );
        }
    },
    setActive     : function ( to_set ) {
        this.is_active = to_set;
        if ( this.is_active ) {
            this.dom_element.classList.add( 'shinken-active' );
            this.dom_element_target.classList.remove( 'shinken-hidden' );
        }
        else {
            this.dom_element.classList.remove( 'shinken-active' );
            this.dom_element_target.classList.add( 'shinken-hidden' );
        }
    },
    setDisabled     : function ( to_set ) {
        this.is_disabled = to_set;
        DOM.Service.addOrRemoveClasses(this.dom_element, this.is_disabled, "shinken-disabled");
    },
    hasProperties : function () {
        return false;
    },
    hasProblems                     : function (  ) {
        return !!(this.hasError() || this.hasWarning());
    },
    updateCounter : function ( name, value ) {
        this.counters[ name ].update( "counter", value );
    },
    getDataToSave: function () {
        return [];
    },
    cancelUserModification: function () {
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.Element, SHINKEN.OBJECT.CounterInterface );
WINDOW.ElementWithProperties           = function ( name, dom_element, is_menu ) {
    this.__class_name__ = 'WINDOW.ElementWithProperties';
    
    this.name        = name;
    this.dom_element = dom_element;
    this.is_menu     = !!is_menu;
    this.init();
};
WINDOW.ElementWithProperties.prototype = {
    hasProperties: function () {
        return true;
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( WINDOW.ElementWithProperties, WINDOW.Element );
