%rebase( "_tab_base", tab_info=tab_info)
%from shinkensolutions.api.synchronizer.http_lib_external.v01_00 import HTML_TYPE
% _colspan=7

<div class="shinken-list-container">
    <div id="id-shinken-host-template-binding-rules-messages">
        {{!validation_state}}
    </div>
    %include( "files-configuration", refresh_button=html_distributor.get_html(HTML_TYPE.BUTTON,'reload_rules'))
    <div class="shinken-fix-container">
        <table class="shinken-width-100 shinken-list-table">
            <thead>
                <tr class="shinken-header-line">
                    <th class="shinken-list-header shinken-action-cell"><div class="shinken-list-header-container">{{translate('host_template_binding_rules.header.counters')}}</div></th>
                    <th class="shinken-list-header shinken-cell-rules-user"><div class="shinken-list-header-container">{{translate('host_template_binding_rules.header.rules_user')}}</div></th>
                    <th class="shinken-list-header shinken-cell-number"><div class="shinken-list-header-container">{{translate('host_template_binding_rules.header.rules_index')}}</div></th>
                    <th class="shinken-list-header"><div class="shinken-list-header-container">{{translate('host_template_binding_rules.header.rule_name')}}</div></th>
                    <th class="shinken-list-header"><div class="shinken-list-header-container">{{translate('host_template_binding_rules.header.conditions')}}</div></th>
                    <th class="shinken-list-header"><div class="shinken-list-header-container">{{translate('host_template_binding_rules.header.templates')}}</div></th>
                    <th class="shinken-list-header shinken-cell-empty"><div class="shinken-list-header-container"></div></th>
                </tr>
                <tr class="shinken-empty-line"><td colspan="{{_colspan}}"></td></tr>
                <tr class="shinken-filter-line">
                    {{!html_distributor.get_html(HTML_TYPE.FILTER,'counters')}}
                    {{!html_distributor.get_html(HTML_TYPE.FILTER,'define_by')}}
                    {{!html_distributor.get_html(HTML_TYPE.FILTER,'index')}}
                    {{!html_distributor.get_html(HTML_TYPE.FILTER,'name')}}
                    {{!html_distributor.get_html(HTML_TYPE.FILTER,'conditions')}}
                    {{!html_distributor.get_html(HTML_TYPE.FILTER,'templates')}}
                </tr>
            </thead>
        </table>
    </div>
    <div class="shinken-scrollable-container">
        <table class="shinken-width-100 shinken-list-table">
            <tbody class="shinken-list-tbody">
            %for index, rule in enumerate(rules):
                <tr class="shinken-list-line" data-is-set-by-user="{{rule.from_user}}"
                    data-number-error="{{rule.error_counter_number}}"
                    data-number-warning="{{rule.warning_counter_number}}"
                    onmouseenter="MANAGER.EventManager.mouseEnter(event)"
                    onmouseleave="MANAGER.EventManager.mouseLeave(event)">
                    <td class="shinken-list-cell shinken-elements-cell shinken-action-cell" data-filter="counters" data-filter-value-array="{{rule.counter_filter}}">
                        <div class="shinken-list-cell-content" >{{!rule.errors_counter_html}}{{!rule.warnings_counter_html}}</div>
                    </td>
                    <td class="shinken-list-cell shinken-elements-cell shinken-cell-rules-user" data-filter="define_by" data-filter-value-array="{{rule.from_user}}">
                        <div class="shinken-list-cell-content">
                            <div class="shinken-label">{{common_translator.translate('common.%s' % rule.from_user)}}</div>
                        </div>
                    </td>
                    <td class="shinken-list-cell shinken-elements-cell shinken-cell-number" data-filter="index">
                        <div class="shinken-list-cell-content">{{rule.index+1}}</div>
                    </td>
                    <td class="shinken-list-cell shinken-elements-cell" data-filter="name">
                        <div class="shinken-list-cell-content">{{!rule.parse_name_to_html()}}</div>
                    </td>
                    <td class="shinken-list-cell shinken-elements-cell shinken-cell-conditions" data-filter="conditions">
                        <div class="shinken-list-cell-content">{{!rule.parse_condition_to_html()}}</div>
                    </td>
                    <td class="shinken-list-cell shinken-elements-cell shinken-cell-templates" data-filter="templates">
                        <div class="shinken-list-cell-content">{{!rule.parse_templates_to_html()}}</div>
                    </td>
                </tr>
            %end
            </tbody>
        </table>
    </div>
</div>
<div class="shinken-loading-after-refresh">
    <div class="shinken-loading-after-refresh-container">
        <h1>{{!translate('host_template_binding_rules.refresh_rules')}}</h1>
    </div>
</div>
%include( "host_template_binding_rules_help")