#!/usr/bin/python
# -*- coding: utf-8 -*-

# Copyright (C) 2019 :
#    Shinken solutions

from shinkensolutions.build_tools.js_merger.concatenation_config import ConcatenationConfig
from shinkensolutions.build_tools.js_merger.file import File

TARGET_FILES = [
    {
        'path'       : 'sources\\python3\\shinken-patched\\synchronizer\\htdocs\\js',
        'filter_type': 'equals',
        'filter'     : '__constante.js',
        'name'       : '__constante.js'
    },
    {
        'path'       : 'sources\\python3\\shinken-patched\\synchronizer\\htdocs\\js\\shinken',
        'filter_type': 'different',
        'filter'     : '__constante.js',
        'name'       : 'shinken_lib_general.js'
    },
    {
        'path'       : 'sources\\python3\\shinken-patched\\synchronizer\\htdocs\\js',
        'filter_type': 'has_lib',
        'filter'     : 'lib_external',
        'name'       : 'shinken_lib_external.js',
        'extra_path' : 'sources\\python3\\shinkensolutions\\api\\synchronizer\\http_lib_external\\v01_00\\js'
    },
    {
        'path'       : 'sources\\python3\\shinkensolutions\\common_ui\\htdocs\\js',
        'filter_type': 'has_lib',
        'filter'     : 'lib_common',
        'name'       : 'shinken_lib_common.js',
        'extra_path' : ['sources\\python3\\shinkensolutions\\common_ui\\htdocs\\js\\_lib',
                        'sources\\python3\\shinkensolutions\\api\\synchronizer\\http_lib_external\\v01_00\\js']
    },
    {
        'path'       : 'sources\\python3\\shinkensolutions\\common_ui\\htdocs\\js',
        'filter_type': 'has_lib',
        'filter'     : 'lib_shinken_V02_01',
        'name'       : 'shinken_lib_V02_01.js',
        'extra_path' : 'sources\\python3\\shinkensolutions\\common_ui\\htdocs\\js\\_lib'
    },
    {
        'path'       : 'sources\\python3\\shinken-patched\\synchronizer\\htdocs\\css\\shinken',
        'filter_type': 'all',
        'filter'     : '',
        'name'       : 'shinken_lib_general.css',
        'extra_path' : 'sources\\python3\\shinkensolutions\\api\\synchronizer\\http_lib_external\\v01_00\\css'
    },
    {
        'path'       : 'sources\\python3\\shinken-patched\\synchronizer\\htdocs\\css\\',
        'filter_type': 'contains',
        'filter'     : 'common',
        'name'       : '_common.css',
        'extra_path' : 'sources\\python3\\shinkensolutions\\api\\synchronizer\\http_lib_external\\v01_00\\css'
    },
    {
        'path'       : 'sources\\python3\\shinkensolutions\\common_ui\\htdocs\\css\\shinken',
        'filter_type': 'all',
        'filter'     : '',
        'name'       : 'shinken_common.css',
        # 'extra_path' : ['sources\\python3\\shinkensolutions\\common_ui\\htdocs\\css\\_lib']
        'extra_path' : ['sources\\python3\\shinkensolutions\\common_ui\\htdocs\\css\\_lib',
                        'sources\\python3\\shinkensolutions\\api\\synchronizer\\http_lib_external\\v01_00\\css']
    },
    {
        'path'       : 'sources\\python3\\modules\\webui_module_service_weather\\plugins\\service_weather\\htdocs\\js',
        'filter_type': 'has_lib',
        'filter'     : 'weather_without_edition',
        'name'       : '__shinken_without_edition__.js',
        'extra_path' : 'sources\\python3\\modules\\webui_module_service_weather\\plugins\\service_weather\\htdocs\\js\\_lib'
    },
    {
        'path'       : 'sources\\python3\\modules\\webui_module_service_weather\\plugins\\service_weather\\htdocs\\js',
        'filter_type': 'has_lib',
        'filter'     : 'weather_with_edition',
        'name'       : '__shinken_with_edition__.js',
        'extra_path' : 'sources\\python3\\modules\\webui_module_service_weather\\plugins\\service_weather\\htdocs\\js\\_lib'
    },
    {
        'path'       : 'sources\\python3\\modules\\webui_module_service_weather\\plugins\\service_weather\\htdocs\\css\\src',
        'filter_type': 'has_lib',
        'filter'     : 'weather_without_edition',
        'name'       : '__shinken_without_edition__.css',
        'extra_path' : 'sources\\python3\\modules\\webui_module_service_weather\\plugins\\service_weather\\htdocs\\css\\_lib'
    },
    {
        'path'       : 'sources\\python3\\modules\\webui_module_service_weather\\plugins\\service_weather\\htdocs\\css\\src',
        'filter_type': 'has_lib',
        'filter'     : 'weather_with_edition',
        'name'       : '__shinken_with_edition__.css',
        'extra_path' : 'sources\\python3\\modules\\webui_module_service_weather\\plugins\\service_weather\\htdocs\\css\\_lib'
    },
    {
        'path'       : 'sources\\python3\\shinkensolutions\\common_ui\\htdocs\\css\\shinken',
        'filter_type': 'has_lib',
        'filter'     : 'lib_common_for_angular_project',
        'name'       : 'shinken_lib_common_for_angular_project.css',
        'extra_path' : 'sources\\python3\\shinkensolutions\\common_ui\\htdocs\\css\\_lib'
    },
    {
        'path'       : 'sources\\python3\\modules\\webui\\plugins\\ui_visualisation\\htdocs\\js\\ui_panel',
        'filter_type': 'all',
        'filter'     : '',
        'name'       : 'shinken_lib_ui_visualisation_panel.js',
        'extra_path' : 'sources\\python3\\modules\\webui\\plugins\\ui_visualisation\\htdocs\\js\\_lib'
    },
    {
        'path'       : 'sources\\python3\\modules\\webui\\plugins\\ui_visualisation\\htdocs\\css\\ui_panel',
        'filter_type': 'all',
        'filter'     : '',
        'name'       : 'shinken_lib_ui_visualisation_panel.css',
        'extra_path' : 'sources\\python3\\modules\\webui\\plugins\\ui_visualisation\\htdocs\\css\\_lib'
    }
]


def load_files():
    for index, config in enumerate(TARGET_FILES):
        to_add = ConcatenationConfig(config)
        to_add.init_content()
        to_add.createFile()
        to_add.createExtraFile()


def parse_libs_to_false():
    parse_lib_to_false("sources\\python3\\shinken-patched\\synchronizer\\plugins\\elements\\views\\", "__shinken-lib.tpl")
    parse_lib_to_false("sources\\python3\\modules\\webui_module_service_weather\\plugins\\service_weather\\views", "_service_weather_head.tpl")
    parse_lib_to_false("sources\\python3\\modules\\webui\\plugins\\ui_visualisation\\views", "ui_panels.tpl")
    parse_lib_to_false("sources\\python3\\modules\\webui\\plugins\\ui_visualisation\\views\\", "ui_visualisation.tpl")


def parse_lib_to_false(path_lib, file_name):
    _file = File(path_lib, file_name)
    _file.load_lines()
    _file.lines[0] = "%is_dev = False"
    
    _file.save_content()


def merge_js_files():
    print('Copy pack:')
    load_files()
    parse_libs_to_false()
    # copy_files()
    print('Do uniq')
    # update_synchronizer_conf()
    print('Done')


if __name__ == '__main__':
    merge_js_files()
