"use strict";
SHINKEN.TOOLS.TEST_AUTO_COMMON_USER_INTERFACE_MENU = (function ( self ) {
    self.DOM                                 = {};
    self.TEST                                = {};
    var _INTERNAL                            = {};
    //********************************************  TEST   **************************************************//
    self.TEST.shinkenVersion                 = function ( timeout, logo_dom ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.tooltipLogo' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            var _timeout = _INTERNAL.getShinkenHealthCheckVersion();
            _timeout += _INTERNAL.validShinkenHealthCheckVersion( _timeout );
            _timeout += _INTERNAL.testTooltipLogo( _timeout, logo_dom );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  INTERNAL   **************************************************//
    _INTERNAL.getShinkenHealthCheckVersion   = function () {
        var _success = function ( _status, data ) {
            _INTERNAL.shinken_version = {};
            var to_parse              = data.stdout;
            to_parse                  = to_parse.replace( "shinken-healthcheck versions:", "" );
            to_parse                  = to_parse.split( "\n" );
            
            for ( var i = 0, size_i = to_parse.length; i < size_i; i++ ) {
                var _tmp = to_parse[ i ].split( ":" );
                if ( _tmp.length < 2 ) {
                    continue;
                }
                _INTERNAL.shinken_version[ SHINKEN.TOOLS.STRING.trimExtented( _tmp[ 0 ] ) ] = SHINKEN.TOOLS.STRING.trimExtented( _tmp[ 1 ] );
            }
        };
        var _error   = function ( e ) {
            SHINKEN.TOOLS.TEST_AUTO.addError( "getShinkenHealthCheckVersion a échoué avec l'erreur : " + e );
        };
        return SHINKEN.TOOLS.TEST_AUTO_SERVER_SERVICE.ACTION.executePostCommand( 0, "shinken-healthcheck --version", _success, _error );
        
    };
    _INTERNAL.validShinkenHealthCheckVersion = function ( timeout ) {
        setTimeout( function () {
            if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
                if ( !SHINKEN.TOOLS.STRING.contains( _INTERNAL.shinken_version[ "Updated patch" ], __version_shinken_app ) ) {
                    SHINKEN.TOOLS.TEST_AUTO.addError( "La version " + __version_shinken_app + " n'est pas la même dans la clé \"Updated patch\" du shinken-healthcheck" );
                }
            }
            if ( !SHINKEN.TOOLS.STRING.contains( _INTERNAL.shinken_version[ "Updated version" ], __version_shinken_app ) ) {
                SHINKEN.TOOLS.TEST_AUTO.addError( "La version " + __version_shinken_app + " n'est pas la même dans la clé \"Updated version\" du shinken-healthcheck" );
            }
        }, timeout );
        return 50;
    };
    _INTERNAL.testTooltipLogo                = function ( timeout, logo_dom ) {
        setTimeout( function () {
            var _timeout = SHINKEN.TOOLS.TEST_AUTO.dispatchMouseEvent( 0, logo_dom, 'mouseenter' );
            if ( __version_shinken === SHINKEN.TOOLS.TEST_AUTO.CONST.VERSION.BRAVO ) {
                _timeout += SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _INTERNAL.shinken_version[ "Updated patch" ] );
            }
            _timeout += SHINKEN.TOOLS.TEST_AUTO_TOOLTIP.TEST.containsText( _timeout, _INTERNAL.shinken_version[ "Updated version" ] );
        }, timeout );
        return 100;
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_COMMON_USER_INTERFACE_MENU || {} );
