SHINKEN.TOOLS.TEST_AUTO_APPLY = (function ( self ) {
    self.DOM                                   = {};
    self.ACTION                                = {};
    self.TEST                                  = {};
    self.CONST                                 = {
        STATE_DISPLAY     : {
            HIDDEN              : 0,
            VISIBLE             : 1,
            VISIBLE_AND_DISABLED: 2,
            LEFT_AND_RIGHT_PANEL: 3
        },
        PANEL_STATE       : {
            HIDDEN               : 0,
            VISIBLE              : 1,
            VISIBLE_WITH_ERROR   : 2,
            VISIBLE_WITHOUT_ERROR: 3
        },
        LIST_CONTENT_STATE: {
            HAS_LINE   : "HAS_LINE",
            USE_FILTER : "USE_FILTER",
            HAS_NO_LINE: "HAS_NO_LINE"
        },
        NAVIGATION_ARROWS : {
            FIRST   : 0,
            PREVIOUS: 1,
            NEXT    : 2,
            LAST    : 3
        }
    };
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getLeftColumn                     = function () {
        return document.getElementById( "id-shinken-left-column" );
    };
    self.DOM.getLeftPanelProblemContainerOK      = function () {
        return self.DOM.getLeftColumn().querySelector( "#checking-is-ok" );
    };
    self.DOM.getLeftPanelProblemContainerList      = function () {
        return self.DOM.getLeftColumn().querySelector( "#left-panel-error-content .shinken-list-container" );
    };
    self.DOM.getLeftPanelProblemClose          = function () {
        return self.DOM.getLeftColumn().querySelector( ".shinken-apply-cross-container span" );
    };
    self.DOM.getLeftPanelProblemAfterFilter    = function () {
        return self.DOM.getLeftPanelProblemContainerList().querySelector( ".shinken-active-if-has-filter" );
    };
    self.DOM.getLeftPanelProblemNoLines        = function () {
        return self.DOM.getLeftPanelProblemContainerList().querySelector( ".shinken-list-no-lines" );
    };
    self.DOM.getLeftPanelProblemCounterError   = function () {
        return self.DOM.getLeftColumn().querySelector( "#id-shinken-set-apply-msg-error" );
    };
    self.DOM.getLeftPanelProblemCounterWarning = function () {
        return self.DOM.getLeftColumn().querySelector( "#id-shinken-set-apply-msg-warning" );
    };
    self.DOM.getElementById                    = function ( id ) {
        return document.getElementById( id );
    };
    self.DOM.getElement                        = function ( class_element ) {
        return document.querySelector( class_element );
    };
    self.DOM.getRightColumn                    = function () {
        return document.getElementById( "apply-right-block" );
    };
    self.DOM.getCheckButton                    = function () {
        return self.DOM.getLeftColumn().querySelector( "#check-btn" );
    };
    self.DOM.getApplyButton                    = function () {
        return self.DOM.getLeftColumn().querySelector( "#restart-btn" );
    };
    self.DOM.getGrowLeftPanelButton            = function () {
        return document.querySelector( ".shinkon-double-chevron-right" );
    };
    self.DOM.getShrinkLeftPanelButton          = function () {
        return document.querySelector( ".shinkon-double-chevron-left" );
    };
    self.DOM.getCheckIsOkPanel                 = function () {
        return self.DOM.getLeftColumn().querySelector( "#checking-is-ok" );
    };
    self.DOM.getPagination                     = function () {
        return self.DOM.getLeftColumn().querySelector( ".shinken-pagination" );
    };
    self.DOM.getTotalPagination                = function () {
        return self.DOM.getPagination().querySelector( ".shinken-total-pagination .shinken-value" );
    };
    self.DOM.getPaginationSelector             = function () {
        return self.DOM.getPagination().querySelector( ".shinken-select-selector" );
    };
    self.DOM.getPaginationSelectorLabel        = function () {
        return self.DOM.getPagination().querySelector( ".shinken-selector-label" );
    };
    self.DOM.getPaginationSelectorArrows       = function () {
        return self.DOM.getPagination().querySelectorAll( ".shinken-pagination-arrow-content" );
    };
    self.DOM.getModifiedListElement            = function () {
        return self.DOM.getRightColumn().querySelector( "#apply-right-block-changed" );
    };
    self.DOM.getModifiedElement                = function ( uuid_element ) {
        return self.DOM.getModifiedListElement().querySelector( ".shinken-li-element[data-uuid-element='" + uuid_element + "']" );
    };
    self.DOM.getModifiedElementLastUser        = function ( uuid_element ) {
        return self.DOM.getModifiedElement( uuid_element ).querySelector( ".shinken-info" );
    };
    self.DOM.getDeletedListElement             = function () {
        return self.DOM.getRightColumn().querySelector( "#apply-right-block-removed" );
    };
    self.DOM.getDeletedElement                 = function ( uuid_element ) {
        return self.DOM.getDeletedListElement().querySelector( ".shinken-li-element[data-uuid-element='" + uuid_element + "']" );
    };
    self.DOM.getDeletedElementLastUser         = function ( uuid_element ) {
        return self.DOM.getDeletedElement( uuid_element ).querySelector( ".shinken-info" );
    };
    self.DOM.modifiedElementProperty           = function ( uuid_element, property_name ) {
        return self.DOM.getModifiedElement( uuid_element ).querySelector( "[data-property-name='" + property_name + "']" );
    };
    self.DOM.modifiedElementPropertyLabel      = function ( uuid_element, property_name ) {
        return self.DOM.modifiedElementProperty( uuid_element, property_name ).querySelector( ".shinken-property-name-cell" );
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.askVerifyApply                 = function ( timeout, force_click ) {
        var _to_return = 4000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.askVerifyApply', " clic sur le bouton vérifier" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( timeout, SHINKEN.TOOLS.TEST_AUTO_APPLY.DOM.getCheckButton(), force_click );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnPaginationSelectButton  = function ( timeout ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnPaginationSelectButton', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getPaginationSelector() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnExecuteApplyIfNeeded    = function ( timeout ) {
        setTimeout( function () {
            var _button = self.DOM.getApplyButton();
            if ( !_button.classList.contains( "btn-disabled" ) ) {
                __do_next = false;
                self.ACTION.clickOnExecuteApply( 0 );
            }
        }, timeout );
        return 2000;
    };
    self.ACTION.clickOnExecuteApply            = function ( timeout ) {
        __do_next = false;
        setTimeout( function () {
            var _button = self.DOM.getApplyButton();
            SHINKEN.TOOLS.TEST_AUTO.__isVisible( _button, '' );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                really_click_on_restart_configuration();
            }
            else {
                SHINKEN.TOOLS.TEST_AUTO.addError( "Le test comporte des erreurs, la dernière action n'a pas été faites" );
            }
            if ( __test_auto_continue_if_error || !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
            }
        }, timeout );
        return 2000;
    };
    self.ACTION.clickOnCloseListProblem        = function ( timeout ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnCloseListProblem', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getLeftPanelProblemClose() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.filterErrorPanel               = function ( timeout, filter_name, filter_value ) {
        var _to_return = 250;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.filterErrorPanel', filter_name + " : " + filter_value );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            __do_log__ = false;
            SHINKEN.TOOLS.TEST_AUTO_LIST.ACTION.filter( 0, self.DOM.getLeftPanelProblemContainerList(), filter_name, filter_value );
            __do_log__ = true;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  TEST   **************************************************//
    self.TEST.checkResultContainsText          = function ( timeout, text ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'checkResultContainsText', text );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.DOM.getLeftPanelProblemContainerOK(), text, 'checkResultContainsText' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.checkProblemContainsText         = function ( timeout, text ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'checkResultContainsText', text );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.DOM.getCheckIsOkPanel(), text, 'checkResultContainsText' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.lastModifiedUser                 = function ( timeout, uuid_element, user_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.lastModifiedUser', user_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.DOM.getModifiedElementLastUser( uuid_element ), user_name, 'lastModifiedUser' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.deletingUser                     = function ( timeout, uuid_element, user_name ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.deletingUser', user_name );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.containsText( 0, self.DOM.getDeletedElementLastUser( uuid_element ), user_name, 'lastModifiedUser' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.displayState                     = function ( timeout, dom_id, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayState', state, dom_id );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getElementById( dom_id ) || self.DOM.getElement( dom_id );
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, dom_id );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "1" );
                    break;
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, dom_id );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_DISABLED:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, dom_id );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "cursor", "not-allowed" );
                    SHINKEN.TOOLS.TEST_AUTO.__hasStyle( _dom, "opacity", "0.65" );
                    break;
                case self.CONST.STATE_DISPLAY.LEFT_AND_RIGHT_PANEL:
                    SHINKEN.TOOLS.TEST_AUTO_PAGINATION.ACTION.moveCentralSlider( 0, self.DOM.getLeftColumn() );
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.problemState                     = function ( timeout, state ) {
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.problemState', state );
        var _to_return = 500;
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( state ) {
                case self.CONST.PANEL_STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 250, self.DOM.getLeftPanelProblemCounterError(), "counter error in title" );
                    //SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 250, self.DOM.getLeftPanelProblemCounterWarning(), "warning error in title" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 250, self.DOM.getLeftPanelProblemContainerList(), "Error list" );
                    break;
                case self.CONST.PANEL_STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 250, self.DOM.getLeftPanelProblemCounterError(), "counter error in title" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 250, self.DOM.getLeftPanelProblemCounterWarning(), "warning error in title" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 250, self.DOM.getLeftPanelProblemContainerList(), "Error list" );
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
            
        }, timeout );
        return _to_return;
    };
    
    self.TEST.panelProblemState = function ( timeout, state ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.panelProblemState', state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( state ) {
                case self.CONST.LIST_CONTENT_STATE.HAS_NO_LINE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.DOM.getLeftPanelProblemAfterFilter(), "After filter text" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, self.DOM.getLeftPanelProblemNoLines(), "No lines text" );
                    break;
                case self.CONST.LIST_CONTENT_STATE.HAS_LINE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, self.DOM.getLeftPanelProblemAfterFilter(), "After filter text" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, self.DOM.getLeftPanelProblemNoLines(), "No lines text" );
                    break;
                case self.CONST.LIST_CONTENT_STATE.USE_FILTER:
                    SHINKEN.TOOLS.TEST_AUTO_FILTERS.TEST.allSelectHideOrShow( 9000, self.DOM.getLeftColumn(), 2 );
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    self.TEST.totalPagePagination = function ( timeout, value_expected ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.finalPagePagination', value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.getTotalPagination(), value_expected );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.USE_ARROWS        = function ( timeout, state ) {
        var _to_return = 6100;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.PaginationState', state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_PAGINATION.ACTION.paginationUseArrows( 0, self.DOM.getPagination(), SHINKEN.TOOLS.TEST_AUTO_PAGINATION.CONST.STATE_PAGINATION.FIRST );
            SHINKEN.TOOLS.TEST_AUTO_PAGINATION.ACTION.paginationUseArrows( 1000, self.DOM.getPagination(), SHINKEN.TOOLS.TEST_AUTO_PAGINATION.CONST.STATE_PAGINATION.MIDDLE );
            SHINKEN.TOOLS.TEST_AUTO_PAGINATION.ACTION.paginationUseArrows( 2000, self.DOM.getPagination(), SHINKEN.TOOLS.TEST_AUTO_PAGINATION.CONST.STATE_PAGINATION.LAST );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.labelProperty       = function ( timeout, uuid_element, property_name, label ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.PaginationState', label );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.modifiedElementPropertyLabel( uuid_element, property_name ), label );
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_APPLY || {} );

//@override
function form_restart_success () {
    SHINKEN.HIGHWAY.refreshCurrentPage();
}
