"use strict";
SHINKEN.TOOLS.TEST_AUTO_WEATHER_CHECKS = (function ( self ) {
    self.TEST = {};
    self.DOM  = {};
    
    //********************************************  DOM  **************************************************//
    self.DOM.getLongOutputTables = function ( id_host, id_check ) {
        var tryCheckOutput = SHINKEN.TOOLS.TEST_AUTO_CHECK_TAB.getTryCheckLongOutput( id_host, id_check );
        return tryCheckOutput.querySelectorAll( "table .skn-ict" );
    };
    
    //********************************************  TEST  **************************************************//
    self.TEST.validMostPopularWeatherTable      = function ( timeout, table, expected_nb_rows, expected_nb_cols ) {
        var _to_return = 0;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.validMostPopularWeatherTable', name );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.isTable( _to_return, table, expected_nb_rows, expected_nb_cols );
            _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.TEST.validTableHeaders( _to_return, table, ["Service weather title", "Issues", "Total requests", "Weather widgets"] );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.TEST.validMostConsumingWeatherTable    = function ( timeout, table, expected_nb_rows, expected_nb_cols ) {
        var _to_return = 0;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.validMostConsumingWeatherTable', name );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.isTable( _to_return, table, expected_nb_rows, expected_nb_cols );
            _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.TEST.validTableHeaders( _to_return, table, ["Service weather title", "Time taken in 60 seconds intervals ( Calculation interval ) ( in seconds )", "Average ( in seconds )", "Weather widgets"] );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.TEST.validTimeUsedByCacheTable         = function ( timeout, table, expected_nb_rows, expected_nb_cols ) {
        var _to_return = 0;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.validTimeUsedByCacheTable', name );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.isTable( _to_return, table, expected_nb_rows, expected_nb_cols );
            _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.TEST.validTableHeaders( _to_return, table, ["", "0s - 0.2s", "0.2s - 0.4s", "0.4s - 0.6s", "0.6s - 0.8s", "0.8s - 1s", "1s - 1.5s", "+1.5s"] );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.TEST.validWeatherWithMostIssues        = function ( timeout, table, expected_nb_rows, expected_nb_cols ) {
        var _to_return = 0;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.validWeatherWithMostIssues', name );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.isTable( _to_return, table, expected_nb_rows, expected_nb_cols );
            _to_return += SHINKEN.TOOLS.TEST_AUTO_DOM.TEST.validTableHeaders( _to_return, table, ["Service weather title", "Issues", "Weather widgets"] );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.TEST.validWeatherRunningWellLongOutput = function ( timeout, id_host, id_check, expected_nb_table ) {
        var _to_return = 0;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.validWeatherRunningWellLongOutput', name );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var tables = self.DOM.getLongOutputTables( id_host, id_check );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( tables.length, expected_nb_table, "Nombre de tableaux dans le résultat long" );
            _to_return += self.TEST.validMostPopularWeatherTable( _to_return, tables[ 0 ].querySelector( "table" ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    self.TEST.validWeatherPerformanceLongOutput = function ( timeout, id_host, id_check, expected_nb_tables ) {
        var _to_return = 0;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.validWeatherPerformanceLongOutput', name );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            
            var tables = self.DOM.getLongOutputTables( id_host, id_check );
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( tables.length, expected_nb_tables, "Nombre de tableaux dans le résultat long" );
            _to_return += self.TEST.validMostConsumingWeatherTable( _to_return, tables[ 0 ], 4, 4 );
            _to_return += self.TEST.validTimeUsedByCacheTable( _to_return, tables[ 1 ], 3, 8 );
            _to_return += self.TEST.validWeatherWithMostIssues( _to_return, tables[ 2 ], 4, 3 );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_WEATHER_CHECKS || {} );