SHINKEN.TOOLS.TEST_AUTO_UI_VISU_ANGULAR = (function ( self ) {
    self.DOM                   = {};
    self.TEST                  = {};
    self.ACTION                = {};
    self.CONST                 = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe         = function () {
        SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).window.onerror = function () {
            _has_script_error++;
        };
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.helpButton            = function () {
        return self.DOM.getIframe().querySelector( "#table-help-btn" );
    };
    self.DOM.helpContainer           = function () {
        return self.DOM.getIframe().querySelector( ".help-container" );
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.displayHelp               = function ( timeout, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'PROPERTY_INFORMATION.TEST.display_', state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom  = self.DOM.helpContainer();
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_ANGULAR_CONST.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, "help container" );
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_ANGULAR_CONST.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, "help container" );
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.clickOnHelpButton = function ( timeout ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickHelp', "" );
        
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.helpButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        
        return _to_return;
    };
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_ANGULAR || {} );

SHINKEN.TOOLS.TEST_AUTO_UI_VISU_ANGULAR_CONST = {
    STATE                   : {
        HIDDEN      : 0,
        VISIBLE     : 1
    }
};