"use strict";

SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU = (function ( self ) {
    self.DOM         = {};
    self.TEST        = {};
    self.TEST.WIDGET = {};
    self.TEST.JS     = {};
    self.ACTION      = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    
    self.DOM.getMenu                                 = function ( navigator ) {
        var _document = navigator ? navigator.document : document;
        return _document.querySelector( ".shinken-main-nav-bar-table" );
    };
    self.DOM.getUserConfigurationButton              = function () {
        return self.DOM.getMenu().querySelector( "#id-shinken-logout-button" );
    };
    self.DOM.getLoginButtonLabel                     = function () {
        return self.DOM.getUserConfigurationButton().querySelector( ".shinken-user-name" );
    };
    self.DOM.getPopupConfigurationUser               = function ( navigator ) {
        var _document = navigator ? navigator.document : document;
        return _document.querySelector( ".shinken-dropdown-container-user-configuration" );
    };
    self.DOM.getDisconnectButton                     = function ( navigator ) {
        return self.DOM.getPopupConfigurationUser( navigator ).querySelector( "#id-shinken-user-disconnect-button" );
    };
    self.DOM.userConfigurationRadioListPropertyBlink = function ( navigator ) {
        return self.DOM.getPopupConfigurationUser( navigator ).querySelector( ".shinken-tbody-for-blink" );
    };
    self.DOM.userConfigurationRangePropertyVolume    = function ( navigator ) {
        return self.DOM.getPopupConfigurationUser( navigator ).querySelector( ".shinken-tbody-for-volume" );
    };
    self.DOM.userConfigurationRadioButtonByName      = function ( navigator, property_name, value ) {
        switch ( property_name ) {
            case "blink":
                return self.DOM.userConfigurationRadioListPropertyBlink( navigator ).querySelector( ".shinken-radio-element[data-name='radio-element-notification-blink'][data-value='" + value + "']" );
            case "volume":
                return self.DOM.userConfigurationRadioListPropertyBlink( navigator ).querySelector( ".shinken-radio-element[data-name='radio-element-notification-sound'][data-value='']" );
        }
    };
    self.DOM.userConfigurationRangeVolume            = function ( navigator ) {
        return self.DOM.userConfigurationRangePropertyVolume( navigator ).querySelector( ".shinken-notification-slider-sound" );
    };
    self.DOM.getNavigationMenuCell                   = function ( menu_name, navigator ) {
        var _selector = "";
        switch ( menu_name ) {
            case SHINKEN.SCREEN.TYPE.HIVE:
                _selector = ".shinken-portal-menu-cell";
                break;
            case SHINKEN.SCREEN.TYPE.LIST:
                _selector = ".shinken-list-menu-cell";
                break;
            case SHINKEN.SCREEN.TYPE.EVENT:
                _selector = ".shinken-event-menu-cell";
                break;
            case SHINKEN.SCREEN.TYPE.SERVICE_WEATHER:
                _selector = ".shinken-weather-menu-cell";
                break;
            case "shinken-extra-menu-cell":
                _selector = ".shinken-extra-menu-cell";
                break;
            case "shinken-collapsed-menu-cell":
                _selector = ".shinken-collapsed-menu-cell";
                break;
        }
        return self.DOM.getMenu( navigator ).querySelector( _selector );
    };
    self.DOM.getNavigationMenu                       = function ( menu_name, navigator ) {
        return self.DOM.getNavigationMenuCell( menu_name, navigator ).querySelector( ".dropdown-toggle" );
    };
    self.DOM.getNavigationSubMenu                    = function ( menu_name, sub_menu_name, navigator ) {
        return self.DOM.getNavigationMenuCell( menu_name, navigator ).querySelector( '.shinken-link[data-name="' + sub_menu_name + '"]' );
    };
    self.DOM.getNavigationCounters                   = function ( menu_name ) {
        var _doms      = self.DOM.getNavigationMenu( menu_name ).querySelectorAll( ".shinken-counter" );
        var _to_return = {};
        for ( var i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
            if ( _doms[ i ].classList.contains( "shinken-error-counter" ) ) {
                _to_return[ "shinken-error-counter" ] = _doms[ i ];
            }
            else {
                _to_return[ "to_complete" ] = _doms[ i ];
            }
        }
        return _to_return;
    };
    self.DOM.logoCell                                = function () {
        return self.DOM.getMenu().querySelector( ".shinken-logo-cell" );
    };
    self.DOM.logoVersion                             = function () {
        return self.DOM.logoCell().querySelector( ".shinken-version-number" );
    };
    self.DOM.getAddToFavoriteButton                  = function () {
        return self.DOM.getMenu().querySelector( ".shinken-add-favorite-container" );
    };
    
    //********************************************  GETTER   **************************************************//
    
    
    //********************************************   TEST   ***************************************************//
    
    self.TEST.userNameLabel = function ( timeout, value_expected ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.userNameLabel', value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO.__isInnerTextEqualTo( self.DOM.getLoginButtonLabel(), value_expected, 'userNameLabel' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.activeView    = function ( timeout, value_expected, navigator_container ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.activeView', value_expected );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var navigator   = navigator_container ? navigator_container.instance : null;
            var _controller = navigator ? navigator.CONTROLLER.UiVisualisation : CONTROLLER.UiVisualisation;
            SHINKEN.TOOLS.TEST_AUTO.___isEqualsTo( _controller.active_view, value_expected, 'activeView' );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.displayState  = function ( timeout, state, navigator_container ) {
        var _to_return = 600;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.displayState', state );
        setTimeout( function () {
            var navigator = navigator_container ? navigator_container.instance : null;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getMenu( navigator );
            switch ( state ) {
                case self.CONST.STATE_DISPLAY.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 250, _dom );
                    SHINKEN.TOOLS.TEST_AUTO.__hasClass( _dom, 'shinken-navbar-collapsed-menu-activated', "menu", undefined, true );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 250, self.DOM.getNavigationMenuCell( "shinken-collapsed-menu-cell", navigator ) );
                    break;
                case self.CONST.STATE_DISPLAY.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 250, _dom, _dom );
                    break;
                case self.CONST.STATE_DISPLAY.VISIBLE_AND_COLLAPSE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 250, _dom );
                    SHINKEN.TOOLS.TEST_AUTO.__hasClass( _dom, 'shinken-navbar-collapsed-menu-activated', "menu" );
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 250, self.DOM.getNavigationMenuCell( "shinken-collapsed-menu-cell", navigator ) );
                    break;
                default:
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.counter       = function ( timeout, menu_name, nb_error, nb_warning, nb_total, nb_user ) {
        setTimeout( function () {
            var _counters = self.DOM.getNavigationCounters( menu_name );
            if ( nb_error !== undefined ) {
                SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _counters[ "shinken-error-counter" ], nb_error );
            }
            //TODO
            //if ( nb_warning !== undefined ) {
            //    SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 2 ], nb_warning );
            //}
            //if ( nb_total !== undefined ) {
            //    SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 3 ], nb_total );
            //}
            //if ( nb_user !== undefined ) {
            //    SHINKEN.TOOLS.TEST_AUTO_COMPONENT.TEST.hasCounterValue( 0, _window[ 4 ], nb_user );
            //}
        }, timeout );
        return 100;
    };
    
    
    
    self.ACTION.logout                            = function ( timeout ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.logout', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            if ( !SHINKEN.TOOLS.TEST_AUTO.hasMessage() ) {
                SHINKEN.HIGHWAY.changeUrl( SHINKEN.TOOLS.TEST_AUTO_PHASE.getNextPhaseLink() );
                SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getDisconnectButton() );
            }
            
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.openUserConfiguration             = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.openUserConfiguration', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getUserConfigurationButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.setValueUserConfigurationProperty = function ( timeout, property_name, value ) {
        var _to_return = 250;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.setValueUserConfigurationProperty', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            switch ( property_name ) {
                case "blink":
                    SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.userConfigurationRadioButtonByName( null, property_name, value ) );
                    break;
                case "volume":
                    if ( value === "default" ) {
                        
                        SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.userConfigurationRadioButtonByName( null, property_name, value ) );
                    }
                    else {
                        CONTROLLER.NavigationBar.dropdown_configuration_user.property_volume.setValueFromUser( value );
                        CONTROLLER.UiVisualisation.doActionAfter( "change_value_notification_of_change_sound", value );
                    }
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnMenu                       = function ( timeout, menu_name, navigator_container ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnMenu', menu_name );
        setTimeout( function () {
            var navigator = navigator_container ? navigator_container.instance : null;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getNavigationMenu( menu_name, navigator ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnSubMenu                    = function ( timeout, menu_name, sub_menu_name, navigator_container ) {
        var _to_return = 3000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnSubMenu', menu_name + " => " + sub_menu_name );
        setTimeout( function () {
            var navigator = navigator_container ? navigator_container.instance : null;
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 0, self.DOM.getNavigationSubMenu( menu_name, sub_menu_name, navigator ) );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    
    //********************************************  CONSTANT **************************************************//
    self.CONST = {
        STATE_DISPLAY       : {
            HIDDEN              : 0,
            VISIBLE             : 1,
            VISIBLE_AND_COLLAPSE: 2,
            LOCKED              : 3
        },
        ADD_TO_FAVORITE_FORM: {
            FAVORITE_TYPE   : {
                LINK: "create_link",
                COPY: "create_copy"
            },
            FAVORITE_SECTION: {
                GLOBAL : "global",
                GROUP  : "group",
                PRIVATE: "personal"
            }
        }
    };
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU || {} );


//"use strict";

SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU.ADD_TO_FAVORITE_FORM = (function ( self ) {
    self.DOM         = {};
    self.TEST        = {};
    self.TEST.WIDGET = {};
    self.TEST.JS     = {};
    self.ACTION      = {};
    
    //********************************************  CONSTANT **************************************************//
    self.CONST = {
        STATE_DISPLAY       : {
            HIDDEN              : 0,
            VISIBLE             : 1,
            VISIBLE_AND_COLLAPSE: 2,
            LOCKED              : 3
        },
        ADD_TO_FAVORITE_FORM: {
            FAVORITE_TYPE   : {
                LINK: "create_link",
                COPY: "create_copy"
            },
            FAVORITE_SECTION: {
                GLOBAL : "global",
                GROUP  : "group",
                PRIVATE: "personal"
            }
        }
    };
    
    //******************************************************************************************************************//
    //********************************************  GET DOM ELEMENT   **************************************************//
    //******************************************************************************************************************//
    
    
    //****************************************  SHARE LIST  *********************************************//
    
    self.DOM.getAngularIframe       = function () {
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-iframe-for-ui-visualisation" ).document;
    };
    self.DOM.getPrivateFavoriteList = function () {
        return self.DOM.getAngularIframe().querySelectorAll( ".share-tree[data-shareset='personal'] .share-element-container:not(.empty-list)" );
    };
    self.DOM.getGroupFavoriteList   = function () {
        return self.DOM.getAngularIframe().querySelectorAll( ".panel-group .group .share-element-container:not(.empty-list)" );
    };
    self.DOM.getGlobalFavoriteList  = function () {
        return self.DOM.getAngularIframe().querySelectorAll( ".share-tree[data-shareset='global'] .share-element-container:not(.empty-list)" );
    };
    self.DOM.getFavoriteList        = function ( favorite_space_name ) {
        switch ( favorite_space_name ) {
            case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.EVERYONE:
                return self.DOM.getGlobalFavoriteList();
            case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS:
                return self.DOM.getGroupFavoriteList();
            case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE:
                return self.DOM.getPrivateFavoriteList();
        }
    };
    
    
    //***********************************  ADD TO FAVORITE FORM  ****************************************//
    
    self.DOM.getAddToFavoriteDropDown          = function () {
        return document.querySelector( ".shinken-add-favorite-drop-down" );
    };
    self.DOM.getAddToFavoriteDropDownContainer = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( ".shinken-add-favorite-dropdown-container" );
    };
    self.DOM.getAddToFavoriteCreateALink       = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( "#id-shinken-window-create_linkadd-to-favorite-window-group" );
    };
    self.DOM.getAddToFavoriteCreateACopy       = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( "#id-shinken-window-create_copyadd-to-favorite-window-group" );
    };
    self.DOM.getAddToFavoriteTypeButton        = function ( favorite_type ) {
        switch ( favorite_type ) {
            case WINDOW.ADD_TO_FAVORITE.TABS.CREATE_LINK:
                return self.DOM.getAddToFavoriteCreateALink();
                break;
            case WINDOW.ADD_TO_FAVORITE.TABS.CREATE_COPY:
                return self.DOM.getAddToFavoriteCreateACopy();
                break;
            default:
                console.error( "[SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU.DOM.getAddToFavoriteSectionButton] Invalid section name:", section_name );
                return null;
                break;
        }
    };
    
    self.DOM.getAddToFavoriteNameInput       = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( ".shinken-add-favorite-dropdown-container .shinken-form-container .shinken-input-container .shinken-input" );
    };
    self.DOM.getAddToFavoriteNameInputDelete = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( ".shinken-add-favorite-dropdown-container .shinken-form-container .shinken-input-container .shinken-icon-delete-input" );
    };
    
    self.DOM.getAddToFavoriteGlobalButton  = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( ".shinken-btn-group-table .shinken-btn-user-cell .shinken-radio-btn[value='global']" );
    };
    self.DOM.getAddToFavoriteGroupButton   = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( ".shinken-btn-group-table .shinken-btn-user-cell .shinken-radio-btn[value='group']" );
    };
    self.DOM.getAddToFavoritePrivateButton = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( ".shinken-btn-group-table .shinken-btn-user-cell .shinken-radio-btn[value='personal']" );
    };
    self.DOM.getAddToFavoriteSectionButton = function ( section_name ) {
        switch ( section_name ) {
            case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.EVERYONE:
                return self.DOM.getAddToFavoriteGlobalButton();
            case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.GROUPS:
                return self.DOM.getAddToFavoriteGroupButton();
            case SHINKEN.UI.SHARE.PARAM.TYPE.VALUE.PRIVATE:
                return self.DOM.getAddToFavoritePrivateButton();
            default:
                console.error( "[SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU.DOM.getAddToFavoriteSectionButton] Invalid section name:", section_name );
                return null;
        }
    };
    
    self.DOM.getAddToFavoriteSelector = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( ".shinken-select-selector" );
    };
    self.DOM.getSelectGroupOption     = function ( group_name ) {
        const _querySelector = ".shinken-list-select .shinken-option[data-key-label=" + group_name + "]";
        return self.DOM.getAddToFavoriteDropDown().querySelector( _querySelector );
    };
    
    self.DOM.getAddToFavoriteValidateButton = function () {
        return self.DOM.getAddToFavoriteDropDown().querySelector( ".shinken-table-form-content .shinken-form-action-cell .shinken-validate-form" );
    };
    
    
    
    //*********************************************************************************************************//
    //********************************************  GETTER   **************************************************//
    //*********************************************************************************************************//
    
    
    //*********************************************************************************************************//
    //********************************************   TEST   ***************************************************//
    //*********************************************************************************************************//
    
    
    //***********************************  ADD TO FAVORITE FORM  ****************************************//
    
    self.TEST.displayState = function ( dom, state ) {
        switch ( state ) {
            case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.VISIBLE:
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, dom );
                break;
            case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.HIDDEN:
                SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, dom );
                break;
            case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.VISIBLE_BUT_DISABLE:
                SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, dom, "opacity", "0.5" );
                SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, dom, "pointer-events", "none" );
                SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, dom );
                break;
            case SHINKEN.TOOLS.TEST_AUTO.CONST.DISPLAY_STATE.VISIBLE_WITH_ERROR:
                SHINKEN.TOOLS.TEST_AUTO_DOM.hasStyle( 0, dom, "background-color", "rgb(236, 87, 87)" );
                break;
        }
    };
    
    self.TEST.nameInput__DisplayState     = function ( timeout, state ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.SectionButtonVisibilityState' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.getAddToFavoriteNameInput();
            self.TEST.displayState( _dom, state );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.sectionButton__DisplayState = function ( timeout, button_name, state ) {
        var _to_return = 2000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.SectionButtonVisibilityState' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            let _dom = self.DOM.getAddToFavoriteSectionButton( button_name );
            self.TEST.displayState( _dom, state );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.tabLink__DisplayState       = function ( timeout, state ) {
        var _to_return = 1500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.tabLink__DisplayState' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            self.TEST.displayState( self.DOM.getAddToFavoriteCreateALink(), state );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.TEST.tabCopy__DisplayState       = function ( timeout, state ) {
        var _to_return = 1500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.SectionButtonVisibilityState' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            self.TEST.displayState( self.DOM.getAddToFavoriteCreateACopy(), state );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    
    //*****************************************  SHARE LIST  *********************************************//
    
    self.TEST.validateNumbersOfFavorite = function ( timeout, dom_element, expected_number_of_favorites ) {
        var _to_return = 1500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.validateNumbersOfFavorite' );
        setTimeout( function () {
            let _dom = self.DOM.getFavoriteList( dom_element );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.TEST.validateNumbersOfFavorite( timeout, _dom, expected_number_of_favorites );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    //*********************************************************************************************************//
    //********************************************  ACTION   **************************************************//
    //*********************************************************************************************************//
    
    
    //***********************************  ADD TO FAVORITE FORM  ****************************************//
    
    self.ACTION.clickOnAddFavoriteMenu  = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAddFavoriteMenu' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU.DOM.getAddToFavoriteButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnAddFavorite      = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnAddFavorite' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getAddToFavoriteButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.navigate                = function ( timeout, favorite_type ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.navigate' );
        setTimeout( function () {
            let _dom = self.DOM.getAddToFavoriteTypeButton( favorite_type );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, _dom );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnFavoriteSection  = function ( timeout, section_name, force_click ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnFavoriteSection' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getAddToFavoriteSectionButton( section_name ), force_click );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnFavoriteGroup    = function ( timeout, force_click ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnFavoriteGroup' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getAddToFavoriteSelector(), force_click );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.selectGroup             = function ( timeout, group_name, force_click ) {
        var _to_return = 1000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.selectGroup' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.mouseup( 0, self.DOM.getSelectGroupOption( group_name ), force_click );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.clickOnFavoriteValidate = function ( timeout ) {
        var _to_return = 5000;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.clickOnFavoriteValidate' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getAddToFavoriteValidateButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.deleteCopyShareName     = function ( timeout ) {
        var _to_return = 500;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.DeleteCopyShareName' );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getAddToFavoriteNameInputDelete() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    
    
    
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_MENU.ADD_TO_FAVORITE_FORM || {} );
