"use strict";
SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANELS = (function ( self ) {
    self.DOM                       = {};
    self.TEST                      = {};
    self.ACTION                    = {};
    self.CONST                     = {};
    //********************************************  GET DOM ELEMENT   **************************************************//
    self.DOM.getIframe     = function () {
        return SHINKEN.TOOLS.IFRAME.getIframeJs( "#id-shinken-ui-view-manager" ).document;
    };
    self.DOM.getModalForPanels     = function () {
        return document.querySelector("#id-shinken-window-modal.shinken-modal-view-panel");
    };
    self.DOM.getModalForPanelsCloseButton     = function () {
        return self.DOM.getModalForPanels().querySelector(".shinken-cross-container-to-close-modal");
    };
    self.DOM.getButtonCancelUserAction     = function () {
        return self.DOM.getIframe().querySelector(".shinken-window-group-save-cancel-button");
    };
    self.DOM.getButtonApplyUserAction     = function () {
        return self.DOM.getIframe().querySelector(".shinken-window-group-save-apply-button");
    };
    //********************************************  GETTER   **************************************************//
    
    //********************************************  TEST   **************************************************//
    self.TEST.statePanelsModal = function ( timeout, state ) {
        var _to_return = 50;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'TEST.statePanelsModal', state );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            var _dom = self.DOM.getModalForPanels();
            switch ( state ) {
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANELS_CONST.STATE.HIDDEN:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isNotVisible( 0, _dom, "TEST.statePanelsModal HIDDEN" ) ;
                    break;
                case SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANELS_CONST.STATE.VISIBLE:
                    SHINKEN.TOOLS.TEST_AUTO_DOM.isVisible( 0, _dom, "TEST.statePanelsModal VISIBLE" ) ;
                    break;
            }
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    //********************************************  ACTION   **************************************************//
    self.ACTION.closePanelsModal = function ( timeout ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.closePanelsModal', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getModalForPanelsCloseButton() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.cancelAllUserActionAsk = function ( timeout ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.cancelAllUserActionAsk', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getButtonCancelUserAction() );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    self.ACTION.applyAllUserActionAsk = function ( timeout, force_click ) {
        var _to_return = 200;
        var _uuid      = SHINKEN.TOOLS.TEST_AUTO_LOGGER.add( timeout, 'ACTION.applyAllUserActionAsk', "" );
        setTimeout( function () {
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "IN_PROGRESS" );
            SHINKEN.TOOLS.TEST_AUTO_DOM.click( 0, self.DOM.getButtonApplyUserAction(), force_click );
            SHINKEN.TOOLS.TEST_AUTO_LOGGER.changeElementStatus( _uuid, "OK", _to_return );
        }, timeout );
        return _to_return;
    };
    
    //********************************************  CONSTANT **************************************************//
    
    return self;
})( SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANELS || {} );

SHINKEN.TOOLS.TEST_AUTO_UI_VISU_PANELS_CONST = {
    STATE: {
        HIDDEN      : 0,
        VISIBLE     : 1
    }
};