//__lib__ lib_common
"use strict";

CONTROLLER.CommonUI = (function ( self ) {
    self.controller_name = CONTROLLER.CONST.COMMON_UI.NAME;
    //********************************************  INIT  **************************************************//
    self.init            = function () {
    };
    //********************************************  EVENT LISTENER  **************************************************//
    self.doActionAfter       = function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "open_override_specific_display":
                var _doms = document.querySelectorAll( ".js_display_override_difference" );
                for ( let i = 0, _size_i = _doms.length; i < _size_i; i++ ) {
                    if ( i < 5 ) {
                        _doms[ i ].click();
                    }
                    else {
                        setTimeout( function (  ) {
                            _doms[ i ].click();
                        },i*200);
                    }
                }
                break;
        }
    };
    self.clickOnButton   = function ( event, event_name, param ) {
        let _dom_element_parent;
        switch ( event_name ) {
            case "close_popup_progress_bar":
                _dom_element_parent = DOM.Service.findParentElementWithClass( event.target, "shinken-popup-progress-bar-container", 10 );
                DOM.Service.setDataSet( _dom_element_parent, 'currentPhase', SHINKEN.OBJECT.CONST.PHASE.HIDDEN );
                break;
            case "toggle_display_popup_progress_bar_message":
                _dom_element_parent   = DOM.Service.findParentElementWithClass( event.target, "shinken-popup-progress-bar-container", 10 );
                var _is_message_displayed = _dom_element_parent.dataset.messageDisplayed === "1";
                DOM.Service.setDataSet( _dom_element_parent, 'messageDisplayed', _is_message_displayed ? "0" : "1" );
                break;
        }
        if ( event_name ) {
            event.stopPropagation();
        }
    };
    //********************************************  ACTION  **************************************************//
    
    //********************************************  GETTER / SETTER  **************************************************//
    
    return self;
})
( CONTROLLER.CommonUI || {} );

