//__lib__ lib_common
'use strict';


COMPONENT.InterfaceButton           = function () {
};
COMPONENT.InterfaceButton.prototype = {
    init: function () {
    },
    //********************************************  GETTER AND SETTER  ***********************************************//
    setState         : function ( to_set ) {
        this.state = to_set;
        if ( !this.dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltipHtml( _tooltip_by_state );
        }
    },
    toggleState      : function () {
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.setState( COMPONENT.CONST.BTN_STATE.OFF );
                break;
            case COMPONENT.CONST.BTN_STATE.OFF:
                this.setState( COMPONENT.CONST.BTN_STATE.ON );
                break;
        }
    },
    resetStateClass  : function () {
        if ( !this.dom_element ) {
            return;
        }
        this.dom_element.classList.remove( "shinken-active" );
        this.dom_element.classList.remove( "shinken-disabled" );
        this.dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    getValue         : function () {
        return this.value;
    },
    getUUID          : function () {
        return this.getValue();
    },
    getState         : function () {
        return this.state;
    },
    isOn             : function () {
        return this.state === COMPONENT.CONST.BTN_STATE.ON;
    },
    setInheritedLabel: function ( to_set ) {
        this.dom_element.querySelector( '.shinken-inherited-value' ).innerHTML = to_set;
    },
    addClass         : function ( to_add ) {
        this.dom_element.classList.add( to_add );
    },
    removeClass      : function ( to_remove ) {
        this.dom_element.classList.remove( to_remove );
    },
    setTooltipByState: function ( state, text_tooltip ) {
        this.tooltip_text          = this.tooltip_text || {};
        this.tooltip_text[ state ] = text_tooltip;
    },
    getTooltipByState: function () {
        if ( !this.tooltip_text ) {
            return;
        }
        return this.tooltip_text[ this.state ] || "";
    },
    //********************************************  COMPUTE  ***********************************************//
    computeCounters: function () {
        switch ( this.status ) {
            case COMPONENT.CONST.BTN_STATUS.ERROR:
                this.getCounterError().update( this.uuid, 1 );
                break;
            case COMPONENT.CONST.BTN_STATUS.WARNING:
                this.getCounterWarning().update( this.uuid, 1 );
                break;
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceButton, COMPONENT.Interface );


COMPONENT.Button           = function ( dom_element, name ) {
    this.__class_name__ = 'COMPONENT.Button';
    // dom_element
    // value
    // state
    // label
    // name
    this.uuid   = SHINKEN.TOOLS.STRING.buildUUID();
    this.state  = COMPONENT.CONST.BTN_STATE.OFF;
    this.status = COMPONENT.CONST.BTN_STATUS.NONE;
    this.name   = name;
    this.value  = '';
    this.init( dom_element );
};
COMPONENT.Button.prototype = {
    init          : function ( dom_element ) {
        this.dom_element = dom_element;
        if ( this.dom_element ) {
            this.initDomElement();
        }
        else {
            this.state = COMPONENT.CONST.BTN_STATE.DISABLED;
        }
        this._computeState();
    },
    initDomElement: function () {
        this.value = this.dom_element.value;
        if ( this.dom_element.classList.contains( 'shinken-error' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.ERROR;
        }
        else if ( this.dom_element.classList.contains( 'shinken-warning' ) ) {
            this.status = COMPONENT.CONST.BTN_STATUS.WARNING;
        }
    },
    _computeState : function () {
        if ( this.state === COMPONENT.CONST.BTN_STATE.DISABLED ) {
            return;
        }
        if ( this.dom_element.classList.contains( "shinken-active" ) ) {
            this.setState( COMPONENT.CONST.BTN_STATE.ON );
        }
    }
};

SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Button, COMPONENT.InterfaceButton );

COMPONENT.ButtonFromData           = function ( event_name, class_to_add, label ) {
    this.__class_name__ = 'COMPONENT.ButtonFromData';
    this.initSpecific( event_name, class_to_add, label );
    
};
COMPONENT.ButtonFromData.prototype = {
    setExtraParam: function ( to_set ) {
        this.extra_param = to_set;
    },
    initSpecific : function ( event_name, class_to_add, label ) {
        this.name         = event_name;
        this.label        = label || "";
        this.class_to_add = class_to_add;
        this.state        = COMPONENT.CONST.BTN_STATE.OFF;
    },
    computeHtml  : function () {
        this.setDomElement( DOM.Service.createElement( "button", {
            class                  : "shinken-label " + this.class_to_add,
            onclick                : "MANAGER.EventManager.clickOnButton(event, '" + this.name + "','" + this.extra_param + "' )",
            "data-visibility-state": this.getVisibilityState()
        }, this.label ) );
        var _tooltip_by_state = this.getTooltipByState();
        if ( _tooltip_by_state ) {
            this.setTooltipHtml( _tooltip_by_state );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.ButtonFromData, COMPONENT.InterfaceButton );


COMPONENT.RadioButtonFromData           = function ( value, label, property_name ) {
    this.__class_name__ = 'COMPONENT.RadioButtonFromData';
    this.initSpecific( value, label, property_name );
};
COMPONENT.RadioButtonFromData.prototype = {
    setState            : function ( to_set ) {
        this.state = to_set;
        if ( !this.button_dom_element ) {
            return;
        }
        this.resetStateClass();
        switch ( this.state ) {
            case COMPONENT.CONST.BTN_STATE.ON:
                this.button_dom_element.classList.add( "shinken-active" );
                break;
            case COMPONENT.CONST.BTN_STATE.DISABLED:
                this.button_dom_element.classList.add( "shinken-disabled" );
                break;
            case COMPONENT.CONST.BTN_STATE.ENABLED_WITH_ERRORS:
                this.button_dom_element.classList.add( "shinken-enabled-with-errors" );
                break;
        }
    },
    resetStateClass     : function () {
        if ( !this.dom_element ) {
            return;
        }
        this.button_dom_element.classList.remove( "shinken-active" );
        this.button_dom_element.classList.remove( "shinken-disabled" );
        this.button_dom_element.classList.remove( "shinken-enabled-with-errors" );
    },
    initSpecific        : function ( value, label, property_name ) {
        this.property_name    = property_name;
        this.param_name       = value;
        this.value            = value;
        this.label            = label || this.value;
        this.state            = COMPONENT.CONST.BTN_STATE.OFF;
    },
    computeHtml         : function () {
        this.setDomElement( DOM.Service.createElement( "td", { class: "shinken-btn-cell shinken-btn-user-cell", "data-visibility-state": this.getVisibilityState() } ) );
        var _class_button       = this.isOn() ? "shinken-radio-btn shinken-active" : "shinken-radio-btn";
        this.button_dom_element = this.addDomElement( DOM.Service.createElement( "button", {
            class  : _class_button,
            value  : this.getValue(),
            onclick: "MANAGER.EventManagerV2.clickRadioButton(event,'" + this.property_name + "', '" + this.param_name + "')"
        } ) );
        DOM.Service.addElementTo(DOM.Service.createElement("span", {class : "shinken-label"}, this.label), this.button_dom_element);
        if ( this.tooltip_html ){
            this.setTooltipHtml(this.tooltip_html, this.tooltip_type);
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.RadioButtonFromData, COMPONENT.ButtonFromData );