//__lib__ lib_common
'use strict';
COMPONENT.InterfaceLabel           = function () {
    this.__class_name__ = 'COMPONENT.Label';
    this.init();
};
COMPONENT.InterfaceLabel.prototype = {
    init       : function () {
    },
    setLabel   : function ( to_set ) {
        this.label = to_set;
        if ( this.dom_element_label ) {
            this.dom_element_label.innerHTML = this.label;
        }
    },
    getValue   : function () {
        return "";
    },
    hasLabel   : function () {
        return !!this.label;
    },
    updateLabel: function ( to_set ) {
        this.label = to_set;
        if ( this.dom_element ) {
            this.dom_element.innerHTML = this.label;
        }
    }
};


SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLabel, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.InterfaceLabel, COMPONENT.Interface );


COMPONENT.Label           = function ( dom_element ) {
    // dom_element
    // label
    this.init( dom_element );
};
COMPONENT.Label.prototype = {
    init: function ( dom_element ) {
        this.dom_element = dom_element;
        //if ( this.dom_element ) {
            this.label = this.dom_element.outerText;
        //}
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.Label, COMPONENT.InterfaceLabel );

COMPONENT.LabelFromData           = function ( label ) {
    this.__class_name__ = 'COMPONENT.LabelFromData';
    this.initSpecific( label );
};
COMPONENT.LabelFromData.prototype = {
    initSpecific: function ( label ) {
        this.label = label;
    }, //********************************************  HTML  *****************************************************//
    computeHtml : function () {
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-label-container " + this.getClass() } ) );
        this.dom_element_label = this.addDomElement( DOM.Service.createElement( "span", { class: "shinken-label" }, this.label ), this.dom_element );
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.LabelFromData, COMPONENT.InterfaceLabel );
SHINKEN.TOOLS.CLASS.addPrototype( COMPONENT.LabelFromData, SHINKEN.OBJECT.ShinkenObjectHtml );

