//__lib__ lib_shinken_V02_01
//priority 100

"use strict";

SHINKEN.OBJECT.FormSet           = function ( name ) {
    this.init( name );
};
SHINKEN.OBJECT.FormSet.prototype = {
    init: function ( name ) {
        this.name = name;
        this.initContents();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    doActionAfter : function ( event_name, param ) {
        this._doActionAfter( event_name, param );
    },
    _doActionAfter: function ( event_name, param ) {
    },
    hidePopup     : function ( property_name_exception ) {
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( _current.getName() !== property_name_exception ) {
                _current.hidePopup();
            }
        }
    },
    //********************************************  ACTIONS  *****************************************************//
    
    //********************************************  GETTER SETTER  *****************************************************//
    getName             : function () {
        return this.name;
    },
    isValid             : function () {
        return this.status !== COMPONENT.CONST.STATUS.ERROR;
    },
    computeFooterContent: function () {
        this.footer_content = null;
    },
    getFooterContent    : function () {
        return this.footer_content;
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function ( type ) {
        var _to_return = {};
        var _current;
        for ( var i = 0, _size_i = this.getSize(); i < _size_i; i++ ) {
            _current = this.getContent( i );
            if ( _current.getVisibilityState() === SHINKEN.CONST.VISIBILITY_STATE.TOTALLY_FORM_EXCLUDE ) {
                continue;
            }
            _to_return[ _current.getName() ] = _current.getDataToSave();
        }
        return _to_return;
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN.OBJECT.FormSet, SHINKEN.OBJECT.ShinkenObjectContainerHtml );