//__lib__ lib_shinken_V02_01
'use strict';
CONTROLLER.Form = (function ( self ) {
    self.controller_name     = CONTROLLER.CONST.FORM_CONTROLLER.NAME;
    //********************************************  EVENT LISTENER  **************************************************//
    self.onClick             = function ( event, event_name ) {
        event.stopPropagation();
        var _dom_target_property = DOM.Service.findParentElementWithClass( event.target, "shinken-element-property-line", 50 );
        if ( _dom_target_property ){
            self.current_form.hidePopup(_dom_target_property.dataset.name);
        } else {
            self.current_form.hidePopup();
        }
    };
    self.doActionAfter        = function ( event_name, param_1, param_2, param_3 ) {
        switch ( event_name ) {
            case "onchange_in_input":
                self.current_form.getContentByUUID( param_1 ).askComputeAfterChange();
                break;
            case "onclick_in_input":
                break;
            case "click_on_radio_button":
                self.current_form.getContentByUUID( param_1 ).clickOnRadioBtn( param_2 );
                break;
            case "click_on_button":
                self.current_form.getContentByUUID( param_1 ).doActionAfter( event_name, param_2 );
                break;
            case "click_on_selector":
                self.current_form.getContentByUUID( param_1 ).clickOnSelector( param_2 );
                break;
            case "click_on_item_selector":
                self.current_form.getContentByUUID( param_1 ).clickOnItemSelector( param_2, param_3 );
                break;
            default:
                console.warn("[FORM - doActionAfter]", "[UNKNOWN]", event_name );
                break;
        }
        self.current_form.hidePopup(param_1);
        self.current_form.doActionAfter(event_name, param_1, param_2, param_3);
    };
    self.mouseLeave          = function ( event ) {
    };
    self.mouseEnter          = function ( event ) {
    };
    //********************************************  INIT  **************************************************//
    self.init                = function () {
    };
    //********************************************  GETTER SETTER  **************************************************//
    self.setCurrentForm      = function ( to_set ) {
        self.current_form = to_set;
    };
    //********************************************  VALIDATION  **************************************************//
    self.isValid      = function ( to_set ) {
        this.current_form.computeValidation();
        return this.current_form.isValid();
    };
    self.getDataToSave      = function ( to_set ) {
        return this.current_form.getDataToSave();
    };
    return self;
})( CONTROLLER.Form || {} );
