//__lib__ lib_common
'use strict';

SHINKEN_LIST.SetFromData           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.SetFromData.prototype = {
    init            : function () {
    },
    computeLines    : function ( data ) {
        var _to_return = this.initLinesObjects();
        var _to_add;
        for ( var i = 0, _size = data.length; i < _size; i++ ) {
            _to_add = new SHINKEN_LIST.LineFromData( data[ i ], this.headers );
            _to_return.add( _to_add );
            _to_add.setIndexOriginal( i );
        }
        return _to_return;
    },
    initLinesObjects: function () {
        return new SHINKEN_LIST.LinesFromData();
    },
    //********************************************  HTML  *****************************************************//
    computeHtml            : function () {
        this.computeCommonHtml();
        this.computeSpecificHtml();
    },
    computeCommonHtml      : function () {
        this.headers.computeHtml();
        this.filters.computeHtml();
        this.computeLinesHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-container" } ) );
        var _table = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead = DOM.Service.createElement( "thead" );
        DOM.Service.addElementTo( this.headers.getDomElement(), _thead );
        DOM.Service.addElementTo( this.filters.getDomElement(), _thead );
        DOM.Service.addElementTo( _thead, _table );
        DOM.Service.addElementTo( this.lines.getDomElement(), _table );
        this.addDomElement( _table );
        this.computeHtmlExtra();
    },
    computeLinesHtml       : function () {
        this.lines.computeHtml();
    },
    computeSpecificHtml    : function () {
    
    },
    computeHtmlExtra       : function () {
        this.computeHtmlExtraCounter();
    },
    computeHtmlExtraCounter: function () {
        this.getCounterTotal().addTargetsDomElement( this.getDomElement(), "totalCounter" );
        let filtering_counter = this.getExtraCounterByName( "filtering" );
        if ( filtering_counter ) {
            filtering_counter.addTargetsDomElement( this.getDomElement(), "filteringCounter" );
        }
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromData, SHINKEN_LIST.Set );

SHINKEN_LIST.SetFromDataWithFixHeaderFilter           = function ( type ) {
    this.type = type;
    this.init();
};
SHINKEN_LIST.SetFromDataWithFixHeaderFilter.prototype = {
    //********************************************  HTML  *****************************************************//
    computeHtml: function () {
        this.headers.computeHtml();
        this.computeLinesHtml();
        this.setDomElement( DOM.Service.createElement( "div", { class: "shinken-list-container shinken-list-with-fix-header" } ) );
        if ( this.filters ) {
            this.filters.computeHtml();
            this.getDomElement().classList.add( "shinken-list-has-filters" );
        }
        //*******  First Table Header And Filter  *******//
        var _container_header_filter   = DOM.Service.createElement( "div", {
            class: "shinken-list-container-fix-header-filter"
        } );
        var _table_header_filter       = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table shinken-table" } );
        var _thead_table_header_filter = DOM.Service.createElement( "thead" );
        
        DOM.Service.addElementTo( this.headers.getDomElement(), _thead_table_header_filter );
        if ( this.filters ) {
            DOM.Service.addElementTo( this.filters.getDomElement(), _thead_table_header_filter );
        }
        DOM.Service.addElementTo( _thead_table_header_filter, _table_header_filter );
        DOM.Service.addElementTo( _table_header_filter, _container_header_filter );
        this.addDomElement( _container_header_filter );
        
        //*******  Second Table Header (Height 0px) And List  *******//
        var _container_header_list = DOM.Service.createElement( "div", { class: "shinken-list-container-with-scroll" } );
        var _table_list            = DOM.Service.createElement( "table", { class: "shinken-width-100 shinken-list-table" } );
        
        DOM.Service.addElementTo( this.lines.dom_element_text_no_elements, _table_list );
        DOM.Service.addElementTo( this.lines.getDomElement(), _table_list );
        
        
        DOM.Service.addElementTo( _table_list, _container_header_list );
        this.addDomElement( _container_header_list );
        
        this.computeHtmlExtra();
        this.computeSpecificHtml();
    }
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.SetFromDataWithFixHeaderFilter, SHINKEN_LIST.SetFromData );
