//__lib__ lib_common
//priority 100

"use strict";

SHINKEN_LIST.Set           = function () {
    this.init();
    this.edit_mode = false;
};
SHINKEN_LIST.Set.prototype = {
    init: function () {
        this.initPhase();
        this.initCounters();
    },
    //********************************************  EVENT LISTENER  *****************************************************//
    askComputeAfterChange: function ( dom_element ) {
        this.filters.askComputeAfterChange( dom_element, this );
        this.applyFilter();
        
    },
    doActionAfterChange  : function ( args ) {
        var _type = args[ "type" ];
        switch ( _type ) {
            case "shinken-list-filter":
                this.applyFilter();
                break;
            case "shinken-hide-all-element":
                this.lines.hideAllLines();
                break;
            case "shinken-list-sorting":
                this.lines.applySorting( this.headers.getActiveSortingHeaders() );
                break;
        }
    },
    doActionAfter        : function ( event_name, param ) {
        this._doActionAfter( event_name, param );
    },
    _doActionAfter       : function ( event_name, param ) {
    },
    clickOnCheckboxInput : function ( name ) {
        if ( name === "shinken-all-elements" ) {
            this.selectAllData( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ? SHINKEN_LIST.CONST.SELECTION.STATUS.OFF : SHINKEN_LIST.CONST.SELECTION.STATUS.ON );
            return;
        }
        this.lines.getContentByUUID( name ).toggleSelect();
        this.setSelectAllStatus();
    },
    clickOnCollapseButton: function ( uuid ) {
        if ( uuid === "shinken-all-elements" ) {
            this.collapseAllData( !this.is_all_data_collapsed );
            return;
        }
        this.lines.toggleCollapse( uuid );
        this.setIsCollapseAllData( this.lines.isAllActiveLineCollapsed() );
    },
    clickOnSelector      : function ( event, param ) {
        this._clickOnSelector( event, param );
    },
    _clickOnSelector     : function ( event, param ) {
        this.filters.clickOnSelector( event, param );
        this.lines.clickOnSelector( event, param );
    },
    clickOnInput         : function ( event ) {
        this.filters.clickOnInput( event );
        this.lines.clickOnInput( event );
    },
    clickOnItemSelector  : function ( event, parent_name, element ) {
        this._clickOnItemSelector( event, parent_name, element );
    },
    _clickOnItemSelector : function ( event, parent_name, element ) {
        this.filters.clickOnItemSelector( event, parent_name, element );
        this.lines.clickOnItemSelector( event, parent_name, element );
        var _parent_dom_element = DOM.Service.findParentElementWithDataSet( event.target, "name", 20 );
        this.doActionAfterChange( { "type": _parent_dom_element.dataset.objectType } );
    },
    onClick              : function ( event ) {
        this._onClick( event );
    },
    _onClick             : function ( event ) {
        if ( this.lines ) {
            this.lines.onClick( event );
        }
        if ( this.headers ) {
            this.headers.onClick( event );
        }
        if ( this.filters ) {
            this.filters.onClick( event );
        }
    },
    //********************************************  ACTIONS  *****************************************************//
    addLineWithData: function ( data ) {
        this.lines.addLineWithData( data, this.headers );
        this.updateHtml();
    },
    applyFilter    : function () {
        let active_filter = this.filters.getActiveFilters();
        if ( this.getDomElement() ) {
            DOM.Service.addOrRemoveClasses( this.getDomElement(), active_filter.length, "shinken-has-active-filter" );
        }
        this.lines.applyFilter( active_filter );
        this.setSelectAllStatus();
    },
    //********************************************  GETTER SETTER  *****************************************************//
    setHeaders            : function ( to_set ) {
        this.headers = to_set;
    },
    setFilters            : function ( to_set ) {
        this.filters = to_set;
    },
    setLines              : function ( to_set ) {
        if ( this.lines ) {
            this.lines.resetContents();
        }
        this.lines = to_set;
        this.addSynchronizedPhase( this.lines.phase );
        if ( this.getDomElement() && to_set.getDomElement() ) {
            var _content_list = this.getDomElement().querySelector( ".shinken-list-tbody" );
            if ( _content_list ) {
                DOM.Service.replaceChild( _content_list, to_set.getDomElement() );
            }
        }
    },
    initLines             : function ( to_set ) {
        this.lines = this.initLinesObjects();
        this.addSynchronizedPhase( this.lines.phase );
    },
    initLinesObjects      : function () {
        return new SHINKEN_LIST.Lines();
    },
    setIsCollapseAllData  : function ( to_set ) {
        this.is_all_data_collapsed = to_set;
        if ( this.is_all_data_collapsed ) {
            this.dom_element.classList.add( "shinken-collapsed" );
        }
        else {
            this.dom_element.classList.remove( "shinken-collapsed" );
        }
    },
    collapseAllData       : function ( to_set ) {
        this.setIsCollapseAllData( to_set );
        this.lines.setIsCollapseAllData( this.is_all_data_collapsed );
    },
    setSelectAllStatus    : function ( to_set ) {
        if ( to_set === undefined ) {
            to_set = this.lines.isAllActiveLineSelected() ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF;
        }
        this.is_all_data_selected = to_set;
        if ( this.is_all_data_selected === SHINKEN_LIST.CONST.SELECTION.STATUS.ON ) {
            this.dom_element.classList.add( "shinken-selected" );
        }
        else {
            this.dom_element.classList.remove( "shinken-selected" );
        }
        if ( this.checkbox ) {
            this.checkbox.setChecked( this.is_all_data_selected );
        }
    },
    selectAllData         : function ( to_set ) {
        this.setSelectAllStatus( to_set );
        this.lines.setSelectAllData( this.is_all_data_selected );
    },
    getSelectedLines      : function () {
        return this.lines.getSelected();
    },
    getFirstSelectedLine  : function () {
        var _to_return = this.getSelectedLines();
        if ( _to_return.length ) {
            return _to_return[ 0 ];
        }
        return null;
    },
    getNotSelectedLines   : function () {
        return this.lines.getNotSelected();
    },
    setAllLinesDataSet    : function ( datakey, data_value, if_key, if_values, else_data_value, if_function ) {
        return this.lines.setAllLinesDataSet( datakey, data_value, if_key, if_values, else_data_value, if_function );
    },
    removeLine            : function ( uuid ) {
        this.lines.remove( uuid );
        this.updateHtml();
    },
    getLineByUUID         : function ( uuid ) {
        return this.lines.getContentByUUID( uuid );
    },
    getSum                : function ( header_name ) {
        var _to_return = 0;
        var _lines     = this.lines.getNotFiltered();
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _to_return += parseInt( _lines[ i ].getCellValue( header_name ) || 0 );
        }
        return _to_return;
    },
    getSumBy              : function ( header_name, header_value ) {
        var _to_return = {};
        var _lines     = this.lines.getNotFiltered();
        var _current;
        for ( var i = 0, _size_i = _lines.length; i < _size_i; i++ ) {
            _current = _lines[ i ].getCellValue( header_name );
            if ( !_to_return[ _current ] ) {
                _to_return[ _current ] = 0;
            }
            _to_return[ _current ] += parseInt( _lines[ i ].getCellValue( header_value ) || 0 );
        }
        return _to_return;
    },
    toggleEditionMode     : function () {
        this.edit_mode = !this.edit_mode;
        this.selectAllData( this.edit_mode ? SHINKEN_LIST.CONST.SELECTION.STATUS.ON : SHINKEN_LIST.CONST.SELECTION.STATUS.OFF );
    },
    updateAfterActionsDone: function ( data ) {
        this.setMessages();
        var to_return = this.lines.updateAfterActionsDone( data );
        this.addMessages( this.lines.getMessages() );
        return to_return;
    },
    //********************************************  OTHERS  *****************************************************//
    hidePopup             : function ( _filter ) {
        if ( this.headers ) {
            this.headers.hidePopup( _filter );
        }
        if ( this.filters ) {
            this.filters.hidePopup( _filter );
        }
        if ( this.lines ) {
            this.lines.hidePopup( _filter );
        }
    },
    updateHtml            : function () {
        DOM.Service.setDataSet( this.dom_element, "numberLines", this.lines.contents.length );
    },
    applySiblingSettings  : function ( list_set ) {
        this.filters.applySiblingSettings( list_set.filters );
        this.lines.applySiblingSettings( list_set.lines );
    },
    cancelUserModification: function () {
        this.lines.cancelUserModification();
    },
    //********************************************  EXPORT DATA  *****************************************************//
    getDataToExport: function () {
        var _to_return = [this.headers.getDataToExport()];
        return SHINKEN.TOOLS.ARRAY.concat( _to_return, this.lines.getDataToExport( this.headers ) );
    },
    //********************************************  SAVE  *****************************************************//
    getDataToSave: function ( type ) {
        return this.lines.getDataToSave( type );
    }
    
};
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Set, SHINKEN.OBJECT.ShinkenObjectHtml );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Set, SHINKEN.OBJECT.CounterInterface );
SHINKEN.TOOLS.CLASS.addPrototype( SHINKEN_LIST.Set, SHINKEN.OBJECT.PhaseInterface );