//__lib__ lib_common
'use strict';

MANAGER.DistributorCounterManagerV2           = function () {
    this.counters = {};
    this.objects = {};
};
MANAGER.DistributorCounterManagerV2.prototype = {
    createCounter: function ( name, type ) {
        let _to_return = new SHINKEN.OBJECT.CounterV2(type);
        this.setCounter(name, _to_return);
        return _to_return;
    },
    deleteCounter       : function ( name ) {
        delete this.counters[ name ];
    },
    deleteObject       : function ( name ) {
        delete this.objects[ name ];
    },
    
    findCounter  : function ( name, type ) {
        if ( !name ) {
            return;
        }
        let _to_return = this.getCounter( name );
        if ( !_to_return ) {
            _to_return = this.createCounter( name, type );
        }
        return _to_return;
    },
    findObject  : function ( name ) {
        if ( !name ) {
            return;
        }
        return this.getObject( name );
    },
    
    setCounter   : function ( name, to_set ) {
        this.counters[ name ] = to_set;
    },
    setParentCounter   : function ( name_parent, counter_child ) {
        let _parent = this.getCounter(name_parent);
        if ( _parent ){
            counter_child.setParent(_parent);
        }
        else {
            //FILE D'attente ??
        }
    },
    setObject   : function ( name, to_set ) {
        this.objects[ name ] = to_set;
    },
    getCounter   : function ( name ) {
        return this.counters[ name ];
    },
    getObject   : function ( name ) {
        return this.objects[ name ];
    },
    reset       : function () {
        this.counters = {};
        this.objects = {};
    }
};
MANAGER.__instance_counter_distributorV2      = new MANAGER.DistributorCounterManagerV2();